/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.application;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Modules;
import com.yakindu.base.expressions.expressions.BoolLiteral;
import com.yakindu.base.expressions.expressions.DoubleLiteral;
import com.yakindu.base.expressions.expressions.ExpressionsFactory;
import com.yakindu.base.expressions.expressions.IntLiteral;
import com.yakindu.base.expressions.expressions.Literal;
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression;
import com.yakindu.base.expressions.expressions.StringLiteral;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypesPackage;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.IDomain;
import com.yakindu.sct.domain.validation.DomainValidator;
import com.yakindu.sct.generator.application.CommandLineOptions;
import com.yakindu.sct.generator.application.FileFinder;
import com.yakindu.sct.generator.application.GeneratorApplicationExtension;
import com.yakindu.sct.generator.application.PathUtils;
import com.yakindu.sct.generator.application.ProjectImporter;
import com.yakindu.sct.generator.core.execution.GeneratorExecutorLookup;
import com.yakindu.sct.generator.core.library.ICoreLibraryConstants;
import com.yakindu.sct.generator.genmodel.SGenStandaloneSetup;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgen.GeneratorModel;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.model.stext.STextRuntimeModule;
import com.yakindu.sct.model.stext.STextStandaloneSetup;
import com.yakindu.sct.model.stext.resource.StextResourceFactory;
import com.yakindu.sct.types.scoping.StatechartTypeModuleProvider;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.ResourceSetBasedResourceDescriptions;

public class GeneratorApplication
implements IApplication,
ICoreLibraryConstants {
    public static final String USED_TRANSACTIONAL_EDITING_DOMAIN = "com.yakindu.sct.domain";
    public static final String VM_ARG_USER_DIR = "user.dir";
    public static final List<String> FILE_EXTENSION_SCT = ImmutableList.of((Object)"sct", (Object)"ysc");
    public static final String FILE_EXTENSION_SGEN = "sgen";
    public static final String FILE_EXTENSION_PROJECT = "project";
    private static final String PREF_DESCRIPTION_AUTOBUILDING = "description.autobuilding";
    private static final String PREF_ORG_ECLIPSE_CORE_RESOURCES = "org.eclipse.core.resources";
    private static final String HEADER = "--------------------------------------------------------------\nSCC - itemis CREATE State Chart Compiler ((c) by itemis AG)\n\n\t  Visit http://www.statecharts.org\n--------------------------------------------------------------";
    private static final String METADATA_FILE = ".metadata";
    private static final String PROJECT_FILE = ".project";
    public static final int EXIT_ERROR = -1;
    private static final Logger LOGGER = Logger.getLogger(GeneratorApplication.class);
    protected String foundBaseDir = null;
    private ResourceSet resourceSet;
    private boolean prefAutoBuild;
    private boolean prefSctBuild;

    public GeneratorApplication() {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.WARN);
    }

    public Object start(IApplicationContext context) throws Exception {
        this.printHeader();
        String[] sctExecutionArguments = this.getArguments(context);
        CommandLineOptions cmdOptions = new CommandLineOptions();
        cmdOptions.parse(sctExecutionArguments);
        if (cmdOptions.containsHelp()) {
            cmdOptions.printHelp();
            return IApplication.EXIT_OK;
        }
        if (!cmdOptions.isValid()) {
            LOGGER.info((Object)"EXIT, because arguments are not valid.");
            return -1;
        }
        try {
            try {
                String workspaceRoot = this.adjustToWorkspaceRoot(this.getAbsoluteBaseDir(cmdOptions));
                if (workspaceRoot != null) {
                    this.foundBaseDir = workspaceRoot;
                } else {
                    workspaceRoot = this.getAbsoluteBaseDir(cmdOptions);
                }
                if (Platform.getInstanceLocation().isSet()) {
                    EValidator.Registry.INSTANCE.put((Object)SGraphPackage.eINSTANCE, (Object)new DomainValidator());
                }
                this.ensureDefaultWorkspaceLocationWillBeBaseDir(workspaceRoot);
                this.disableAutobuild();
                this.initSCTLanguage(cmdOptions);
                this.loadModels(cmdOptions);
                this.generateAll(cmdOptions);
            }
            catch (Throwable ex) {
                LOGGER.log((Priority)Level.ERROR, (Object)"Error", ex);
                Integer n = -1;
                this.restoreAutobuild();
                return n;
            }
        }
        finally {
            this.restoreAutobuild();
        }
        return IApplication.EXIT_OK;
    }

    private void disableAutobuild() {
        try {
            IEclipsePreferences node = DefaultScope.INSTANCE.getNode(PREF_ORG_ECLIPSE_CORE_RESOURCES);
            this.prefAutoBuild = node.getBoolean(PREF_DESCRIPTION_AUTOBUILDING, true);
            node.putBoolean(PREF_DESCRIPTION_AUTOBUILDING, false);
            node.flush();
            IEclipsePreferences node2 = DefaultScope.INSTANCE.getNode("com.yakindu.sct.generator.builder");
            this.prefSctBuild = node2.getBoolean("generate.automatically", true);
            node2.putBoolean("generate.automatically", false);
            node2.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void restoreAutobuild() {
        try {
            IEclipsePreferences node = DefaultScope.INSTANCE.getNode(PREF_ORG_ECLIPSE_CORE_RESOURCES);
            node.putBoolean(PREF_DESCRIPTION_AUTOBUILDING, this.prefAutoBuild);
            node.flush();
            IEclipsePreferences node2 = DefaultScope.INSTANCE.getNode("com.yakindu.sct.generator.builder");
            node2.putBoolean("generate.automatically", this.prefSctBuild);
            node2.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getAbsoluteBaseDir(CommandLineOptions cmdOptions) {
        return PathUtils.getAbsolutePath(System.getProperty(VM_ARG_USER_DIR), cmdOptions.getBaseDir());
    }

    protected void printHeader() {
        System.out.println(HEADER);
    }

    protected String[] getArguments(IApplicationContext context) {
        return (String[])context.getArguments().get("application.args");
    }

    protected void initSCTLanguage(CommandLineOptions cmdOptions) {
        new SGenStandaloneSetup().createInjectorAndDoEMFRegistration();
        Injector stextInjector = new STextStandaloneSetup(){

            public Injector createInjector() {
                Module module = Modules.combine((Module[])new Module[]{new STextRuntimeModule(), new StatechartTypeModuleProvider().getModule(new String[]{"com.yakindu.sct.headless"})});
                return Guice.createInjector((Module[])new Module[]{module});
            }
        }.createInjectorAndDoEMFRegistration();
        for (String ext : FILE_EXTENSION_SCT) {
            IResourceServiceProvider.Registry.INSTANCE.getExtensionToFactoryMap().put(ext, stextInjector.getInstance(IResourceServiceProvider.class));
            ResourceFactoryRegistryImpl.INSTANCE.getExtensionToFactoryMap().put(ext, new HeadlessStextResourceFactory());
        }
        for (GeneratorApplicationExtension setupExtension : this.getSetupExtensions()) {
            setupExtension.doSetup();
        }
        EValidator.Registry.INSTANCE.put((Object)SGraphPackage.eINSTANCE, (Object)new DomainValidator());
    }

    protected List<GeneratorApplicationExtension> getSetupExtensions() {
        IConfigurationElement[] configurationElements;
        ArrayList setupExtensions = Lists.newArrayList();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.yakindu.sct.generator.application.extension");
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            try {
                setupExtensions.add((GeneratorApplicationExtension)iConfigurationElement.createExecutableExtension("setupExtension"));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return setupExtensions;
    }

    protected void loadModels(CommandLineOptions options) {
        String absoluteBaseDir = this.getAbsoluteBaseDir(options);
        System.out.println("Loading models from: " + absoluteBaseDir);
        new ProjectImporter().importProjects(absoluteBaseDir);
        String[] modelPaths = options.getModelPaths();
        HashSet baseFileExtensions = Sets.newHashSet((Object[])new String[]{FILE_EXTENSION_SGEN});
        baseFileExtensions.addAll(FILE_EXTENSION_SCT);
        baseFileExtensions.addAll(this.getSetupExtensionFileExtensions());
        List<String> modelsToLoad = new FileFinder().findFilesDownwards(absoluteBaseDir, modelPaths, baseFileExtensions);
        System.out.println(modelsToLoad.size() + " base model(s) loaded. " + String.valueOf(baseFileExtensions));
        this.registerDomainSpecificFileExtensions(modelsToLoad);
        this.initResourceSet(modelsToLoad);
    }

    protected Collection<? extends String> getSetupExtensionFileExtensions() {
        HashSet fileExtensions = Sets.newHashSet();
        for (GeneratorApplicationExtension setupExtension : this.getSetupExtensions()) {
            fileExtensions.add(setupExtension.getFileExtension());
        }
        return fileExtensions;
    }

    protected Set<String> registerDomainSpecificFileExtensions(List<String> absoluteFiles) {
        HashSet domainSpecificFileExtensions = Sets.newHashSet();
        HashSet alreadyProcessedDomain = Sets.newHashSet();
        try {
            for (String baseFile : absoluteFiles) {
                Key fileExtBindingKey;
                String determineDomainID;
                if (!FILE_EXTENSION_SCT.stream().anyMatch(entry -> baseFile.endsWith((String)entry)) || alreadyProcessedDomain.contains(determineDomainID = DomainRegistry.determineDomainID((URI)URI.createFileURI((String)baseFile)))) continue;
                Injector domainResourceInjector = DomainRegistry.getDomain((String)determineDomainID).getInjector("com.yakindu.sct.resource", new String[]{"com.yakindu.sct.headless"});
                if (domainResourceInjector.getExistingBinding(fileExtBindingKey = Key.get((TypeLiteral)new TypeLiteral<List<String>>(){}, (Annotation)Names.named((String)"com.yakindu.sct.resource.file.ext"))) != null) {
                    List domainSpecificFileExt = (List)domainResourceInjector.getInstance(fileExtBindingKey);
                    for (String domainSpecificFileExtension : domainSpecificFileExt) {
                        this.registerResourceFactories(domainResourceInjector, domainSpecificFileExtension);
                        domainSpecificFileExtensions.add(domainSpecificFileExtension);
                    }
                }
                alreadyProcessedDomain.add(determineDomainID);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return domainSpecificFileExtensions;
    }

    protected void registerResourceFactories(Injector domainResourceInjector, String domainSpecificFileExtension) {
        if (domainResourceInjector.getExistingBinding(Key.get(IResourceServiceProvider.class)) != null) {
            IResourceServiceProvider.Registry.INSTANCE.getExtensionToFactoryMap().put(domainSpecificFileExtension, domainResourceInjector.getInstance(IResourceServiceProvider.class));
        }
        if (domainResourceInjector.getExistingBinding(Key.get(Resource.Factory.class)) != null) {
            ResourceFactoryRegistryImpl.INSTANCE.getExtensionToFactoryMap().put(domainSpecificFileExtension, domainResourceInjector.getInstance(Resource.Factory.class));
        }
    }

    protected void initResourceSet(List<String> absoluteFiles) {
        TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(USED_TRANSACTIONAL_EDITING_DOMAIN);
        if (editingDomain == null) {
            this.resourceSet = new ResourceSetImpl();
            editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(this.resourceSet);
            editingDomain.setID(USED_TRANSACTIONAL_EDITING_DOMAIN);
            TransactionalEditingDomain.Registry.INSTANCE.add(USED_TRANSACTIONAL_EDITING_DOMAIN, editingDomain);
        } else {
            this.resourceSet = editingDomain.getResourceSet();
        }
        this.replaceCrossReferenceAdapterWithNonResolvingAdapter(editingDomain);
        for (String absoluteFile : absoluteFiles) {
            this.loadIntoResourceSet(absoluteFile);
        }
    }

    protected void replaceCrossReferenceAdapterWithNonResolvingAdapter(TransactionalEditingDomain domain) {
        CrossReferenceAdapter adapter = this.getCrossReferenceAdapter(domain);
        if (adapter != null) {
            adapter.unsetTarget((Notifier)domain.getResourceSet());
            domain.getResourceSet().eAdapters().remove((Object)adapter);
            domain.getResourceSet().eAdapters().add((Object)new CrossReferenceAdapter(false));
        }
    }

    protected CrossReferenceAdapter getCrossReferenceAdapter(TransactionalEditingDomain domain) {
        EList eAdapters = domain.getResourceSet().eAdapters();
        for (Adapter adapter : eAdapters) {
            if (!(adapter instanceof CrossReferenceAdapter)) continue;
            return (CrossReferenceAdapter)adapter;
        }
        return null;
    }

    protected void ensureDefaultWorkspaceLocationWillBeBaseDir(String absoluteBaseDir) {
        Location instanceLocation = Activator.getDefault().getInstanceLocation();
        try {
            if (instanceLocation != null) {
                instanceLocation.set(new URL("file:" + absoluteBaseDir), false);
            }
        }
        catch (IllegalStateException e) {
            throw new RuntimeException("The instance location was already been set : " + String.valueOf(instanceLocation.getURL()));
        }
        catch (Exception e) {
            throw new RuntimeException("Error during workspace setup", e);
        }
    }

    protected Resource loadIntoResourceSet(String filePath) {
        Resource resource = null;
        try {
            resource = this.resourceSet.getResource(URI.createFileURI((String)filePath), true);
        }
        catch (Exception e) {
            System.err.println("Error loading resource '" + filePath + "': " + e.getMessage());
        }
        if (resource != null) {
            LOGGER.debug((Object)("Loaded resource " + String.valueOf(resource.getURI())));
        } else {
            LOGGER.debug((Object)("Resource not found " + filePath));
        }
        return resource;
    }

    protected void generateAll(CommandLineOptions options) {
        EList resources = this.resourceSet.getResources();
        ArrayList genModels = Lists.newArrayList();
        for (Resource resource : resources) {
            EObject content;
            EList contents = resource.getContents();
            if (contents.size() <= 0 || !((content = (EObject)contents.get(0)) instanceof GeneratorModel)) continue;
            genModels.add((GeneratorModel)content);
        }
        String generationBaseDir = this.getGenerationBaseDir(options, genModels);
        ArrayList exceptions = Lists.newArrayList();
        for (GeneratorModel generatorModel : genModels) {
            try {
                if (generatorModel.getGeneratorId().contains("image")) {
                    LOGGER.warn((Object)"Image generation with headless application is not supported");
                    continue;
                }
                this.processGenModel(options, generationBaseDir, generatorModel);
            }
            catch (RuntimeException e) {
                exceptions.add(e);
            }
        }
        if (exceptions.size() > 0) {
            throw (RuntimeException)exceptions.get(0);
        }
    }

    protected void processGenModel(CommandLineOptions options, String generationBaseDir, GeneratorModel generatorModel) {
        try {
            this.validateGenmodel(generatorModel);
            this.overrideVariables(generatorModel, options);
            this.validateEntries(generatorModel);
            this.execGenerator(options, generatorModel, generationBaseDir);
        }
        catch (Exception e) {
            throw new RuntimeException("Error during gen model execution (uri " + String.valueOf(generatorModel.eResource().getURI()) + ")", e);
        }
    }

    protected void validateGenmodel(GeneratorModel generatorModel) {
        if (generatorModel.eResource().getErrors().size() > 0) {
            throw new IllegalSctHeadlessArgumentException(((Resource.Diagnostic)generatorModel.eResource().getErrors().get(0)).getMessage());
        }
        Diagnostic diagnosticChain = Diagnostician.INSTANCE.validate((EObject)generatorModel);
        List diagnostics = diagnosticChain.getChildren();
        for (Diagnostic diagnostic : diagnostics) {
            if (diagnostic.getSeverity() != 4) continue;
            throw new IllegalSctHeadlessArgumentException(diagnostic.getMessage());
        }
    }

    protected void overrideVariables(GeneratorModel generatorModel, CommandLineOptions options) {
        Map<String, String> variables = options.getVariables();
        EList properties = generatorModel.getProperties();
        for (Property propertyDefinition : properties) {
            String overrideValue = variables.get(propertyDefinition.getName());
            if (overrideValue == null) continue;
            Literal literal = this.createLiteral(propertyDefinition.getType(), overrideValue);
            PrimitiveValueExpression valueExp = ExpressionsFactory.eINSTANCE.createPrimitiveValueExpression();
            valueExp.setValue(literal);
            TransactionalEditingDomain domain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(USED_TRANSACTIONAL_EDITING_DOMAIN);
            SetCommand command = new SetCommand((EditingDomain)domain, (EObject)propertyDefinition, (EStructuralFeature)TypesPackage.Literals.PROPERTY__INITIAL_VALUE, (Object)valueExp);
            domain.getCommandStack().execute((Command)command);
            variables.remove(propertyDefinition.getName());
        }
        if (variables.size() > 0) {
            LOGGER.warn((Object)("Ignoring variable " + variables.keySet().iterator().next()));
        }
    }

    protected Literal createLiteral(Type type, String value) {
        switch (type.getName()) {
            case "boolean": {
                BoolLiteral boolLiteral = ExpressionsFactory.eINSTANCE.createBoolLiteral();
                boolLiteral.setValue(Boolean.valueOf(value).booleanValue());
                return boolLiteral;
            }
            case "integer": {
                IntLiteral intLiteral = ExpressionsFactory.eINSTANCE.createIntLiteral();
                intLiteral.setValue((long)Integer.parseInt(value));
                return intLiteral;
            }
            case "real": {
                DoubleLiteral doubleLiteral = ExpressionsFactory.eINSTANCE.createDoubleLiteral();
                doubleLiteral.setValue(Double.parseDouble(value));
                return doubleLiteral;
            }
            case "string": {
                StringLiteral stringLiteral = ExpressionsFactory.eINSTANCE.createStringLiteral();
                stringLiteral.setValue(value.replaceAll("\"", "").replaceAll("'", ""));
                return stringLiteral;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type.getName());
    }

    protected void execGenerator(CommandLineOptions options, GeneratorModel generatorModel, final String generationBaseDir) throws Exception {
        GeneratorExecutorLookup genExecutorLookup = new GeneratorExecutorLookup(){

            protected Module getContextModule() {
                return GeneratorApplication.this.getHeadlessGeneratorModule(generationBaseDir);
            }

            protected Module getDomainGeneratorModule(GeneratorEntry entry, String generatorId) {
                return DomainRegistry.getDomain((EObject)entry.getElementRef()).getModule("com.yakindu.sct.generator", new String[]{generatorId, "com.yakindu.sct.headless"});
            }
        };
        IStatus status = genExecutorLookup.execute(generatorModel);
        if (4 == status.getSeverity()) {
            throw new Exception(status.getMessage());
        }
    }

    protected Module getHeadlessGeneratorModule(final String generationBaseDir) {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(String.class).annotatedWith((Annotation)Names.named((String)"filesystemAccess.absolute.baseDir")).toInstance((Object)generationBaseDir);
                binder.bind(IResourceDescriptions.class).to(ResourceSetBasedResourceDescriptions.class);
                binder.bind(IEncodingProvider.class).to(IEncodingProvider.Runtime.class);
            }
        };
    }

    protected String getGenerationBaseDir(CommandLineOptions options, List<GeneratorModel> genModels) {
        String absoluteBaseDir = this.getAbsoluteBaseDir(options);
        if (this.foundBaseDir == null) {
            String workspaceRoot = this.adjustToWorkspaceRoot(absoluteBaseDir);
            if (workspaceRoot == null) {
                System.out.println("Could not find .project or .metadata files!");
                System.out.println("Trying to locate the workspace via target project names...");
                workspaceRoot = this.findWorkspaceByProjectNames(absoluteBaseDir, genModels);
                if (workspaceRoot == null) {
                    System.out.println("Could not locate projects! Falling back to current working directory.");
                    workspaceRoot = absoluteBaseDir;
                }
            }
            this.foundBaseDir = workspaceRoot;
            System.out.println("Using baseDir: " + this.foundBaseDir);
        }
        return this.foundBaseDir;
    }

    protected String adjustToWorkspaceRoot(String absolutePath) {
        Path currentDir = Paths.get(absolutePath, new String[0]);
        File projectFile = currentDir.resolve(PROJECT_FILE).toFile();
        File metadataFile = currentDir.resolve(METADATA_FILE).toFile();
        while (!metadataFile.exists() && !projectFile.exists() && currentDir.toFile().getParentFile() != null) {
            currentDir = currentDir.toFile().getParentFile().toPath();
            projectFile = currentDir.resolve(PROJECT_FILE).toFile();
            metadataFile = currentDir.resolve(METADATA_FILE).toFile();
        }
        if (metadataFile.exists()) {
            LOGGER.debug((Object)"Found '.metadata'");
            return currentDir.toFile().getAbsolutePath();
        }
        if (projectFile.exists()) {
            LOGGER.debug((Object)"Found '.project'");
            return currentDir.toFile().getParentFile().getAbsolutePath();
        }
        return null;
    }

    protected String findWorkspaceByProjectNames(String absolutePath, List<GeneratorModel> genModels) {
        HashSet<String> projectNames = new HashSet<String>(genModels.size());
        for (GeneratorModel genModel : genModels) {
            for (GeneratorEntry entry : genModel.getEntries()) {
                String targetProject = entry.getFeatureParameterValue("Outlet", "targetProject").getStringValue();
                projectNames.add(targetProject);
            }
        }
        Path currentDir = Paths.get(absolutePath, new String[0]);
        ArrayList<String> foundProjects = new ArrayList<String>();
        while (currentDir.toFile().getParentFile() != null) {
            currentDir = currentDir.toFile().getParentFile().toPath();
            for (String projectName : projectNames) {
                if (!currentDir.resolve(projectName).toFile().exists()) continue;
                foundProjects.add(projectName);
            }
            if (foundProjects.size() == projectNames.size()) {
                String workspacePath = currentDir.toFile().getAbsolutePath();
                return workspacePath;
            }
            foundProjects.clear();
        }
        return null;
    }

    private void validateEntries(GeneratorModel generatorModel) throws Exception {
        for (GeneratorEntry generatorEntry : generatorModel.getEntries()) {
            EObject elementRef = generatorEntry.getElementRef();
            if (elementRef == null) {
                throw new IllegalSctHeadlessArgumentException("Element ref missing [" + String.valueOf(EcoreUtil.getURI((EObject)generatorEntry)) + "]");
            }
            if (elementRef.eResource() != null && !elementRef.eIsProxy()) continue;
            throw new IllegalSctHeadlessArgumentException("skipped gen model because of invalid element ref [ref :" + EcoreUtil.getURI((EObject)elementRef).toString() + "]");
        }
    }

    protected String getReadableCount(List<GeneratorModel> genModels, int generating) {
        return "(" + generating + " of " + genModels.size() + ")";
    }

    public void stop() {
    }

    protected static class HeadlessStextResourceFactory
    extends StextResourceFactory {
        protected HeadlessStextResourceFactory() {
        }

        protected Injector getInjector(IDomain domain) {
            return domain.getInjector("com.yakindu.sct.resource", new String[]{"com.yakindu.sct.headless"});
        }
    }

    protected static class IllegalSctHeadlessArgumentException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        IllegalSctHeadlessArgumentException(String s) {
            super(s);
        }
    }
}

