/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.application;

import com.google.common.collect.Sets;
import com.yakindu.sct.generator.application.FileFinder;
import com.yakindu.sct.generator.application.PathUtils;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class ProjectImporter {
    public void importProjects(String absoluteBaseDir) {
        FileFinder finder = new FileFinder();
        Set<String> folderPaths = this.getModelFolders(absoluteBaseDir, new String[]{""});
        List<String> projectFiles = finder.findFilesDownwards(absoluteBaseDir, folderPaths.toArray(new String[folderPaths.size()]), Sets.newHashSet((Object[])new String[]{"project"}));
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (projectFiles == null || projectFiles.isEmpty()) {
            projectFiles = finder.findFilesUpwards(absoluteBaseDir, folderPaths.toArray(new String[folderPaths.size()]), Sets.newHashSet((Object[])new String[]{"project"}));
        }
        for (String projectFile : projectFiles) {
            try {
                Path projectFilePath = new Path(projectFile);
                IProjectDescription description = workspace.loadProjectDescription((IPath)projectFilePath);
                String projectName = this.getProjectName(description, projectFilePath);
                IProject project = workspace.getRoot().getProject(projectName);
                if (!project.exists()) {
                    project.create(description, (IProgressMonitor)new NullProgressMonitor());
                }
                if (project.isOpen()) continue;
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                if (e.getMessage().equals("Invalid project description.")) {
                    throw new IllegalArgumentException("Seems there are errors within your .project configuration. (Maybe the ProjectName within .project differs from project folder name?)", e);
                }
                throw new RuntimeException("Error during project import.", e);
            }
        }
    }

    private String getProjectName(IProjectDescription description, Path path) {
        if (this.isDefaultLocation((IPath)path)) {
            return path.segment(path.segmentCount() - 2);
        }
        return description.getName();
    }

    private boolean isDefaultLocation(IPath path) {
        if (path.segmentCount() < 2) {
            return false;
        }
        return path.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
    }

    protected Set<String> getModelFolders(String absoluteBaseDir, String[] modelPaths) {
        HashSet folderPaths = Sets.newHashSet();
        folderPaths.add(PathUtils.getAbsolutePath(absoluteBaseDir, ""));
        String[] stringArray = modelPaths;
        int n = modelPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String absolutePath = PathUtils.getAbsolutePath(absoluteBaseDir, path);
            File file = new File(absolutePath);
            if (!file.isDirectory()) {
                folderPaths.add(file.getParent());
            } else {
                folderPaths.add(path);
            }
            ++n2;
        }
        return folderPaths;
    }
}

