/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.util;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class SWTUtil {
    private SWTUtil() {
    }

    public static void safeAsyncExec(Runnable runnable) {
        if (Display.getCurrent() != null) {
            Display.getCurrent().asyncExec(runnable);
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public static void safeSyncExec(Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display.getDefault().syncExec(runnable);
        }
    }

    public static void safeRefresh(final Viewer viewer, boolean async, final boolean checkDisposed) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (checkDisposed) {
                    Control control = viewer.getControl();
                    if (control != null && !control.isDisposed()) {
                        viewer.refresh();
                    }
                } else {
                    viewer.refresh();
                }
            }
        };
        if (async) {
            SWTUtil.safeAsyncExec(runnable);
        } else {
            SWTUtil.safeSyncExec(runnable);
        }
    }

    public static void safeRedraw(final Control control, boolean async) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!control.isDisposed()) {
                    control.redraw();
                }
            }
        };
        if (async) {
            SWTUtil.safeAsyncExec(runnable);
        } else {
            SWTUtil.safeSyncExec(runnable);
        }
    }
}

