/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.yet.core;

import java.util.Optional;

public abstract class YETEvent<T> {
    protected String key;
    protected T value;

    public YETEvent(String key, T value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public void removeKeyPrefix(String prefix) {
        if (this.key.startsWith(prefix)) {
            this.key = this.key.substring(prefix.length());
        }
        if (this.key.startsWith(".")) {
            this.key = this.key.substring(1);
        }
    }

    public abstract long getTimestamp();

    public T getValue() {
        return this.value;
    }

    public abstract boolean hasValue();

    public static class YETInitEvent
    extends YETEvent<String> {
        public YETInitEvent(String key, String value) {
            super(key, value);
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        public String toString() {
            return "%," + this.key + "," + (String)this.value;
        }

        @Override
        public long getTimestamp() {
            return 0L;
        }
    }

    public static class YETUpdateEvent
    extends YETEvent<Optional<String>> {
        protected long timestamp;

        public YETUpdateEvent(long timestamp, String key, String value) {
            this(timestamp, key, Optional.of(value));
        }

        public YETUpdateEvent(long timestamp, String key, Optional<String> value) {
            super(key, value);
            this.timestamp = timestamp;
        }

        public YETUpdateEvent(long timestamp, String key) {
            this(timestamp, key, Optional.empty());
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public boolean hasValue() {
            return ((Optional)this.value).isPresent();
        }

        public String toString() {
            return "#" + this.timestamp + "," + this.key + (String)(((Optional)this.value).isPresent() ? "," + (String)((Optional)this.value).get() : "");
        }
    }
}

