/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.yet.core;

import com.yakindu.yet.core.YETEvent;
import com.yakindu.yet.core.YETScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class YETTrace {
    protected Map<String, YETScope> scopes = new HashMap<String, YETScope>();
    protected List<YETEvent<?>> stimulationTrace = new ArrayList();
    protected List<YETEvent<?>> executionTrace = new ArrayList();
    protected long duration = 0L;
    protected long eventCnt = 0L;
    protected long currentTime = 0L;
    protected int currentExecutionIndex = 0;
    protected int currentStimulationIndex = 0;

    public void addScope(YETScope scope) {
        this.scopes.put(scope.name, scope);
    }

    public void stimulated(YETEvent<?> event) {
        this.stimulationTrace.add(event);
        this.duration = Math.max(this.duration, event instanceof YETEvent.YETUpdateEvent ? ((YETEvent.YETUpdateEvent)event).getTimestamp() : 0L);
    }

    public void executed(YETEvent<?> event) {
        this.executionTrace.add(event);
        this.duration = Math.max(this.duration, event instanceof YETEvent.YETUpdateEvent ? ((YETEvent.YETUpdateEvent)event).getTimestamp() : 0L);
    }

    public boolean hasFutureEvents() {
        return this.currentExecutionIndex < this.executionTrace.size();
    }

    public YETEvent<?> nextFutureEvent() {
        if (this.hasFutureEvents()) {
            return this.executionTrace.get(this.currentExecutionIndex);
        }
        return null;
    }

    public void consumeNextFutureEvent() {
        YETEvent<?> next = this.nextFutureEvent();
        if (next != null) {
            YETScope scope = this.scopeForEvent(next);
            if (scope != null) {
                scope.executed(next);
            }
            ++this.currentExecutionIndex;
        }
    }

    protected YETScope scopeForEvent(YETEvent<?> event) {
        String scopeId = this.scopes.keySet().stream().filter(name -> event.getKey().startsWith((String)name)).findFirst().orElse(null);
        if (scopeId != null) {
            return this.scopes.get(scopeId);
        }
        return null;
    }
}

