/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.yet.core.format;

import com.yakindu.yet.core.YETEvent;
import com.yakindu.yet.core.format.YETParserException;
import java.util.Optional;

public class YETParser {
    public YETEvent<?> parse(String message) throws YETParserException {
        if (message.startsWith("#")) {
            return this.parseUpdate(message);
        }
        if (message.startsWith("%")) {
            return this.parseInit(message);
        }
        throw new YETParserException("Invalid YET event: ");
    }

    protected YETEvent.YETUpdateEvent parseUpdate(String message) throws YETParserException {
        String[] split = (message = message.replace("#", "").trim()).split(",");
        if (split.length < 2 || split.length > 3) {
            throw new YETParserException("Invalid update event: " + message);
        }
        long timestamp = 0L;
        try {
            timestamp = Long.parseUnsignedLong(split[0]);
        }
        catch (NumberFormatException e) {
            throw new YETParserException("Invalid timestamp in event: " + split[0]);
        }
        String key = split[1];
        if (key == null || key.isEmpty()) {
            throw new YETParserException("Invalid update event: " + message);
        }
        Optional<String> value = split.length > 2 ? Optional.of(split[2]) : Optional.empty();
        return new YETEvent.YETUpdateEvent(timestamp, key, value);
    }

    protected YETEvent.YETInitEvent parseInit(String message) throws YETParserException {
        String[] split = (message = message.replace("%", "").trim()).split(",");
        if (split.length != 2) {
            throw new YETParserException("Invalid init event: " + message);
        }
        String key = split[0];
        String value = split[1];
        if (key == null || key.isEmpty() || value == null || value.isEmpty()) {
            throw new YETParserException("Invalid init event: " + message);
        }
        return new YETEvent.YETInitEvent(key, value);
    }
}

