/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sgraph.util;

import com.google.common.collect.Iterables;
import com.yakindu.sct.model.sgraph.Entry;
import com.yakindu.sct.model.sgraph.EntryKind;
import com.yakindu.sct.model.sgraph.FinalState;
import com.yakindu.sct.model.sgraph.Pseudostate;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.RegularState;
import com.yakindu.sct.model.sgraph.SGraphFactory;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class SgraphExtensions {
    public SGraphFactory factory() {
        return SGraphFactory.eINSTANCE;
    }

    protected boolean _isLeaf(RegularState s) {
        return false;
    }

    protected boolean _isLeaf(FinalState s) {
        return true;
    }

    protected boolean _isLeaf(State s) {
        return s.isSimple();
    }

    public List<RegularState> parentStates(RegularState s) {
        return IterableExtensions.toList((Iterable)Iterables.filter(this.containers((EObject)s), RegularState.class));
    }

    public List<RegularState> parentStates(Region s) {
        return IterableExtensions.toList((Iterable)Iterables.filter(this.containers((EObject)s), RegularState.class));
    }

    public RegularState parentState(EObject obj) {
        return (RegularState)IterableExtensions.head((Iterable)Iterables.filter((Iterable)EcoreUtil2.getAllContainers((EObject)obj), RegularState.class));
    }

    public List<EObject> containers(EObject obj) {
        ArrayList<EObject> containerList = new ArrayList<EObject>();
        this.collectContainers(obj, containerList);
        return containerList;
    }

    public void collectContainers(EObject obj, List<EObject> containerList) {
        boolean _tripleNotEquals;
        containerList.add(obj);
        EObject _eContainer = null;
        if (obj != null) {
            _eContainer = obj.eContainer();
        }
        boolean bl = _tripleNotEquals = _eContainer != null;
        if (_tripleNotEquals) {
            this.collectContainers(obj.eContainer(), containerList);
        }
    }

    public Iterable<Entry> collectEntries(Region r) {
        return Iterables.filter(r.getVertices(), Entry.class);
    }

    public Entry entry(Region r) {
        Functions.Function1 _function = v -> v instanceof Entry && (v.getName() == null || "".equals(v.getName()) || Objects.equals(v.getName(), "default"));
        Vertex _findFirst = (Vertex)IterableExtensions.findFirst(r.getVertices(), (Functions.Function1)_function);
        return (Entry)_findFirst;
    }

    public State target(Entry entry) {
        Vertex obj;
        Transition _transition = this.transition(entry);
        Vertex _target = null;
        if (_transition != null) {
            _target = _transition.getTarget();
        }
        if ((obj = _target) instanceof State) {
            return (State)obj;
        }
        return null;
    }

    public Transition transition(Entry entry) {
        boolean _tripleNotEquals;
        EList<Transition> _outgoingTransitions = null;
        if (entry != null) {
            _outgoingTransitions = entry.getOutgoingTransitions();
        }
        boolean bl = _tripleNotEquals = _outgoingTransitions != null;
        if (_tripleNotEquals) {
            boolean _greaterThan;
            int _size = entry.getOutgoingTransitions().size();
            boolean bl2 = _greaterThan = _size > 0;
            if (_greaterThan) {
                return (Transition)entry.getOutgoingTransitions().get(0);
            }
        }
        return null;
    }

    public Iterable<RegularState> allStates(EObject it) {
        Functions.Function1 _function = it_1 -> true;
        return this.allStates(it, (Functions.Function1<? super RegularState, ? extends Boolean>)_function);
    }

    protected Iterable<RegularState> _allStates(EObject it, Functions.Function1<? super RegularState, ? extends Boolean> condition) {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList());
    }

    protected Iterable<RegularState> _allStates(Statechart it, Functions.Function1<? super RegularState, ? extends Boolean> condition) {
        Functions.Function1 _function = it_1 -> this.allStates((EObject)it_1, condition);
        return Iterables.concat((Iterable)ListExtensions.map((List)it.getRegions(), (Functions.Function1)_function));
    }

    protected Iterable<RegularState> _allStates(Region it, Functions.Function1<? super RegularState, ? extends Boolean> condition) {
        Functions.Function1 _function = it_1 -> this.allStates((EObject)it_1, condition);
        return Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter(it.getVertices(), RegularState.class), (Functions.Function1)_function));
    }

    protected Iterable<RegularState> _allStates(RegularState it, Functions.Function1<? super RegularState, ? extends Boolean> condition) {
        if (condition == null || ((Boolean)condition.apply((Object)it)).booleanValue()) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new RegularState[]{it}));
        }
        return null;
    }

    protected Iterable<RegularState> _allStates(State it, Functions.Function1<? super RegularState, ? extends Boolean> condition) {
        ArrayList<RegularState> _xblockexpression = null;
        ArrayList<RegularState> states = new ArrayList<RegularState>();
        if (condition == null || ((Boolean)condition.apply((Object)it)).booleanValue()) {
            states.add(it);
        }
        Functions.Function1 _function = it_1 -> this.allStates((EObject)it_1, condition);
        Iterable _flatten = Iterables.concat((Iterable)ListExtensions.map((List)it.getRegions(), (Functions.Function1)_function));
        Iterables.addAll(states, (Iterable)_flatten);
        _xblockexpression = states;
        return _xblockexpression;
    }

    protected Iterable<Pseudostate> _getAllPseudoStates(State it) {
        Functions.Function1 _function = it_1 -> this.getAllPseudoStates(it_1);
        return Iterables.concat((Iterable)ListExtensions.map((List)it.getRegions(), (Functions.Function1)_function));
    }

    protected Iterable<Pseudostate> _getAllPseudoStates(Region it) {
        return Iterables.filter(it.getVertices(), Pseudostate.class);
    }

    protected Iterable<Pseudostate> _getAllPseudoStates(List<?> it) {
        Functions.Function1 _function = it_1 -> this.getAllPseudoStates(it_1);
        return Iterables.concat((Iterable)ListExtensions.map(it, (Functions.Function1)_function));
    }

    protected Iterable<Pseudostate> _getAllPseudoStates(EObject it) {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList());
    }

    protected Iterable<Pseudostate> _getAllPseudoStates(Object it) {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList());
    }

    protected Iterable<Pseudostate> _getAllPseudoStates(Void it) {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList());
    }

    public HashMap<Region, List<Entry>> getRegionsWithoutDefaultEntry(List<Region> it) {
        Functions.Function1 _function = r -> {
            Functions.Function1 _function_1 = e -> e.isDefault();
            return IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.eContents(), Entry.class), (Functions.Function1)_function_1));
        };
        Functions.Function1 _function_1 = r -> {
            List _list = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)Iterables.filter((Iterable)r.eContents(), Entry.class), Entry.class));
            return Pair.of((Object)r, (Object)_list);
        };
        return CollectionLiterals.newHashMap((Pair[])((Pair[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)IterableExtensions.filter(it, (Functions.Function1)_function), (Functions.Function1)_function_1), Pair.class)));
    }

    public boolean requireDeepHistory(Region r) {
        Functions.Function1 _function = p -> {
            Functions.Function1 _function_1 = v -> {
                EntryKind _kind = v.getKind();
                return Objects.equals((Object)_kind, (Object)EntryKind.DEEP_HISTORY);
            };
            return IterableExtensions.exists((Iterable)Iterables.filter(p.getVertices(), Entry.class), (Functions.Function1)_function_1);
        };
        return IterableExtensions.exists((Iterable)Iterables.filter(this.containers((EObject)r), Region.class), (Functions.Function1)_function);
    }

    public boolean requireShallowHistory(Region r) {
        Functions.Function1 _function = v -> {
            EntryKind _kind = v.getKind();
            return Objects.equals((Object)_kind, (Object)EntryKind.SHALLOW_HISTORY);
        };
        return IterableExtensions.exists((Iterable)Iterables.filter(r.getVertices(), Entry.class), (Functions.Function1)_function);
    }

    public boolean requireHistory(Region r) {
        return this.requireDeepHistory(r) || this.requireShallowHistory(r);
    }

    public Statechart getStatechart(EObject element) {
        Statechart _xblockexpression = null;
        if (element == null) {
            return null;
        }
        _xblockexpression = (Statechart)EcoreUtil2.getContainerOfType((EObject)element, Statechart.class);
        return _xblockexpression;
    }

    public boolean interleaveLocalReactions(Statechart it) {
        return true;
    }

    @XbaseGenerated
    public boolean isLeaf(RegularState s) {
        if (s instanceof FinalState) {
            return this._isLeaf((FinalState)s);
        }
        if (s instanceof State) {
            return this._isLeaf((State)s);
        }
        if (s != null) {
            return this._isLeaf(s);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(s).toString());
    }

    @XbaseGenerated
    public Iterable<RegularState> allStates(EObject it, Functions.Function1<? super RegularState, ? extends Boolean> condition) {
        if (it instanceof State && condition != null) {
            return this._allStates((State)it, condition);
        }
        if (it instanceof RegularState && condition != null) {
            return this._allStates((RegularState)it, condition);
        }
        if (it instanceof Region && condition != null) {
            return this._allStates((Region)it, condition);
        }
        if (it instanceof Statechart && condition != null) {
            return this._allStates((Statechart)it, condition);
        }
        if (it != null && condition != null) {
            return this._allStates(it, condition);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, condition).toString());
    }

    @XbaseGenerated
    public Iterable<Pseudostate> getAllPseudoStates(Object it) {
        if (it instanceof State) {
            return this._getAllPseudoStates((State)it);
        }
        if (it instanceof Region) {
            return this._getAllPseudoStates((Region)it);
        }
        if (it instanceof List) {
            return this._getAllPseudoStates((List)it);
        }
        if (it instanceof EObject) {
            return this._getAllPseudoStates((EObject)it);
        }
        if (it == null) {
            return this._getAllPseudoStates((Void)null);
        }
        return this._getAllPseudoStates(it);
    }
}

