/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sgraph.util;

import com.yakindu.base.types.EnumerationType;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.adapter.OriginTracing;
import com.yakindu.sct.commons.StreamUtils;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.util.DFS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class SubchartDFS
extends DFS {
    @Override
    public Iterator<Property> getElementLinks(Object element) {
        if (element instanceof Statechart) {
            return SubchartDFS.getSubcharts((Statechart)element).iterator();
        }
        if (element instanceof Property) {
            Property variableDefinition = (Property)element;
            return SubchartDFS.getSubcharts(SubchartDFS.getStatechart(variableDefinition)).iterator();
        }
        return new ArrayList().iterator();
    }

    @Override
    public boolean isVisited(Object element) {
        return super.isVisited(element) && this.getVisitedDepth(element) >= 0;
    }

    public static Statechart getStatechart(Property definition) {
        String originalExtension = definition.getType().eResource().getURI().fileExtension().replace("_types", "");
        URI statemachineURI = definition.getType().eResource().getURI().trimFileExtension().appendFileExtension(originalExtension);
        if (!URIConverter.INSTANCE.exists(statemachineURI, null)) {
            OriginTracing tracing = new OriginTracing();
            Object origin = tracing.origin((EObject)definition.getType());
            if (origin != null && origin instanceof Statechart) {
                return (Statechart)origin;
            }
            return null;
        }
        Object set = null;
        set = definition.eResource() != null && definition.eResource().getResourceSet() != null ? definition.eResource().getResourceSet() : new ResourceSetImpl();
        Resource resource = set.getResource(statemachineURI, true);
        Statechart statechart = (Statechart)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SGraphPackage.Literals.STATECHART);
        return statechart;
    }

    public static List<Property> getSubcharts(Statechart element) {
        return element.getScopes().stream().flatMap(scope -> scope.getDeclarations().stream()).flatMap(StreamUtils.select(Property.class)).filter(v -> v.getType() != null && v.getType().eResource() != null).filter(v -> !(v.getType() instanceof EnumerationType)).filter(v -> SubchartDFS.ofTypeStatechart(v)).collect(Collectors.toList());
    }

    private static boolean ofTypeStatechart(Property v) {
        if (v.getType().eResource() != null && v.getType().eResource().getURI().fileExtension() != null) {
            return v.getType().eResource().getURI().fileExtension().endsWith("ysc_types") || v.getType().eResource().getURI().fileExtension().endsWith("sct_types");
        }
        return false;
    }

    public static List<Statechart> getAllStatecharts(Statechart statechart) {
        final ArrayList<Statechart> allStatecharts = new ArrayList<Statechart>();
        SubchartDFS search = new SubchartDFS(){

            @Override
            public void beginVisit(Object element, Object parent, int depth) {
                Statechart sc = null;
                if (element instanceof Statechart) {
                    sc = (Statechart)element;
                } else if (element instanceof Property) {
                    sc = 1.getStatechart((Property)element);
                }
                if (!allStatecharts.contains(sc)) {
                    allStatecharts.add(sc);
                }
            }
        };
        search.perform(statechart);
        return allStatecharts;
    }
}

