/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sgraph.validation;

import com.yakindu.sct.model.sgraph.Entry;
import com.yakindu.sct.model.sgraph.EntryKind;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.validation.AbstractSGraphValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;

public class EntryValidator
extends AbstractSGraphValidator {
    private static final String ENTRY_TRANSITIONS_NO_IN_IF_INITIAL_MSG = "Initial entry should have no incoming transition.";
    public static final String ENTRY_TRANSITIONS_NO_IN_IF_INITIAL_CODE = "entry.transitions.NoInIfInitial";
    private static final String ENTRY_TRANSITIONS_REQUIRE_OUT_IF_INITIAL_MSG = "Initial entry must have an outgoing transition.";
    public static final String ENTRY_TRANSITIONS_REQUIRE_OUT_IF_INITIAL_CODE = "entry.transitions.RequireOutIfInitial";
    private static final String ENTRY_TRANSITIONS_NO_MULTIPLE_OUT_MSG = "Entries must not have more than one outgoing transition.";
    public static final String ENTRY_TRANSITIONS_NO_MULTIPLE_OUT_CODE = "entry.transitions.NoMultipleOut";
    private static final String ENTRY_TRANSITIONS_NO_TRIGGER_ON_OUT_MSG = "The outgoing transitions of an entry must not have a trigger or guard.";
    public static final String ENTRY_TRANSITIONS_NO_TRIGGER_ON_OUT_CODE = "entry.transitions.NoTriggerOnOut";

    @Check(value=CheckType.FAST)
    public void checkEntryTransitionsNoInIfInitial(Entry entry) {
        if (entry.getIncomingTransitions().size() > 0 && entry.getKind().equals((Object)EntryKind.INITIAL)) {
            this.warning(ENTRY_TRANSITIONS_NO_IN_IF_INITIAL_MSG, (EObject)entry, null, -1, ENTRY_TRANSITIONS_NO_IN_IF_INITIAL_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkEntryTransitionsRequireOneOutIfInitial(Entry entry) {
        if (entry.getKind().equals((Object)EntryKind.INITIAL) && entry.getOutgoingTransitions().size() == 0) {
            this.error(ENTRY_TRANSITIONS_REQUIRE_OUT_IF_INITIAL_MSG, (EObject)entry, null, -1, ENTRY_TRANSITIONS_REQUIRE_OUT_IF_INITIAL_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkEntryTransitionsNoMultipleOut(Entry entry) {
        if (entry.getOutgoingTransitions().size() > 1) {
            this.error(ENTRY_TRANSITIONS_NO_MULTIPLE_OUT_MSG, (EObject)entry, null, -1, ENTRY_TRANSITIONS_NO_MULTIPLE_OUT_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkEntryTransitionsNoTriggerOnOut(Entry entry) {
        for (Transition transition : entry.getOutgoingTransitions()) {
            if (transition.getTrigger() == null) continue;
            this.error(ENTRY_TRANSITIONS_NO_TRIGGER_ON_OUT_MSG, (EObject)entry, null, -1, ENTRY_TRANSITIONS_NO_TRIGGER_ON_OUT_CODE, new String[0]);
        }
    }
}

