/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sgraph.validation;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.yakindu.sct.model.sgraph.Choice;
import com.yakindu.sct.model.sgraph.CompositeElement;
import com.yakindu.sct.model.sgraph.Entry;
import com.yakindu.sct.model.sgraph.EntryKind;
import com.yakindu.sct.model.sgraph.Exit;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.Synchronization;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.sgraph.util.SgraphExtensions;
import com.yakindu.sct.model.sgraph.validation.AbstractSGraphValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;

public class RegionValidator
extends AbstractSGraphValidator {
    @Inject
    SgraphExtensions sgraphExtension;
    private static final String REGION_REQUIRES_DEFAULT_ENTRY_IF_ENTERED_BY_SHALLOW_HISTORY_MSG = "The region can't be entered using the shallow history. Add a default entry node.";
    public static final String REGION_REQUIRES_DEFAULT_ENTRY_IF_ENTERED_BY_SHALLOW_HISTORY_CODE = "region.RequiresDefaultEntryIfEnteredByShallowHistory";
    private static final String REGION_REQUIRES_DEFAULT_ENTRY = "The region can't be entered in all cases. Add a 'default' entry.";
    public static final String REGION_REQUIRES_DEFAULT_ENTRY_CODE = "region.RequiresDefaultEntry";
    private static final String REGION_NO_MULTIPLE_DEFAULT_ENTRIES_MSG = "There are multiple default entry nodes (one without a name and one named 'default') in this region.";
    public static final String REGION_MUST_NOT_HAVE_MULTIPLE_DEFAULT_ENTRIES_CODE = "region.MustNotHaveMultipleDefaultEntries";
    private static final String REGION_NO_EXIT_ON_TOP_LEVEL_MSG = "Exit node in top level region not supported - use final states instead.";
    public static final String REGION_NO_EXIT_ON_TOP_LEVEL_CODE = "region.NoExitOnTopLevel";
    private static final String REGION_ENTRY_TARGET_MUST_BE_CHILD_MSG = "Entry target must be child of the region.";
    public static final String REGION_ENTRY_TARGET_MUST_BE_CHILD_CODE = "region.EntryTargetMustBeChild";
    private static final String REGION_NEEDS_DEFAULT_ENTRY_WHEN_HISTORY_HAS_NO_OUTGOING_MSG = "The region should have a default entry pointing to the initial state.";
    public static final String REGION_NEEDS_DEFAULT_ENTRY_WHEN_HISTORY_HAS_NO_OUTGOING_CODE = "region.HistoryWithoutOutgoingNeedsDefaultEntry";
    private static final String REGION_UNBOUND_DEFAULT_ENTRY_POINT_MSG = "Region must have a 'default' entry.";
    public static final String REGION_UNBOUND_DEFAULT_ENTRY_POINT_CODE = "region.NoDefaultEntry";
    private static final String TOP_LEVEL_REGION_ENTRY_HAVE_TO_BE_A_DEFAULT_ENTRY_MSG = "Entry of top level region has to be a default entry.";
    public static final String TOP_LEVEL_REGION_ENTRY_HAVE_TO_BE_A_DEFAULT_ENTRY_CODE = "region.EntryNoDefault";

    @Check(value=CheckType.FAST)
    public void checkRegionRequiresDefaultEntryIfEnteredByShallowHistory(Region region) {
        List shallowHistories = region.getVertices().stream().filter(v -> v instanceof Entry && ((Entry)v).getKind() == EntryKind.SHALLOW_HISTORY).map(entry -> (Entry)entry).collect(Collectors.toList());
        for (Entry e : shallowHistories) {
            ArrayList<Region> regions = new ArrayList<Region>();
            for (Vertex v2 : e.getParentRegion().getVertices()) {
                if (!(v2 instanceof CompositeElement)) continue;
                regions.addAll((Collection<Region>)((CompositeElement)((Object)v2)).getRegions());
            }
            for (Region r : regions) {
                Entry defaultEntry = null;
                for (Vertex v3 : r.getVertices()) {
                    if (!(v3 instanceof Entry) || !((Entry)v3).isDefault()) continue;
                    defaultEntry = (Entry)v3;
                    break;
                }
                if (defaultEntry != null) continue;
                this.error(REGION_REQUIRES_DEFAULT_ENTRY_IF_ENTERED_BY_SHALLOW_HISTORY_MSG, (EObject)r, null, -1, REGION_REQUIRES_DEFAULT_ENTRY_IF_ENTERED_BY_SHALLOW_HISTORY_CODE, new String[0]);
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkRegionRequiresDefaultEntry(Region region) {
        if (this.isTopLevelRegion(region) || this.existsDefaultEntry(region)) {
            return;
        }
        State parentState = (State)this.sgraphExtension.parentState((EObject)region);
        if (parentState == null || parentState.getRegions().size() <= 1) {
            return;
        }
        Set localActivators = this.incomingTransitions(region).stream().map(this::activator).collect(Collectors.toSet());
        Optional<EObject> uncoveredActivators = parentState.getRegions().stream().filter(r -> r != region).flatMap(r -> this.incomingTransitions((Region)r).stream()).map(this::activator).filter(activator -> !localActivators.contains(activator)).findAny();
        if (uncoveredActivators.isPresent()) {
            this.error(REGION_REQUIRES_DEFAULT_ENTRY, (EObject)region, null, -1, REGION_REQUIRES_DEFAULT_ENTRY_CODE, new String[0]);
        }
    }

    protected EObject activator(Transition t) {
        Synchronization sync = this.syncSource(t);
        return sync != null ? sync : t;
    }

    protected Synchronization syncSource(Transition t) {
        Choice choice;
        Vertex source = t.getSource();
        if (source instanceof Synchronization) {
            Synchronization syncSyncSource;
            Synchronization sync = (Synchronization)source;
            if (sync.getIncomingTransitions().size() == 1 && (syncSyncSource = this.syncSource((Transition)sync.getIncomingTransitions().get(0))) != null) {
                return syncSyncSource;
            }
            return sync;
        }
        if (source instanceof Choice && (choice = (Choice)source).getIncomingTransitions().size() == 1) {
            return this.syncSource((Transition)choice.getIncomingTransitions().get(0));
        }
        return null;
    }

    protected List<Transition> incomingTransitions(Region r) {
        EList<Vertex> vertices = r.getVertices();
        List<Transition> transitions = vertices.stream().map(v -> this.incomingTransitions((Vertex)v)).flatMap(Collection::stream).filter(t -> !vertices.contains((Object)t.getSource())).collect(Collectors.toList());
        return transitions;
    }

    protected List<Transition> incomingTransitions(Vertex v) {
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        transitions.addAll((Collection<Transition>)v.getIncomingTransitions());
        if (v instanceof CompositeElement) {
            ((CompositeElement)((Object)v)).getRegions().stream().forEach(r -> transitions.addAll(this.incomingTransitions((Region)r)));
        }
        return transitions;
    }

    @Check
    public void checkRegionMustNotHaveMultipleDefaultEntries(Entry entry) {
        boolean defaultNamedEntryExists;
        Region region = (Region)entry.eContainer();
        List initialEntires = region.getVertices().stream().filter(Entry.class::isInstance).map(Entry.class::cast).filter(v -> v.getKind() == EntryKind.INITIAL).collect(Collectors.toList());
        boolean unamedEntryExists = initialEntires.stream().filter(v -> v.getName().trim().equals("")).count() > 0L;
        boolean bl = defaultNamedEntryExists = initialEntires.stream().filter(v -> v.getName().trim().equalsIgnoreCase("default")).count() > 0L;
        if (unamedEntryExists && defaultNamedEntryExists) {
            this.error(REGION_NO_MULTIPLE_DEFAULT_ENTRIES_MSG, (EObject)region, null, -1, REGION_MUST_NOT_HAVE_MULTIPLE_DEFAULT_ENTRIES_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkRegionNoExitOnTopLevel(Region region) {
        if (region.getComposite() instanceof Statechart) {
            region.getVertices().stream().filter(v -> v instanceof Exit).forEach(exit -> this.error(REGION_NO_EXIT_ON_TOP_LEVEL_MSG, (EObject)exit, null, -1, REGION_NO_EXIT_ON_TOP_LEVEL_CODE, new String[0]));
        }
    }

    @Check(value=CheckType.FAST)
    public void checkRegionEntryTargetMustBeChild(Region region) {
        region.getVertices().stream().filter(v -> v instanceof Entry).forEach(entry -> entry.getOutgoingTransitions().stream().forEach(t -> {
            if (!this.isChildOrSibling(t.getSource(), t.getTarget())) {
                this.error(REGION_ENTRY_TARGET_MUST_BE_CHILD_MSG, (EObject)t, null, -1, REGION_ENTRY_TARGET_MUST_BE_CHILD_CODE, new String[0]);
            }
        }));
    }

    @Check(value=CheckType.FAST)
    public void checkDefaultEntryExistsWhenHistoryHasNoOutgoingTransition(Region region) {
        if (this.existsHistoryWithoutOutgoingTransition(region) && !this.existsDefaultEntry(region)) {
            this.warning(REGION_NEEDS_DEFAULT_ENTRY_WHEN_HISTORY_HAS_NO_OUTGOING_MSG, (EObject)region, null, -1, REGION_NEEDS_DEFAULT_ENTRY_WHEN_HISTORY_HAS_NO_OUTGOING_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkTopLevelRegionHasEntry(Region region) {
        if (this.isTopLevelRegion(region) && !this.sgraphExtension.getRegionsWithoutDefaultEntry(Collections.singletonList(region)).isEmpty()) {
            this.error(REGION_UNBOUND_DEFAULT_ENTRY_POINT_MSG, (EObject)region, null, -1, REGION_UNBOUND_DEFAULT_ENTRY_POINT_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkTopLeveEntryIsDefaultEntry(Entry entry) {
        Region parentRegion = entry.getParentRegion();
        if (this.isTopLevelRegion(parentRegion) && !entry.isDefault()) {
            HashMap<Region, List<Entry>> regionsWithoutDefaultEntry = this.sgraphExtension.getRegionsWithoutDefaultEntry(Lists.newArrayList((Object[])new Region[]{parentRegion}));
            List list = (List)regionsWithoutDefaultEntry.get(parentRegion);
            if (list != null) {
                this.error(TOP_LEVEL_REGION_ENTRY_HAVE_TO_BE_A_DEFAULT_ENTRY_MSG, (EObject)entry, (EStructuralFeature)SGraphPackage.Literals.ENTRY__KIND, -1, TOP_LEVEL_REGION_ENTRY_HAVE_TO_BE_A_DEFAULT_ENTRY_CODE, new String[0]);
            } else {
                this.warning(TOP_LEVEL_REGION_ENTRY_HAVE_TO_BE_A_DEFAULT_ENTRY_MSG, (EObject)entry, (EStructuralFeature)SGraphPackage.Literals.ENTRY__KIND, -1, TOP_LEVEL_REGION_ENTRY_HAVE_TO_BE_A_DEFAULT_ENTRY_CODE, new String[0]);
            }
        }
    }

    protected boolean isTopLevelRegion(Region region) {
        return region.eContainer() instanceof Statechart;
    }

    protected boolean existsDefaultEntry(Region region) {
        Stream<Entry> entries = region.getVertices().stream().filter(Entry.class::isInstance).map(Entry.class::cast);
        return entries.filter(v -> v.getKind() == EntryKind.INITIAL).anyMatch(v -> v.isDefault());
    }

    protected boolean existsHistoryWithoutOutgoingTransition(Region region) {
        Stream<Entry> entries = region.getVertices().stream().filter(Entry.class::isInstance).map(Entry.class::cast);
        return entries.filter(v -> v.getKind() == EntryKind.SHALLOW_HISTORY || v.getKind() == EntryKind.DEEP_HISTORY).anyMatch(v -> v.getOutgoingTransitions().isEmpty());
    }

    protected boolean isChildOrSibling(Vertex source, Vertex target) {
        TreeIterator iter = source.getParentRegion().eAllContents();
        while (iter.hasNext()) {
            if (target != iter.next()) continue;
            return true;
        }
        return false;
    }
}

