/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.notification.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class NotificationUIActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.yakindu.licmgmt.ui.notification";
    public static final String YAKINDU_IMAGE_KEY = "com.yakindu.licmgmt.ui.notification.YAKINDU_Image";
    private static final Map<String, String> IMAGE_PATHS = new HashMap<String, String>(){
        {
            this.put(NotificationUIActivator.YAKINDU_IMAGE_KEY, "icons/yakindu-32.png");
        }
    };
    private static NotificationUIActivator plugin;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
    }

    public Image getImage(String imageKey) {
        Image existingImage = this.getImageRegistry().get(imageKey);
        if (existingImage != null) {
            return existingImage;
        }
        String path = IMAGE_PATHS.get(imageKey);
        if (path != null) {
            Image image = NotificationUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path).createImage();
            if (image != null) {
                this.getImageRegistry().put(imageKey, image);
                return image;
            }
            IMAGE_PATHS.remove(imageKey);
            this.getLog().log((IStatus)new Status(2, PLUGIN_ID, "NotificationUIActivator.getImage(" + imageKey + ") could not find image: " + path));
        } else {
            System.err.println("NotificationUIActivator.getImage(): unknown image key: " + imageKey);
        }
        return null;
    }

    public static Image getImage(int swtImageId) {
        Display display = Display.getDefault();
        Image[] image = new Image[1];
        display.syncExec(() -> {
            Image image = display.getSystemImage(swtImageId);
        });
        return image[0];
    }

    public static final NotificationUIActivator getDefault() {
        return plugin;
    }
}

