/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.notification.popup;

import com.yakindu.licmgmt.ui.notification.popup.NotificationPopup;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class NotificationService {
    private static int NOTIFICATION_DELAY = 5000;
    private static NotificationService notificationService;
    private ConcurrentLinkedQueue<UIJob> jobQueue = new ConcurrentLinkedQueue();
    private Job notificationIndicator = new Job("Notification Indicator"){
        public boolean isStopped;
        {
            this.isStopped = false;
        }

        protected IStatus run(IProgressMonitor monitor) {
            while (!NotificationService.this.jobQueue.isEmpty() && !this.isStopped) {
                NotificationService.this.jobQueue.poll().schedule();
                try {
                    Thread.sleep(NOTIFICATION_DELAY);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return Status.OK_STATUS;
        }
    };

    public static NotificationService getInstance() {
        if (notificationService == null) {
            notificationService = new NotificationService();
        }
        return notificationService;
    }

    public static void stopIndication() {
        if (notificationService != null && NotificationService.notificationService.notificationIndicator != null) {
            NotificationService.notificationService.notificationIndicator.cancel();
        }
    }

    public void addNotification(final String title, final String message, final Map<String, Runnable> actions, final int severity) {
        UIJob notificationJob = new UIJob(Display.getDefault(), "NotificationJob " + title){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                NotificationPopup.notify(title, message, actions, severity);
                return Status.OK_STATUS;
            }
        };
        notificationJob.setPriority(50);
        this.jobQueue.add(notificationJob);
        if (this.notificationIndicator.getState() != 2 || this.notificationIndicator.getState() != 4 || this.notificationIndicator.getState() != 1) {
            this.notificationIndicator.schedule();
        }
    }
}

