/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.base;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.TimeEventSpec;
import com.yakindu.base.types.Property;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.util.SubchartDFS;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import com.yakindu.sct.model.stext.extensions.STextExtensions;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import com.yakindu.sctunit.generator.base.extensions.BaseNamingExtensions;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public abstract class AbstractSubchartInitializer
extends SubchartDFS {
    @Inject
    @Extension
    protected BaseNamingExtensions _baseNamingExtensions;
    @Inject
    @Extension
    protected STextExtensions _sTextExtensions;
    @Inject
    @Extension
    protected StatechartAnnotations _statechartAnnotations;
    public String initSequence = null;
    public String teardownSequence = null;
    public Map<Statechart, CharSequence> imports = null;
    public Stack<VariableDefinition> variableStack = null;
    public List<Statechart> subcharts = null;
    public Statechart root;

    public abstract void buildInitSequence(Statechart var1, VariableDefinition var2);

    public abstract void buildTeardownSequence(Statechart var1, VariableDefinition var2);

    public void buildImports(Statechart subchart) {
    }

    public void beginVisit(Object element, Object parent, int depth) {
        Statechart subchart;
        if (element instanceof VariableDefinition && !EcoreUtil.equals((EObject)(subchart = SubchartDFS.getStatechart((Property)((Property)element))), (EObject)this.root) && !this._sTextExtensions.isInternal((EObject)element)) {
            this.variableStack.push((VariableDefinition)element);
            this.buildInitSequence(subchart, (VariableDefinition)element);
            this.buildTeardownSequence(subchart, (VariableDefinition)element);
            this.buildImports(subchart);
            this.subcharts.add(subchart);
        }
    }

    public void endVisit(Object element, Object parent, int depth, int minDepth) {
        Statechart subchart;
        if (element instanceof VariableDefinition && !EcoreUtil.equals((EObject)(subchart = SubchartDFS.getStatechart((Property)((Property)element))), (EObject)this.root) && !this._sTextExtensions.isInternal((EObject)element)) {
            this.variableStack.pop();
        }
    }

    public synchronized void perform(Object root) {
        if (root instanceof Statechart) {
            this.root = (Statechart)root;
        }
        this.initSequence = "";
        this.teardownSequence = "";
        this.imports = Maps.newHashMap();
        Stack _stack = new Stack();
        this.variableStack = _stack;
        this.subcharts = Lists.newArrayList();
        super.perform(root);
    }

    public String getSubchartInitSequence(Statechart it) {
        String _elvis = null;
        if (this.initSequence != null) {
            _elvis = this.initSequence;
        } else {
            String _xblockexpression = null;
            this.perform(it);
            _elvis = _xblockexpression = this.initSequence;
        }
        return _elvis;
    }

    public String getSubchartTeardownSequence(Statechart it) {
        String _elvis = null;
        if (this.teardownSequence != null) {
            _elvis = this.teardownSequence;
        } else {
            String _xblockexpression = null;
            this.perform(it);
            _elvis = _xblockexpression = this.teardownSequence;
        }
        return _elvis;
    }

    public Map<Statechart, CharSequence> getSubchartImports(Statechart it) {
        Map<Statechart, CharSequence> _elvis = null;
        if (this.imports != null) {
            _elvis = this.imports;
        } else {
            Map<Statechart, CharSequence> _xblockexpression = null;
            this.perform(it);
            _elvis = _xblockexpression = this.imports;
        }
        return _elvis;
    }

    public List<Statechart> getReferencedSubcharts(Statechart it) {
        List<Statechart> _elvis = null;
        if (this.subcharts != null) {
            _elvis = this.subcharts;
        } else {
            List<Statechart> _xblockexpression = null;
            this.perform(it);
            _elvis = _xblockexpression = this.subcharts;
        }
        return _elvis;
    }

    public boolean hasTimedSubchart(Statechart it) {
        Functions.Function1 _function = it_1 -> this.isTimed((Statechart)it_1);
        return IterableExtensions.exists(this.getReferencedSubcharts(it), (Functions.Function1)_function);
    }

    public boolean hasCycleBasedSubchart(Statechart it) {
        Functions.Function1 _function = it_1 -> this._statechartAnnotations.isCycleBased(it_1);
        return IterableExtensions.exists(this.getReferencedSubcharts(it), (Functions.Function1)_function);
    }

    public boolean needsTimer(Statechart it) {
        return this._statechartAnnotations.isCycleBased(it) || this.isTimed(it) || this.hasCycleBasedSubchart(it) || this.hasTimedSubchart(it);
    }

    public boolean isTimed(Statechart it) {
        int _size = IteratorExtensions.size((Iterator)Iterators.filter((Iterator)it.eAllContents(), TimeEventSpec.class));
        return _size > 0;
    }
}

