/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.base;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.yakindu.sct.generator.core.execution.AbstractGeneratorEntryExecutor;
import com.yakindu.sct.generator.core.execution.NoLicenseFSAWrapper;
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess;
import com.yakindu.sct.license.LicenseChecker;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sctunit.generator.base.ISCTUnitGenerator;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite;
import com.yakindu.sctunit.sCTUnit.TestPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.generator.IFileSystemAccess;

public class SCTUnitGeneratorExecuter
extends AbstractGeneratorEntryExecutor {
    @Inject
    protected Injector injector;
    @Inject
    protected ISCTUnitGenerator generator;

    public void execute(ISCTFileSystemAccess fsa, GeneratorEntry generatorEntry) {
        boolean _not;
        boolean _isLicenseValid = this.isLicenseValid();
        boolean bl = _not = !_isLicenseValid;
        if (_not) {
            NoLicenseFSAWrapper _noLicenseFSAWrapper = new NoLicenseFSAWrapper(fsa);
            this.generator.generate(generatorEntry, (IFileSystemAccess)_noLicenseFSAWrapper);
        } else {
            this.generator.generate(generatorEntry, (IFileSystemAccess)fsa);
        }
    }

    protected boolean isLicenseValid() {
        return new LicenseChecker().checkStandardLicense().isValidOrTrial();
    }

    public void logStart(GeneratorEntry entry) {
        EObject element = entry.getElementRef();
        String elementName = "";
        String elementType = "";
        String targetProject = "";
        targetProject = this.getTargetProjectName(entry);
        if (element instanceof TestPackage) {
            elementName = ((TestPackage)element).getName();
            elementType = TestPackage.class.getSimpleName();
        }
        if (element instanceof SCTUnitClass) {
            elementName = ((SCTUnitClass)element).getName();
            elementType = SCTUnitClass.class.getSimpleName();
        }
        if (element instanceof SCTUnitSuite) {
            elementName = ((SCTUnitSuite)element).getName();
            elementType = SCTUnitSuite.class.getSimpleName();
        }
        this.logger.log(String.format("Generating %s '%s' to target project '%s' ...", elementType, elementName, targetProject));
    }

    public String getTargetProjectName(GeneratorEntry entry) {
        return this.helper.getTargetProjectValue(entry).getStringValue();
    }

    public String getJavaPackageForProjectName(String targetProject) {
        return targetProject.replaceAll("\\.", "/");
    }

    public TestPackage getTestModel(GeneratorEntry entry) {
        EObject _eContainer = entry.getElementRef().eContainer();
        return (TestPackage)_eContainer;
    }

    public String getTargetFolderPath(GeneratorEntry entry) {
        return this.helper.getTargetFolderValue(entry).getStringValue();
    }
}

