/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.java.ui.editor;

import com.yakindu.sct.domain.common.FileLocationAdapter;
import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;

public class JavaFileEditorOpener
implements IURIEditorOpener {
    public static final String JAVA_EDITOR_ID = "org.eclipse.jdt.ui.CompilationUnitEditor";
    public static final String CLASS_EDITOR_ID = "org.eclipse.jdt.ui.ClassFileEditor";

    public IEditorPart open(URI uri, boolean select) {
        try {
            IEditorPart part;
            Object input = this.getInput(uri);
            if (input != null && (part = EditorUtility.openInEditor((Object)input)) != null) {
                this.selectAndReveal(part, uri);
                return part;
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void selectAndReveal(IEditorPart part, URI uri) {
        TransactionalEditingDomain domain;
        EObject eObject;
        FileLocationAdapter exitingAdapter;
        if (uri.fragment() != null && (exitingAdapter = (FileLocationAdapter)EcoreUtil.getExistingAdapter((Notifier)(eObject = (domain = DiagramPartitioningUtil.getSharedDomain()).getResourceSet().getEObject(uri, true)), FileLocationAdapter.class)) != null && part instanceof ITextEditor) {
            ((ITextEditor)part).selectAndReveal(exitingAdapter.getOffset(), exitingAdapter.getLength());
        }
    }

    protected Object getInput(URI uri) {
        if (uri.isPlatformResource()) {
            return this.toFile(uri);
        }
        return this.toClassFile(uri);
    }

    protected IClassFile toClassFile(URI uri) {
        if (!uri.hasQuery()) {
            return null;
        }
        String projectName = uri.query();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            String fqn = String.join((CharSequence)".", uri.trimFileExtension().segmentsList());
            IType javaType = javaProject.findType(fqn);
            return javaType.getClassFile();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IFile toFile(URI uri) {
        return (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(uri.toPlatformString(true)));
    }

    public IEditorPart open(URI referenceOwnerURI, EReference reference, int indexInList, boolean select) {
        return this.open(referenceOwnerURI, select);
    }
}

