/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter;

import com.yakindu.base.expressions.interpreter.Signature;
import com.yakindu.base.expressions.interpreter.base.InterpreterException;
import com.yakindu.base.types.Enumerator;
import com.yakindu.base.types.Type;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Function {
    protected Method functionMethod;
    protected Map<Signature, Function> functionMap = new HashMap<Signature, Function>();

    public Function lookup(Class<?> functionClass, String name, Class<?> ... paramTypes) {
        ArrayList<Method> functionMethods = new ArrayList<Method>();
        this.addFunctionMethods(functionClass, functionMethods);
        Collections.sort(functionMethods, new PolymorphicComparator());
        for (Method fMethod : functionMethods) {
            FunctionMethod fAnno = fMethod.getAnnotation(FunctionMethod.class);
            if (!name.equals(fMethod.getName()) && !name.equals(fAnno.value()) || !Function.isCallable(paramTypes, fMethod.getParameterTypes())) continue;
            return Function.createFunction(functionClass, fMethod);
        }
        return null;
    }

    private void addFunctionMethods(Class<?> functionClass, List<Method> methodList) {
        ArrayList<Method> result = new ArrayList<Method>();
        Method[] methods = functionClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method fMethod = methods[i];
            FunctionMethod fAnno = fMethod.getAnnotation(FunctionMethod.class);
            if (fAnno != null) {
                result.add(fMethod);
            }
            ++i;
        }
        methodList.addAll(result);
        if (functionClass.getSuperclass() != null) {
            this.addFunctionMethods(functionClass.getSuperclass(), methodList);
        }
    }

    private static boolean isCallable(Class<?>[] paramTypes, Class<?>[] parameterTypes) {
        if (paramTypes.length != parameterTypes.length) {
            return false;
        }
        int i = 0;
        while (i < paramTypes.length) {
            Class<?> class2 = parameterTypes[i];
            Class<?> class1 = paramTypes[i];
            if (!class2.isAssignableFrom(class1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Function lookup(Class<?> functionClass, String name, Object ... params) {
        Class<?>[] paramTypes = this.toParamTypes(params);
        return this.lookup(functionClass, name, paramTypes);
    }

    protected Class<?>[] toParamTypes(Object ... params) {
        Class[] paramTypes = new Class[params.length];
        int i = 0;
        while (i < params.length) {
            paramTypes[i] = params[i] == null ? Object.class : params[i].getClass();
            ++i;
        }
        return paramTypes;
    }

    protected static Function createFunction(Class<?> functionClass, Method functionMethod) {
        if (functionClass == null || functionMethod == null) {
            return null;
        }
        try {
            Constructor<?> constr;
            try {
                constr = functionClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Missing default constructor in class " + functionClass.getName() + " while loading function " + functionMethod.getName() + " !");
            }
            Function func = (Function)constr.newInstance(new Object[0]);
            func.setFunctionMethod(functionMethod);
            return func;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading function " + functionMethod.getName() + " from function class " + functionClass.getName() + " !", e);
        }
    }

    public Method getFunctionMethod() {
        return this.functionMethod;
    }

    public void setFunctionMethod(Method functionMethod) {
        this.functionMethod = functionMethod;
    }

    public Object execute(Object[] params) {
        try {
            return this.getFunctionMethod().invoke((Object)this, params);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public Object evaluate(String name, Object ... params) {
        Function lookup = this.lookup(name, params);
        if (lookup == null) {
            throw new InterpreterException("No function definition found for '" + name + "' with parameters: " + Arrays.toString(params));
        }
        return lookup.execute(params);
    }

    protected void assertSameType(Type t1, Type t2) {
        if (t1 != t2) {
            throw new InterpreterException("Function '" + this.functionMethod.getName() + "' can't be applied to different types " + t1.getName() + " and " + t2.getName());
        }
    }

    protected void assertSameType(Enumerator e1, Enumerator e2) {
        this.assertSameType((Type)e1.getOwningEnumeration(), (Type)e2.getOwningEnumeration());
    }

    protected Function lookup(String name, Object ... params) {
        Signature sig = new Signature(name, this.toParamTypes(params));
        Function f = this.functionMap.get(sig);
        if (f == null) {
            f = this.lookup(this.getClass(), name, sig.getParamTypes());
            this.functionMap.put(sig, f);
        }
        return f;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface FunctionMethod {
        public String value();
    }

    public static class PolymorphicComparator
    implements Comparator<Method> {
        @Override
        public int compare(Method method1, Method method2) {
            Class<?>[] parameterTypes2;
            Class<?>[] parameterTypes1 = method1.getParameterTypes();
            if (parameterTypes1.length > (parameterTypes2 = method2.getParameterTypes()).length) {
                return -1;
            }
            if (parameterTypes1.length < parameterTypes2.length) {
                return 1;
            }
            int i = 0;
            while (i < parameterTypes1.length) {
                Class<?> class1 = parameterTypes1[i];
                Class<?> class2 = parameterTypes2[i];
                if (!class1.equals(class2)) {
                    if (class1.isAssignableFrom(class2) || Void.class.equals(class2)) {
                        return 1;
                    }
                    if (class2.isAssignableFrom(class1) || Void.class.equals(class1)) {
                        return -1;
                    }
                }
                ++i;
            }
            return 0;
        }
    }
}

