/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter.base;

public class Clock {
    public static final long NO_TIME = Long.MIN_VALUE;
    private long time = Long.MIN_VALUE;
    private long systemRefTime = Long.MIN_VALUE;
    private double timeScale = 1.0;
    protected boolean suspended = false;

    public double getTimeScale() {
        return this.timeScale;
    }

    public void setTimeScale(double timeScale) {
        if (timeScale <= 0.0) {
            throw new IllegalArgumentException("Time scale must not be zero or smaller.");
        }
        this.timeScale = timeScale;
    }

    public void start() {
        this.suspended = false;
        this.setTime(0L);
    }

    public long getTime() {
        if (this.time != Long.MIN_VALUE && !this.suspended) {
            this.time = (long)((double)(System.currentTimeMillis() - this.systemRefTime) * this.timeScale);
        }
        return this.time;
    }

    public void setTime(long ms) {
        this.time = ms;
        if (this.time != Long.MIN_VALUE && !this.suspended) {
            this.systemRefTime = System.currentTimeMillis() - (long)((double)this.time / this.timeScale);
        } else if (this.time == Long.MIN_VALUE) {
            this.systemRefTime = Long.MIN_VALUE;
        }
    }

    public void suspend() {
        if (this.suspended) {
            throw new IllegalStateException("clock is already suspended");
        }
        this.suspended = true;
        this.systemRefTime = Long.MIN_VALUE;
    }

    public void resume() {
        if (!this.suspended) {
            throw new IllegalStateException("clock is not suspended");
        }
        this.suspended = false;
        this.setTime(this.time);
    }

    public void stop() {
        this.time = Long.MIN_VALUE;
        this.systemRefTime = Long.MIN_VALUE;
        this.suspended = false;
    }
}

