/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter.base;

import com.yakindu.base.expressions.interpreter.base.Clock;
import com.yakindu.base.expressions.interpreter.base.IInterpreter;
import com.yakindu.base.expressions.interpreter.scheduling.ITimeTaskScheduler;
import com.yakindu.base.expressions.interpreter.scheduling.TaskScheduler;
import com.yakindu.core.IEventDriven;
import com.yakindu.core.ITimed;
import com.yakindu.core.ITimerService;
import com.yakindu.core.ITracingListener;
import com.yakindu.core.rx.Observable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class InterpreterSessionControl
implements ITimed,
IEventDriven {
    private final State[] stateVector = new State[3];
    private List<ITracingListener<State>> ifaceTraceObservers = new LinkedList<ITracingListener<State>>();
    private ITimerService timerService;
    private final boolean[] timeEvents = new boolean[1];
    private BlockingQueue<Runnable> inEventQueue = new LinkedBlockingQueue<Runnable>();
    private boolean isExecuting;
    private long stateConfVectorPosition;
    private OperationCallback operationCallback;
    private boolean start;
    private boolean suspend;
    private boolean step;
    private boolean resume;
    private boolean terminate;
    private boolean modeChanged;
    private Observable<Void> modeChangedObservable = new Observable();
    private boolean next;
    private boolean done;
    private boolean workSuspended;
    private boolean suspendWork;
    private boolean continueWork;
    private boolean newWork;
    private boolean acceptExecutionRequest;
    private TaskScheduler scheduler;
    private IInterpreter.Control interpreterControl;
    private Clock clock;
    private ITimeTaskScheduler.TimeTask nextTask;
    private boolean canTerminate;
    private boolean canSuspend;
    private boolean canResume;
    private boolean canStep;
    private boolean isSuspended;
    private boolean isTerminated;
    private boolean isStepping;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getIsExecuting() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            return this.isExecuting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIsExecuting(boolean value) {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.isExecuting = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getStateConfVectorPosition() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            return this.stateConfVectorPosition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStateConfVectorPosition(long value) {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.stateConfVectorPosition = value;
        }
    }

    public InterpreterSessionControl() {
        int i = 0;
        while (i < 3) {
            this.stateVector[i] = State.$NULLSTATE$;
            ++i;
        }
        this.clearInEvents();
        this.setAcceptExecutionRequest(false);
        this.setClock(new Clock());
        this.setNextTask(null);
        this.setCanTerminate(false);
        this.setCanSuspend(false);
        this.setCanResume(false);
        this.setCanStep(false);
        this.setIsSuspended(false);
        this.setIsTerminated(false);
        this.setIsStepping(false);
        this.isExecuting = false;
    }

    public synchronized void enter() {
        if (this.timerService == null) {
            throw new IllegalStateException("Timer service must be set.");
        }
        if (this.operationCallback == null) {
            throw new IllegalStateException("Operation callback must be set.");
        }
        if (this.getIsExecuting()) {
            return;
        }
        this.isExecuting = true;
        this.setAcceptExecutionRequest(false);
        this.setCanTerminate(false);
        this.setCanSuspend(false);
        this.setIsSuspended(false);
        this.setCanStep(false);
        this.raiseModeChanged();
        for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
            ifaceTraceObserver.onStateEntered((Object)State.MAIN_INACTIVE);
        }
        this.stateVector[0] = State.MAIN_INACTIVE;
        this.stateConfVectorPosition = 0L;
        this.isExecuting = false;
    }

    public synchronized void exit() {
        if (this.getIsExecuting()) {
            return;
        }
        this.isExecuting = true;
        switch (this.stateVector[0]) {
            case MAIN_INACTIVE: {
                this.stateVector[0] = State.$NULLSTATE$;
                this.stateConfVectorPosition = 0L;
                break;
            }
            case MAIN_ACTIVATED_LISTEN_AWAIT_REQUEST: {
                this.stateVector[0] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 0L;
                break;
            }
        }
        switch (this.stateVector[1]) {
            case MAIN_ACTIVATED_WORK_PROCESS: {
                this.stateVector[1] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 1L;
                break;
            }
            case MAIN_ACTIVATED_WORK_PICK_TASK: {
                this.stateVector[1] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 1L;
                break;
            }
            case MAIN_ACTIVATED_WORK_SUSPENDED: {
                this.stateVector[1] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 1L;
                break;
            }
            case MAIN_ACTIVATED_WORK_IDLE: {
                this.stateVector[1] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 1L;
                break;
            }
            case MAIN_ACTIVATED_WORK_CONTINUE_SUSPENDED: {
                this.stateVector[1] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 1L;
                break;
            }
            case MAIN_ACTIVATED_WORK_SUSPENDING: {
                this.stateVector[1] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 1L;
                break;
            }
            case MAIN_ACTIVATED_WORK_TIME_LEAP: {
                this.stateVector[1] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 1L;
                break;
            }
        }
        switch (this.stateVector[2]) {
            case MAIN_ACTIVATED_MODE_RUNNING: {
                this.stateVector[2] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 2L;
                this.setCanSuspend(false);
                this.setIsSuspended(true);
                this.getClock().stop();
                this.operationCallback.stopListener();
                this.operationCallback.stopWorker();
                this.setCanTerminate(false);
                break;
            }
            case MAIN_ACTIVATED_MODE_SUSPENDED: {
                this.stateVector[2] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 2L;
                this.getClock().resume();
                this.setCanResume(false);
                this.setCanStep(false);
                this.getClock().stop();
                this.operationCallback.stopListener();
                this.operationCallback.stopWorker();
                this.setCanTerminate(false);
                break;
            }
            case MAIN_ACTIVATED_MODE_SUSPENDING: {
                this.stateVector[2] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 2L;
                this.timerService.unsetTimer((ITimed)this, 0);
                this.setIsStepping(false);
                this.getClock().stop();
                this.operationCallback.stopListener();
                this.operationCallback.stopWorker();
                this.setCanTerminate(false);
                break;
            }
            case MAIN_ACTIVATED_MODE_TIME_STEP: {
                this.stateVector[2] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 2L;
                this.getClock().stop();
                this.operationCallback.stopListener();
                this.operationCallback.stopWorker();
                this.setCanTerminate(false);
                break;
            }
        }
        this.stateVector[0] = State.$NULLSTATE$;
        this.stateConfVectorPosition = 0L;
        this.isExecuting = false;
    }

    public synchronized boolean isActive() {
        return this.stateVector[0] != State.$NULLSTATE$ || this.stateVector[1] != State.$NULLSTATE$ || this.stateVector[2] != State.$NULLSTATE$;
    }

    public synchronized boolean isFinal() {
        return false;
    }

    private void clearInEvents() {
        this.start = false;
        this.suspend = false;
        this.step = false;
        this.resume = false;
        this.terminate = false;
        this.next = false;
        this.done = false;
        this.workSuspended = false;
        this.suspendWork = false;
        this.continueWork = false;
        this.newWork = false;
        this.timeEvents[0] = false;
    }

    private void microStep() {
        long transitioned = -1L;
        this.stateConfVectorPosition = 0L;
        switch (this.stateVector[0]) {
            case MAIN_INACTIVE: {
                transitioned = this.main_inactive_react(transitioned);
                break;
            }
            case MAIN_ACTIVATED_LISTEN_AWAIT_REQUEST: {
                transitioned = this.main_activated_listen_await_request_react(transitioned);
                break;
            }
        }
        if (this.getStateConfVectorPosition() < 1L) {
            switch (this.stateVector[1]) {
                case MAIN_ACTIVATED_WORK_PROCESS: {
                    transitioned = this.main_activated_work_process_react(transitioned);
                    break;
                }
                case MAIN_ACTIVATED_WORK_PICK_TASK: {
                    transitioned = this.main_activated_work_pick_task_react(transitioned);
                    break;
                }
                case MAIN_ACTIVATED_WORK_SUSPENDED: {
                    transitioned = this.main_activated_work_suspended_react(transitioned);
                    break;
                }
                case MAIN_ACTIVATED_WORK_IDLE: {
                    transitioned = this.main_activated_work_idle_react(transitioned);
                    break;
                }
                case MAIN_ACTIVATED_WORK_CONTINUE_SUSPENDED: {
                    transitioned = this.main_activated_work_continue_suspended_react(transitioned);
                    break;
                }
                case MAIN_ACTIVATED_WORK_SUSPENDING: {
                    transitioned = this.main_activated_work_suspending_react(transitioned);
                    break;
                }
                case MAIN_ACTIVATED_WORK_TIME_LEAP: {
                    transitioned = this.main_activated_work_time_leap_react(transitioned);
                    break;
                }
            }
        }
        if (this.getStateConfVectorPosition() < 2L) {
            switch (this.stateVector[2]) {
                case MAIN_ACTIVATED_MODE_RUNNING: {
                    this.main_activated_mode_running_react(transitioned);
                    break;
                }
                case MAIN_ACTIVATED_MODE_SUSPENDED: {
                    this.main_activated_mode_suspended_react(transitioned);
                    break;
                }
                case MAIN_ACTIVATED_MODE_SUSPENDING: {
                    this.main_activated_mode_suspending_react(transitioned);
                    break;
                }
                case MAIN_ACTIVATED_MODE_TIME_STEP: {
                    this.main_activated_mode_time_step_react(transitioned);
                    break;
                }
            }
        }
    }

    private void runCycle() {
        if (this.timerService == null) {
            throw new IllegalStateException("Timer service must be set.");
        }
        if (this.operationCallback == null) {
            throw new IllegalStateException("Operation callback must be set.");
        }
        if (this.getIsExecuting()) {
            return;
        }
        this.isExecuting = true;
        this.nextEvent();
        do {
            this.microStep();
            this.clearInEvents();
        } while (this.nextEvent());
        this.isExecuting = false;
    }

    protected boolean nextEvent() {
        if (!this.inEventQueue.isEmpty()) {
            ((Runnable)this.inEventQueue.poll()).run();
            return true;
        }
        return false;
    }

    public synchronized boolean isStateActive(State state) {
        switch (state) {
            case MAIN_INACTIVE: {
                return this.stateVector[0] == State.MAIN_INACTIVE;
            }
            case MAIN_ACTIVATED: {
                return this.stateVector[0].ordinal() >= State.MAIN_ACTIVATED.ordinal() && this.stateVector[0].ordinal() <= State.MAIN_ACTIVATED_MODE_TIME_STEP.ordinal();
            }
            case MAIN_ACTIVATED_LISTEN_AWAIT_REQUEST: {
                return this.stateVector[0] == State.MAIN_ACTIVATED_LISTEN_AWAIT_REQUEST;
            }
            case MAIN_ACTIVATED_WORK_PROCESS: {
                return this.stateVector[1] == State.MAIN_ACTIVATED_WORK_PROCESS;
            }
            case MAIN_ACTIVATED_WORK_PICK_TASK: {
                return this.stateVector[1] == State.MAIN_ACTIVATED_WORK_PICK_TASK;
            }
            case MAIN_ACTIVATED_WORK_SUSPENDED: {
                return this.stateVector[1] == State.MAIN_ACTIVATED_WORK_SUSPENDED;
            }
            case MAIN_ACTIVATED_WORK_IDLE: {
                return this.stateVector[1] == State.MAIN_ACTIVATED_WORK_IDLE;
            }
            case MAIN_ACTIVATED_WORK_CONTINUE_SUSPENDED: {
                return this.stateVector[1] == State.MAIN_ACTIVATED_WORK_CONTINUE_SUSPENDED;
            }
            case MAIN_ACTIVATED_WORK_SUSPENDING: {
                return this.stateVector[1] == State.MAIN_ACTIVATED_WORK_SUSPENDING;
            }
            case MAIN_ACTIVATED_WORK_TIME_LEAP: {
                return this.stateVector[1] == State.MAIN_ACTIVATED_WORK_TIME_LEAP;
            }
            case MAIN_ACTIVATED_MODE_RUNNING: {
                return this.stateVector[2] == State.MAIN_ACTIVATED_MODE_RUNNING;
            }
            case MAIN_ACTIVATED_MODE_SUSPENDED: {
                return this.stateVector[2] == State.MAIN_ACTIVATED_MODE_SUSPENDED;
            }
            case MAIN_ACTIVATED_MODE_SUSPENDING: {
                return this.stateVector[2] == State.MAIN_ACTIVATED_MODE_SUSPENDING;
            }
            case MAIN_ACTIVATED_MODE_TIME_STEP: {
                return this.stateVector[2] == State.MAIN_ACTIVATED_MODE_TIME_STEP;
            }
        }
        return false;
    }

    public synchronized void setTimerService(ITimerService timerService) {
        this.timerService = timerService;
    }

    public ITimerService getTimerService() {
        return this.timerService;
    }

    public synchronized void raiseTimeEvent(int eventID) {
        this.inEventQueue.add(() -> {
            this.timeEvents[n] = true;
        });
        this.runCycle();
    }

    public synchronized void addTraceObserver(ITracingListener<State> ifaceTraceObserver) {
        if (!this.ifaceTraceObservers.contains(ifaceTraceObserver)) {
            this.ifaceTraceObservers.add(ifaceTraceObserver);
        }
    }

    public synchronized void removeTraceObserver(ITracingListener<State> ifaceTraceObserver) {
        if (this.ifaceTraceObservers.contains(ifaceTraceObserver)) {
            this.ifaceTraceObservers.remove(ifaceTraceObserver);
        }
    }

    public synchronized void setOperationCallback(OperationCallback operationCallback) {
        this.operationCallback = operationCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseStart() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.inEventQueue.add(() -> {
                this.start = true;
            });
            this.runCycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseSuspend() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.inEventQueue.add(() -> {
                this.suspend = true;
            });
            this.runCycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseStep() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.inEventQueue.add(() -> {
                this.step = true;
            });
            this.runCycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseResume() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.inEventQueue.add(() -> {
                this.resume = true;
            });
            this.runCycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseTerminate() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.inEventQueue.add(() -> {
                this.terminate = true;
            });
            this.runCycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void raiseModeChanged() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.modeChanged = true;
            this.modeChangedObservable.next(null);
        }
    }

    public Observable<Void> getModeChanged() {
        return this.modeChangedObservable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseNext() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.inEventQueue.add(() -> {
                this.next = true;
            });
            this.runCycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseDone() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.inEventQueue.add(() -> {
                this.done = true;
            });
            this.runCycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseWorkSuspended() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.inEventQueue.add(() -> {
                this.workSuspended = true;
            });
            this.runCycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseSuspendWork() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.inEventQueue.add(() -> {
                this.suspendWork = true;
            });
            this.runCycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseContinueWork() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.inEventQueue.add(() -> {
                this.continueWork = true;
            });
            this.runCycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseNewWork() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.inEventQueue.add(() -> {
                this.newWork = true;
            });
            this.runCycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getAcceptExecutionRequest() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            return this.acceptExecutionRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAcceptExecutionRequest(boolean value) {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.acceptExecutionRequest = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TaskScheduler getScheduler() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            return this.scheduler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScheduler(TaskScheduler value) {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.scheduler = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IInterpreter.Control getInterpreterControl() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            return this.interpreterControl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterpreterControl(IInterpreter.Control value) {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.interpreterControl = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Clock getClock() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            return this.clock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClock(Clock value) {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.clock = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ITimeTaskScheduler.TimeTask getNextTask() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            return this.nextTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextTask(ITimeTaskScheduler.TimeTask value) {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.nextTask = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getCanTerminate() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            return this.canTerminate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanTerminate(boolean value) {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.canTerminate = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getCanSuspend() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            return this.canSuspend;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanSuspend(boolean value) {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.canSuspend = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getCanResume() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            return this.canResume;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanResume(boolean value) {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.canResume = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getCanStep() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            return this.canStep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanStep(boolean value) {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.canStep = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getIsSuspended() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            return this.isSuspended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsSuspended(boolean value) {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.isSuspended = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getIsTerminated() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            return this.isTerminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsTerminated(boolean value) {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.isTerminated = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getIsStepping() {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            return this.isStepping;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsStepping(boolean value) {
        InterpreterSessionControl interpreterSessionControl = this;
        synchronized (interpreterSessionControl) {
            this.isStepping = value;
        }
    }

    private long react(long transitioned_before) {
        return transitioned_before;
    }

    private long main_inactive_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 0L && this.start) {
            this.stateVector[0] = State.$NULLSTATE$;
            this.stateConfVectorPosition = 0L;
            this.getClock().start();
            this.setAcceptExecutionRequest(true);
            this.operationCallback.startWorker();
            this.operationCallback.startListener();
            this.setCanTerminate(true);
            for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED);
            }
            for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_LISTEN_AWAIT_REQUEST);
            }
            this.stateVector[0] = State.MAIN_ACTIVATED_LISTEN_AWAIT_REQUEST;
            this.stateConfVectorPosition = 0L;
            for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_WORK_IDLE);
            }
            this.stateVector[1] = State.MAIN_ACTIVATED_WORK_IDLE;
            this.stateConfVectorPosition = 1L;
            if (this.isStateActive(State.MAIN_ACTIVATED_WORK_IDLE) || this.isStateActive(State.MAIN_ACTIVATED_WORK_SUSPENDED)) {
                this.raiseContinueWork();
            }
            this.setCanSuspend(true);
            this.setIsSuspended(false);
            this.raiseModeChanged();
            for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_MODE_RUNNING);
            }
            this.stateVector[2] = State.MAIN_ACTIVATED_MODE_RUNNING;
            this.stateConfVectorPosition = 2L;
            this.react(0L);
            transitioned_after = 0L;
        }
        if (transitioned_after == transitioned_before) {
            transitioned_after = this.react(transitioned_before);
        }
        return transitioned_after;
    }

    private long main_activated_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 0L && this.terminate) {
            switch (this.stateVector[0]) {
                case MAIN_ACTIVATED_LISTEN_AWAIT_REQUEST: {
                    this.stateVector[0] = State.MAIN_ACTIVATED;
                    this.stateConfVectorPosition = 0L;
                    break;
                }
            }
            switch (this.stateVector[1]) {
                case MAIN_ACTIVATED_WORK_PROCESS: {
                    this.stateVector[1] = State.MAIN_ACTIVATED;
                    this.stateConfVectorPosition = 1L;
                    break;
                }
                case MAIN_ACTIVATED_WORK_PICK_TASK: {
                    this.stateVector[1] = State.MAIN_ACTIVATED;
                    this.stateConfVectorPosition = 1L;
                    break;
                }
                case MAIN_ACTIVATED_WORK_SUSPENDED: {
                    this.stateVector[1] = State.MAIN_ACTIVATED;
                    this.stateConfVectorPosition = 1L;
                    break;
                }
                case MAIN_ACTIVATED_WORK_IDLE: {
                    this.stateVector[1] = State.MAIN_ACTIVATED;
                    this.stateConfVectorPosition = 1L;
                    break;
                }
                case MAIN_ACTIVATED_WORK_CONTINUE_SUSPENDED: {
                    this.stateVector[1] = State.MAIN_ACTIVATED;
                    this.stateConfVectorPosition = 1L;
                    break;
                }
                case MAIN_ACTIVATED_WORK_SUSPENDING: {
                    this.stateVector[1] = State.MAIN_ACTIVATED;
                    this.stateConfVectorPosition = 1L;
                    break;
                }
                case MAIN_ACTIVATED_WORK_TIME_LEAP: {
                    this.stateVector[1] = State.MAIN_ACTIVATED;
                    this.stateConfVectorPosition = 1L;
                    break;
                }
            }
            switch (this.stateVector[2]) {
                case MAIN_ACTIVATED_MODE_RUNNING: {
                    this.stateVector[2] = State.MAIN_ACTIVATED;
                    this.stateConfVectorPosition = 2L;
                    this.setCanSuspend(false);
                    this.setIsSuspended(true);
                    break;
                }
                case MAIN_ACTIVATED_MODE_SUSPENDED: {
                    this.stateVector[2] = State.MAIN_ACTIVATED;
                    this.stateConfVectorPosition = 2L;
                    this.getClock().resume();
                    this.setCanResume(false);
                    this.setCanStep(false);
                    break;
                }
                case MAIN_ACTIVATED_MODE_SUSPENDING: {
                    this.stateVector[2] = State.MAIN_ACTIVATED;
                    this.stateConfVectorPosition = 2L;
                    this.timerService.unsetTimer((ITimed)this, 0);
                    this.setIsStepping(false);
                    break;
                }
                case MAIN_ACTIVATED_MODE_TIME_STEP: {
                    this.stateVector[2] = State.MAIN_ACTIVATED;
                    this.stateConfVectorPosition = 2L;
                    break;
                }
            }
            this.stateVector[0] = State.$NULLSTATE$;
            this.stateVector[1] = State.$NULLSTATE$;
            this.stateVector[2] = State.$NULLSTATE$;
            this.stateConfVectorPosition = 2L;
            this.getClock().stop();
            this.operationCallback.stopListener();
            this.operationCallback.stopWorker();
            this.setCanTerminate(false);
            this.getInterpreterControl().terminate();
            this.setIsTerminated(true);
            this.setAcceptExecutionRequest(false);
            this.setCanTerminate(false);
            this.setCanSuspend(false);
            this.setIsSuspended(false);
            this.setCanStep(false);
            this.raiseModeChanged();
            for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                ifaceTraceObserver.onStateEntered((Object)State.MAIN_INACTIVE);
            }
            this.stateVector[0] = State.MAIN_INACTIVE;
            this.stateConfVectorPosition = 0L;
            this.react(0L);
            transitioned_after = 2L;
        }
        if (transitioned_after == transitioned_before) {
            transitioned_after = this.react(transitioned_before);
        }
        return transitioned_after;
    }

    private long main_activated_listen_await_request_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after == transitioned_before && this.next) {
            this.raiseNewWork();
        }
        return transitioned_after;
    }

    private long main_activated_work_process_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 1L) {
            if (this.done) {
                this.stateVector[1] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 1L;
                for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                    ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_WORK_IDLE);
                }
                this.stateVector[1] = State.MAIN_ACTIVATED_WORK_IDLE;
                this.stateConfVectorPosition = 1L;
                transitioned_after = 1L;
            } else if (this.suspendWork) {
                this.stateVector[1] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 1L;
                this.getInterpreterControl().suspend();
                for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                    ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_WORK_SUSPENDING);
                }
                this.stateVector[1] = State.MAIN_ACTIVATED_WORK_SUSPENDING;
                this.stateConfVectorPosition = 1L;
                transitioned_after = 1L;
            }
        }
        return transitioned_after;
    }

    private long main_activated_work_pick_task_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 1L) {
            if (this.done) {
                this.stateVector[1] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 1L;
                for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                    ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_WORK_TIME_LEAP);
                }
                this.stateVector[1] = State.MAIN_ACTIVATED_WORK_TIME_LEAP;
                this.stateConfVectorPosition = 1L;
                transitioned_after = 1L;
            } else if (this.suspendWork) {
                this.stateVector[1] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 1L;
                this.operationCallback.interrupt();
                for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                    ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_WORK_IDLE);
                }
                this.stateVector[1] = State.MAIN_ACTIVATED_WORK_IDLE;
                this.stateConfVectorPosition = 1L;
                transitioned_after = 1L;
            }
        }
        if (transitioned_after == transitioned_before && this.newWork) {
            this.operationCallback.interrupt();
        }
        return transitioned_after;
    }

    private long main_activated_work_suspended_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 1L && this.continueWork) {
            this.stateVector[1] = State.MAIN_ACTIVATED;
            this.stateConfVectorPosition = 1L;
            this.operationCallback.interrupt();
            for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_WORK_CONTINUE_SUSPENDED);
            }
            this.stateVector[1] = State.MAIN_ACTIVATED_WORK_CONTINUE_SUSPENDED;
            this.stateConfVectorPosition = 1L;
            transitioned_after = 1L;
        }
        return transitioned_after;
    }

    private long main_activated_work_idle_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 1L && this.continueWork) {
            this.stateVector[1] = State.MAIN_ACTIVATED;
            this.stateConfVectorPosition = 1L;
            this.operationCallback.interrupt();
            for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_WORK_PICK_TASK);
            }
            this.stateVector[1] = State.MAIN_ACTIVATED_WORK_PICK_TASK;
            this.stateConfVectorPosition = 1L;
            transitioned_after = 1L;
        }
        return transitioned_after;
    }

    private long main_activated_work_continue_suspended_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 1L) {
            if (this.suspendWork) {
                this.stateVector[1] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 1L;
                this.getInterpreterControl().suspend();
                for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                    ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_WORK_SUSPENDING);
                }
                this.stateVector[1] = State.MAIN_ACTIVATED_WORK_SUSPENDING;
                this.stateConfVectorPosition = 1L;
                transitioned_after = 1L;
            } else if (this.done) {
                this.stateVector[1] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 1L;
                for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                    ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_WORK_IDLE);
                }
                this.stateVector[1] = State.MAIN_ACTIVATED_WORK_IDLE;
                this.stateConfVectorPosition = 1L;
                transitioned_after = 1L;
            }
        }
        return transitioned_after;
    }

    private long main_activated_work_suspending_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 1L && this.workSuspended) {
            this.stateVector[1] = State.MAIN_ACTIVATED;
            this.stateConfVectorPosition = 1L;
            for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_WORK_SUSPENDED);
            }
            this.stateVector[1] = State.MAIN_ACTIVATED_WORK_SUSPENDED;
            this.stateConfVectorPosition = 1L;
            transitioned_after = 1L;
        }
        return transitioned_after;
    }

    private long main_activated_work_time_leap_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 1L) {
            if (this.done) {
                this.stateVector[1] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 1L;
                for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                    ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_WORK_PROCESS);
                }
                this.stateVector[1] = State.MAIN_ACTIVATED_WORK_PROCESS;
                this.stateConfVectorPosition = 1L;
                transitioned_after = 1L;
            } else if (this.newWork) {
                this.stateVector[1] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 1L;
                this.operationCallback.interrupt();
                for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                    ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_WORK_PICK_TASK);
                }
                this.stateVector[1] = State.MAIN_ACTIVATED_WORK_PICK_TASK;
                this.stateConfVectorPosition = 1L;
                transitioned_after = 1L;
            } else if (this.suspendWork) {
                this.stateVector[1] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 1L;
                this.operationCallback.interrupt();
                for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                    ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_WORK_IDLE);
                }
                this.stateVector[1] = State.MAIN_ACTIVATED_WORK_IDLE;
                this.stateConfVectorPosition = 1L;
                transitioned_after = 1L;
            }
        }
        return transitioned_after;
    }

    private long main_activated_mode_running_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 2L && this.suspend) {
            this.stateVector[2] = State.MAIN_ACTIVATED;
            this.stateConfVectorPosition = 2L;
            this.setCanSuspend(false);
            this.setIsSuspended(true);
            if (this.isStateActive(State.MAIN_ACTIVATED_WORK_PROCESS)) {
                this.timerService.setTimer((ITimed)this, 0, 500L, true);
                this.setIsStepping(true);
                this.raiseModeChanged();
                for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                    ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_MODE_SUSPENDING);
                }
                this.stateVector[2] = State.MAIN_ACTIVATED_MODE_SUSPENDING;
                this.stateConfVectorPosition = 2L;
            } else {
                this.raiseSuspendWork();
                this.getClock().suspend();
                this.setCanResume(true);
                this.setCanStep(this.operationCallback.hasWork() || this.isStateActive(State.MAIN_ACTIVATED_WORK_SUSPENDED));
                this.raiseModeChanged();
                for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                    ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_MODE_SUSPENDED);
                }
                this.stateVector[2] = State.MAIN_ACTIVATED_MODE_SUSPENDED;
                this.stateConfVectorPosition = 2L;
            }
            transitioned_after = 2L;
        }
        if (transitioned_after == transitioned_before) {
            if (this.isStateActive(State.MAIN_ACTIVATED_WORK_IDLE) || this.isStateActive(State.MAIN_ACTIVATED_WORK_SUSPENDED)) {
                this.raiseContinueWork();
            }
            transitioned_after = this.main_activated_react(transitioned_before);
        }
        return transitioned_after;
    }

    private long main_activated_mode_suspended_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 2L) {
            if (this.resume) {
                this.stateVector[2] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 2L;
                this.getClock().resume();
                this.setCanResume(false);
                this.setCanStep(false);
                if (this.isStateActive(State.MAIN_ACTIVATED_WORK_IDLE) || this.isStateActive(State.MAIN_ACTIVATED_WORK_SUSPENDED)) {
                    this.raiseContinueWork();
                }
                this.setCanSuspend(true);
                this.setIsSuspended(false);
                this.raiseModeChanged();
                for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                    ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_MODE_RUNNING);
                }
                this.stateVector[2] = State.MAIN_ACTIVATED_MODE_RUNNING;
                this.stateConfVectorPosition = 2L;
                this.main_activated_react(0L);
                transitioned_after = 2L;
            } else if (this.step && this.isStateActive(State.MAIN_ACTIVATED_WORK_SUSPENDED)) {
                this.stateVector[2] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 2L;
                this.getClock().resume();
                this.setCanResume(false);
                this.setCanStep(false);
                this.raiseContinueWork();
                this.timerService.setTimer((ITimed)this, 0, 500L, true);
                this.setIsStepping(true);
                this.raiseModeChanged();
                for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                    ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_MODE_SUSPENDING);
                }
                this.stateVector[2] = State.MAIN_ACTIVATED_MODE_SUSPENDING;
                this.stateConfVectorPosition = 2L;
                this.main_activated_react(0L);
                transitioned_after = 2L;
            } else if (this.step && this.operationCallback.hasWork()) {
                this.stateVector[2] = State.MAIN_ACTIVATED;
                this.stateConfVectorPosition = 2L;
                this.getClock().resume();
                this.setCanResume(false);
                this.setCanStep(false);
                this.setIsStepping(true);
                this.raiseContinueWork();
                this.raiseModeChanged();
                for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                    ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_MODE_TIME_STEP);
                }
                this.stateVector[2] = State.MAIN_ACTIVATED_MODE_TIME_STEP;
                this.stateConfVectorPosition = 2L;
                this.main_activated_react(0L);
                transitioned_after = 2L;
            }
        }
        if (transitioned_after == transitioned_before) {
            if (this.newWork) {
                this.setCanStep(this.operationCallback.hasWork() || this.isStateActive(State.MAIN_ACTIVATED_WORK_SUSPENDED));
                this.raiseModeChanged();
            }
            transitioned_after = this.main_activated_react(transitioned_before);
        }
        return transitioned_after;
    }

    private long main_activated_mode_suspending_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 2L && (this.done || this.workSuspended)) {
            this.stateVector[2] = State.MAIN_ACTIVATED;
            this.stateConfVectorPosition = 2L;
            this.timerService.unsetTimer((ITimed)this, 0);
            this.setIsStepping(false);
            this.getClock().suspend();
            this.setCanResume(true);
            this.setCanStep(this.operationCallback.hasWork() || this.isStateActive(State.MAIN_ACTIVATED_WORK_SUSPENDED));
            this.raiseModeChanged();
            for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_MODE_SUSPENDED);
            }
            this.stateVector[2] = State.MAIN_ACTIVATED_MODE_SUSPENDED;
            this.stateConfVectorPosition = 2L;
            this.main_activated_react(0L);
            transitioned_after = 2L;
        }
        if (transitioned_after == transitioned_before) {
            if (this.timeEvents[0]) {
                this.raiseSuspendWork();
            }
            transitioned_after = this.main_activated_react(transitioned_before);
        }
        return transitioned_after;
    }

    private long main_activated_mode_time_step_react(long transitioned_before) {
        long transitioned_after = transitioned_before;
        if (transitioned_after < 2L && this.done && this.isStateActive(State.MAIN_ACTIVATED_WORK_PROCESS)) {
            this.stateVector[2] = State.MAIN_ACTIVATED;
            this.stateConfVectorPosition = 2L;
            this.timerService.setTimer((ITimed)this, 0, 500L, true);
            this.setIsStepping(true);
            this.raiseModeChanged();
            for (ITracingListener<State> ifaceTraceObserver : this.ifaceTraceObservers) {
                ifaceTraceObserver.onStateEntered((Object)State.MAIN_ACTIVATED_MODE_SUSPENDING);
            }
            this.stateVector[2] = State.MAIN_ACTIVATED_MODE_SUSPENDING;
            this.stateConfVectorPosition = 2L;
            this.main_activated_react(0L);
            transitioned_after = 2L;
        }
        if (transitioned_after == transitioned_before) {
            transitioned_after = this.main_activated_react(transitioned_before);
        }
        return transitioned_after;
    }

    public synchronized void triggerWithoutEvent() {
        this.runCycle();
    }

    public static interface OperationCallback {
        public void startWorker();

        public void stopWorker();

        public void startListener();

        public void stopListener();

        public void interrupt();

        public boolean hasWork();
    }

    public static enum State {
        MAIN_INACTIVE,
        MAIN_ACTIVATED,
        MAIN_ACTIVATED_LISTEN_AWAIT_REQUEST,
        MAIN_ACTIVATED_WORK_PROCESS,
        MAIN_ACTIVATED_WORK_PICK_TASK,
        MAIN_ACTIVATED_WORK_SUSPENDED,
        MAIN_ACTIVATED_WORK_IDLE,
        MAIN_ACTIVATED_WORK_CONTINUE_SUSPENDED,
        MAIN_ACTIVATED_WORK_SUSPENDING,
        MAIN_ACTIVATED_WORK_TIME_LEAP,
        MAIN_ACTIVATED_MODE_RUNNING,
        MAIN_ACTIVATED_MODE_SUSPENDED,
        MAIN_ACTIVATED_MODE_SUSPENDING,
        MAIN_ACTIVATED_MODE_TIME_STEP,
        $NULLSTATE$;

    }
}

