/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter.scheduling;

import com.google.inject.Singleton;
import com.yakindu.base.expressions.interpreter.scheduling.ITimeTaskScheduler;
import com.yakindu.base.expressions.interpreter.scheduling.TaskScheduler;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.time.StopWatch;

@Singleton
public class DefaultTimeTaskScheduler
extends TaskScheduler
implements ITimeTaskScheduler {
    protected Lock lock = new ReentrantLock();
    protected Condition stateOrScheduleChangedCondition = this.lock.newCondition();
    protected Runnable queueWorker;
    protected boolean suspended;
    protected boolean terminated;
    private StopWatch watch;

    public DefaultTimeTaskScheduler() {
        this.nextTaskChanged.subscribe(task -> this.stateOrScheduleChangedCondition.signal());
        this.queueWorker = () -> {
            while (!this.terminated && !this.suspended) {
                if (this.nextTask().isPresent()) {
                    this.timeLeapToNextEvent();
                    continue;
                }
                this.waitTime(100L);
            }
        };
    }

    @Override
    public void timeLeap(long ms) {
        this.watch = null;
        super.timeLeap(ms);
    }

    protected long waitTime(long ms) {
        long consumedTime;
        block8: {
            consumedTime = 0L;
            this.lock.lock();
            try {
                try {
                    this.watch = new StopWatch();
                    this.watch.start();
                    this.stateOrScheduleChangedCondition.await(ms, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    if (this.watch != null) {
                        this.watch.stop();
                    }
                    consumedTime = this.watch != null ? this.watch.getTime() : 0L;
                    this.timeLeap(consumedTime);
                    this.lock.unlock();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (this.watch != null) {
                    this.watch.stop();
                }
                consumedTime = this.watch != null ? this.watch.getTime() : 0L;
                this.timeLeap(consumedTime);
                this.lock.unlock();
                throw throwable;
            }
            if (this.watch != null) {
                this.watch.stop();
            }
            consumedTime = this.watch != null ? this.watch.getTime() : 0L;
            this.timeLeap(consumedTime);
            this.lock.unlock();
        }
        return consumedTime;
    }

    protected boolean timeLeapToNextEvent() {
        ITimeTaskScheduler.TimeTask nextTask = this.nextTask().orElse(null);
        if (nextTask != null) {
            long timeToNextTask;
            boolean wasSuspended = this.suspended;
            long leapTime = nextTask.getNextExecutionTime() - this.currentTime;
            do {
                if (wasSuspended ^ this.suspended) {
                    return false;
                }
                leapTime -= this.waitTime(leapTime < 100L ? leapTime : 100L);
            } while ((leapTime = Math.min(leapTime, timeToNextTask = nextTask.getNextExecutionTime() - this.currentTime)) > 0L);
            return true;
        }
        return false;
    }

    @Override
    public void start() {
        Thread thread = new Thread(this.queueWorker, "YSCT.DefaultTimeTaskScheduler.worker");
        thread.start();
    }

    @Override
    public void scheduleTimeTask(ITimeTaskScheduler.TimeTask task, boolean isPeriodical, long duration) {
        this.lock.lock();
        try {
            this.scheduleTask(task, isPeriodical, duration);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void unscheduleTimeTask(String eventName) {
        this.lock.lock();
        try {
            this.unschedulTask(eventName);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected long computeNextExecutionTime(long interval) {
        return super.computeNextExecutionTime(interval) + (this.watch != null ? this.watch.getTime() : 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        this.terminated = true;
        this.currentTime = 0L;
        this.stopTime = 0L;
        Queue queue = this.tasks;
        synchronized (queue) {
            for (ITimeTaskScheduler.TimeTask timerTask : this.tasks) {
                timerTask.cancel();
            }
            this.tasks.clear();
        }
    }

    @Override
    public synchronized void suspend() {
        if (!this.suspended) {
            if (this.watch != null) {
                this.watch.suspend();
            }
            this.lock.lock();
            this.suspended = true;
            this.stateOrScheduleChangedCondition.signal();
            this.lock.unlock();
        }
    }

    @Override
    public synchronized void resume() {
        if (this.suspended) {
            this.suspended = false;
            this.start();
        }
    }

    @Override
    public void step() {
        if (this.suspended) {
            this.timeLeapToNextEvent();
        }
    }
}

