/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter.types;

import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.interpreter.base.IInstanceFactory;
import com.yakindu.base.expressions.interpreter.base.IInterpreter;
import com.yakindu.base.expressions.interpreter.types.RuntimeInstance;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.model.sruntime.CompositeSlot;
import com.yakindu.sct.model.sruntime.ExecutionSlot;
import com.yakindu.sct.model.sruntime.ExecutionVariable;
import com.yakindu.sct.model.sruntime.ReferenceSlot;
import com.yakindu.sct.model.sruntime.SRuntimeFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class MapInstance
extends RuntimeInstance {
    @Inject
    @Extension
    private ITypeSystem _iTypeSystem;
    @Extension
    protected SRuntimeFactory runtimeFactory = SRuntimeFactory.eINSTANCE;
    protected ComplexType mapType;
    protected Package declarationPackage;

    @Override
    public void setUp(CompositeSlot instance, IInterpreter.Context context, IInstanceFactory factory) {
        super.setUp(instance, context, factory);
        Type _type = this._iTypeSystem.getType("map");
        this.mapType = (ComplexType)_type;
        EObject _eContainer = this.mapType.eContainer();
        this.declarationPackage = (Package)_eContainer;
    }

    @Override
    public Package declarationPackage() {
        return this.declarationPackage;
    }

    @Override
    public Iterable<Declaration> declarations() {
        return this.mapType.getAllFeatures();
    }

    @Override
    protected void _doInvoke(ArgumentExpression expr) {
        String _name;
        boolean _equals;
        EObject feature = this.featureOrReference(expr);
        boolean _matched = false;
        if (feature instanceof Operation && (_equals = Objects.equals("put", _name = ((Operation)feature).getName()))) {
            _matched = true;
            this.put();
        }
        if (!_matched && feature instanceof Operation && (_equals = Objects.equals("remove", _name = ((Operation)feature).getName()))) {
            _matched = true;
            this.remove();
        }
        if (!_matched && feature instanceof Operation && (_equals = Objects.equals("size", _name = ((Operation)feature).getName()))) {
            _matched = true;
            this.size();
        }
        if (!_matched && feature instanceof Operation && (_equals = Objects.equals("containsKey", _name = ((Operation)feature).getName()))) {
            _matched = true;
            this.containsKey();
        }
        if (!_matched && feature instanceof Operation && (_equals = Objects.equals("containsValue", _name = ((Operation)feature).getName()))) {
            _matched = true;
            this.containsValue();
        }
        if (!_matched && feature instanceof Operation && (_equals = Objects.equals("keys", _name = ((Operation)feature).getName()))) {
            _matched = true;
            this.keys();
        }
        if (!_matched && feature instanceof Operation && (_equals = Objects.equals("values", _name = ((Operation)feature).getName()))) {
            _matched = true;
            this.values();
        }
        if (!_matched && feature instanceof Operation && (_equals = Objects.equals("clear", _name = ((Operation)feature).getName()))) {
            _matched = true;
            this.clear();
        }
        if (!_matched) {
            super._doInvoke(expr);
        }
    }

    protected void put() {
        Object value = this.context.popValue();
        Object key = this.context.popValue();
        Object existingSlot = this.resolveSlot(this.instanceSlot, key);
        if (existingSlot == null) {
            ExecutionVariable _createExecutionVariable = SRuntimeFactory.eINSTANCE.createExecutionVariable();
            Procedures.Procedure1 _function = slot -> {
                slot.setValue(value);
                slot.setName(String.valueOf(key));
                slot.setKey(key);
                slot.setType(this._iTypeSystem.getType("any"));
            };
            ExecutionVariable newSlot = (ExecutionVariable)ObjectExtensions.operator_doubleArrow((Object)_createExecutionVariable, (Procedures.Procedure1)_function);
            List _slots = this.instanceSlot.getSlots();
            _slots.add(newSlot);
            this.context.pushValue(IInterpreter.NULL);
        } else {
            Object oldValue = this.context.get(existingSlot);
            this._valueSemantics.setValue(existingSlot, value);
            this.context.pushValue(oldValue);
        }
    }

    protected boolean remove() {
        boolean _xblockexpression = false;
        Object value = this.context.popValue();
        Functions.Function1 _function = slot -> {
            Object _key = slot.getKey();
            return Objects.equals(_key, value);
        };
        ExecutionSlot slotValue = (ExecutionSlot)IterableExtensions.findFirst((Iterable)this.instanceSlot.getSlots(), (Functions.Function1)_function);
        boolean _xifexpression = false;
        if (slotValue != null) {
            _xifexpression = this.instanceSlot.getSlots().remove(slotValue);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected void size() {
        this.context.pushValue(this.instanceSlot.getSlots().size());
    }

    protected void containsKey() {
        Object key = this.context.popValue();
        Functions.Function1 _function = slot -> {
            Object _key = slot.getKey();
            return Objects.equals(_key, key);
        };
        this.context.pushValue(IterableExtensions.exists((Iterable)this.instanceSlot.getSlots(), (Functions.Function1)_function));
    }

    protected void containsValue() {
        Object value = this.context.popValue();
        Functions.Function1 _function = slot -> {
            Object _value = slot.getValue();
            return Objects.equals(_value, value);
        };
        this.context.pushValue(IterableExtensions.exists((Iterable)this.instanceSlot.getSlots(), (Functions.Function1)_function));
    }

    protected void clear() {
        this.instanceSlot.getSlots().clear();
    }

    protected void keys() {
        CompositeSlot _createCompositeSlot = this.runtimeFactory.createCompositeSlot();
        Procedures.Procedure1 _function = it -> {
            it.setName("result");
            it.setType(this._iTypeSystem.getType("any"));
        };
        CompositeSlot result = (CompositeSlot)ObjectExtensions.operator_doubleArrow((Object)_createCompositeSlot, (Procedures.Procedure1)_function);
        Consumer<ExecutionSlot> _function_1 = slot -> {
            Object _copyInstance = this.factory.copyInstance(slot);
            ExecutionSlot copy = (ExecutionSlot)_copyInstance;
            copy.setValue(copy.getKey());
            List _slots = result.getSlots();
            _slots.add(copy);
        };
        this.instanceSlot.getSlots().forEach(_function_1);
        this.context.pushValue(result);
    }

    protected void values() {
        CompositeSlot _createCompositeSlot = this.runtimeFactory.createCompositeSlot();
        Procedures.Procedure1 _function = it -> {
            it.setName("result");
            it.setType(this._iTypeSystem.getType("any"));
        };
        CompositeSlot result = (CompositeSlot)ObjectExtensions.operator_doubleArrow((Object)_createCompositeSlot, (Procedures.Procedure1)_function);
        Procedures.Procedure2 _function_1 = (slot, index) -> {
            Object _copyInstance = this.factory.copyInstance(slot);
            ExecutionSlot copy = (ExecutionSlot)_copyInstance;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("[");
            _builder.append(index);
            _builder.append("]");
            copy.setName(_builder.toString());
            List _slots = result.getSlots();
            _slots.add(copy);
        };
        IterableExtensions.forEach((Iterable)this.instanceSlot.getSlots(), (Procedures.Procedure2)_function_1);
        this.context.pushValue(result);
    }

    @Override
    public void set(Object slot, Object value) {
        if (slot == this.instanceSlot) {
            if (slot instanceof CompositeSlot && value instanceof CompositeSlot) {
                ((CompositeSlot)slot).getSlots().clear();
                Procedures.Procedure2 _function = (s, i) -> {
                    List _slots = ((CompositeSlot)slot).getSlots();
                    Object _copyInstance = this.factory.copyInstance(s);
                    Procedures.Procedure1 _function_1 = it -> {
                        it.setName(s.getName());
                        it.setFqName(s.getFqName());
                    };
                    ExecutionSlot _doubleArrow = (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)((ExecutionSlot)_copyInstance), (Procedures.Procedure1)_function_1);
                    _slots.add(_doubleArrow);
                };
                IterableExtensions.forEach((Iterable)((CompositeSlot)value).getSlots(), (Procedures.Procedure2)_function);
            }
        } else {
            this._valueSemantics.setValue(slot, value);
        }
    }

    @Override
    protected ExecutionSlot _resolveSlot(CompositeSlot slot, String symbol) {
        return this.slotByKey(slot, symbol);
    }

    @Override
    @XbaseGenerated
    public void doInvoke(Object expr) {
        if (expr instanceof Operation) {
            this._doInvoke((Operation)expr);
            return;
        }
        if (expr instanceof ArgumentExpression) {
            this._doInvoke((ArgumentExpression)expr);
            return;
        }
        if (expr == null) {
            this._doInvoke((Void)null);
            return;
        }
        this._doInvoke(expr);
    }

    @Override
    @XbaseGenerated
    public Object resolveSlot(Object slot, Object symbol) {
        if (slot instanceof ReferenceSlot && symbol instanceof String) {
            return this._resolveSlot((ReferenceSlot)slot, (String)symbol);
        }
        if (slot instanceof CompositeSlot && symbol instanceof String) {
            return this._resolveSlot((CompositeSlot)slot, (String)symbol);
        }
        if (slot != null && symbol != null) {
            return this._resolveSlot(slot, symbol);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(slot, symbol).toString());
    }
}

