/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter.types;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.interpreter.base.BaseExecution;
import com.yakindu.base.expressions.interpreter.base.IInstanceFactory;
import com.yakindu.base.expressions.interpreter.base.IInterpreter;
import com.yakindu.base.expressions.interpreter.base.InterpreterException;
import com.yakindu.base.expressions.interpreter.base.ResolvingRuntimeInstance;
import com.yakindu.base.expressions.interpreter.base.ValueSemantics;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Direction;
import com.yakindu.base.types.EnumerationType;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.Part;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.base.types.typesystem.ITypeValueProvider;
import com.yakindu.sct.model.sruntime.CompositeSlot;
import com.yakindu.sct.model.sruntime.ExecutionEvent;
import com.yakindu.sct.model.sruntime.ExecutionSlot;
import com.yakindu.sct.model.sruntime.ReferenceSlot;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public abstract class RuntimeInstance
extends ResolvingRuntimeInstance {
    public static final String INIT = "init";
    public static final String ON_START = "onStart";
    protected boolean isInitialized = false;
    protected IInstanceFactory factory;
    @Inject
    @Extension
    protected ValueSemantics _valueSemantics;
    @Inject
    @Extension
    protected ITypeSystem _iTypeSystem;
    @Inject
    @Extension
    protected ITypeValueProvider _iTypeValueProvider;
    protected CompositeSlot heap;

    public abstract Package declarationPackage();

    public abstract Iterable<Declaration> declarations();

    public void setUp(CompositeSlot instance, IInterpreter.Context context, IInstanceFactory factory) {
        super.setUp(instance, context);
        this.factory = factory;
        this.isInitialized = false;
    }

    public void init() {
        if (!this.isInitialized) {
            StringConcatenation _builder = new StringConcatenation();
            String _fqName = this.instanceSlot.getFqName();
            _builder.append(_fqName);
            _builder.append(".");
            _builder.append(INIT);
            Runnable _function = () -> {
                Consumer<Declaration> _function_1 = it -> this.initMember((Declaration)it);
                this.declarations().forEach(_function_1);
                Runnable _function_2 = () -> {
                    this.isInitialized = true;
                };
                this._execute(_function_2);
            };
            this._executeOperation(this.instanceSlot, _builder.toString(), Collections.unmodifiableList(CollectionLiterals.newArrayList()), _function);
        }
    }

    protected void _initMember(Declaration it) {
    }

    protected void _initMember(Property p) {
        boolean _tripleNotEquals;
        Expression _initialValue = p.getInitialValue();
        boolean bl = _tripleNotEquals = _initialValue != null;
        if (_tripleNotEquals) {
            Object _resolve = this.resolve(this.instanceSlot, p.getName());
            ExecutionSlot slot = (ExecutionSlot)_resolve;
            this._delegate(p.getInitialValue());
            this._value();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("initialize ");
            String _fqName = slot.getFqName();
            _builder.append(_fqName);
            Runnable _function = () -> {
                Object value = this.context.popValue();
                this._valueSemantics.setValue(slot, value);
            };
            this.context._execute(_builder.toString(), _function);
        }
    }

    protected void _initMember(Part p) {
        Object _resolve = this.resolve(this.instanceSlot, p.getName());
        ExecutionSlot slot = (ExecutionSlot)_resolve;
        if (slot instanceof ReferenceSlot) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("new part ");
            String _fqName = ((ReferenceSlot)slot).getFqName();
            _builder.append(_fqName);
            Runnable _function = () -> {
                Object _newInstance = this.factory.newInstance(p.getType());
                Procedures.Procedure1 _function_1 = it -> {
                    if (it instanceof ExecutionSlot) {
                        ((ExecutionSlot)it).setFqName(((ReferenceSlot)slot).getFqName());
                    }
                };
                Object part2 = ObjectExtensions.operator_doubleArrow((Object)_newInstance, (Procedures.Procedure1)_function_1);
                ((ReferenceSlot)slot).setReference((ExecutionSlot)part2);
            };
            this.context._execute(_builder.toString(), _function);
        }
    }

    protected boolean _isPart(Part it) {
        return true;
    }

    protected boolean _isPart(Property it) {
        return it.isConst() && it.getType() instanceof ComplexType;
    }

    protected void onStart() {
        Operation _lookupOperation = this.lookupOperation(ON_START);
        if (_lookupOperation != null) {
            this.doInvoke(_lookupOperation);
        }
    }

    protected void _invoke(Object slot, Object operation) {
        this.doInvoke(operation);
    }

    protected void _invoke(ReferenceSlot slot, Object operation) {
        this.instance(slot.getReference()).invoke(slot.getReference(), operation);
    }

    protected void _doInvoke(Object operation) {
        throw new InterpreterException("Cannot invoke operation: " + String.valueOf(operation));
    }

    protected void _doInvoke(Void void_) {
        throw new InterpreterException("Cannot invoke null operation");
    }

    protected void _doInvoke(Operation it) {
        boolean _tripleNotEquals;
        Expression _implementation = it.getImplementation();
        boolean bl = _tripleNotEquals = _implementation != null;
        if (_tripleNotEquals) {
            this.executeImplementation(it);
        } else {
            this.executeMock(it);
        }
    }

    protected void executeImplementation(Operation it) {
        boolean _tripleNotEquals;
        Expression _implementation = it.getImplementation();
        boolean bl = _tripleNotEquals = _implementation != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = this.instanceSlot.getName();
            _builder.append(_name);
            _builder.append(".");
            String _name_1 = it.getName();
            _builder.append(_name_1);
            Functions.Function1 _function = it_1 -> it_1.getName();
            Runnable _function_1 = () -> this._delegate(it.getImplementation());
            this._executeOperation(_builder.toString(), this.instanceSlot, it.getName(), ListExtensions.map((List)it.getParameters(), (Functions.Function1)_function), _function_1);
        }
    }

    protected void executeMock(Operation it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("mock ");
        String _name = this.instanceSlot.getName();
        _builder.append(_name);
        _builder.append(".");
        String _name_1 = it.getName();
        _builder.append(_name_1);
        Functions.Function1 _function = it_1 -> it_1.getName();
        Runnable _function_1 = () -> {
            boolean _not;
            Type returnType = it.getTypeSpecifier().getType();
            boolean _isVoid = this._iTypeSystem.isVoid(returnType);
            boolean bl = _not = !_isVoid;
            if (_not) {
                Functions.Function0 _function_2 = () -> {
                    Object _xifexpression = null;
                    _xifexpression = returnType instanceof ComplexType && !(returnType instanceof EnumerationType) ? this.factory.newInstance(it.getTypeSpecifier()) : this._iTypeValueProvider.defaultValue(it.getType());
                    return _xifexpression;
                };
                this._return(_function_2);
            }
        };
        this._executeOperation(_builder.toString(), this.instanceSlot, it.getName(), ListExtensions.map((List)it.getParameters(), (Functions.Function1)_function), _function_1);
    }

    protected void _doInvoke(ArgumentExpression expr) {
        String _name;
        boolean _equals;
        EObject feature = this.featureOrReference(expr);
        boolean _matched = false;
        if (feature instanceof Operation && (_equals = Objects.equals(INIT, _name = ((Operation)feature).getName()))) {
            _matched = true;
            this.init();
        }
        if (!_matched && feature instanceof Operation) {
            _matched = true;
            Operation method = this.resolveOperation((Declaration)feature);
            if (method != null) {
                this.doInvoke(method);
            } else {
                this.doInvoke(expr, feature);
            }
        }
        if (!_matched) {
            throw new InterpreterException("Cannot invoke :" + String.valueOf(feature));
        }
    }

    protected void _doInvoke(Object caller, Object operation) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Don't know how ");
        _builder.append(caller);
        _builder.append(" calls ");
        _builder.append(operation);
        throw new UnsupportedOperationException(_builder.toString());
    }

    protected void _doInvoke(ArgumentExpression caller, Operation operation) {
        this.doInvoke(operation);
    }

    @Override
    public void raise(Object slot, Object value) {
        if (slot instanceof ExecutionEvent) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("raise ");
            String _name = ((ExecutionEvent)slot).getName();
            _builder.append(_name);
            Runnable _function = () -> {
                Direction _direction = ((ExecutionEvent)slot).getDirection();
                boolean _equals = Objects.equals(_direction, Direction.LOCAL);
                if (_equals) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("internalEventQueue.add(");
                    String _name_1 = ((ExecutionEvent)slot).getName();
                    _builder_1.append(_name_1);
                    _builder_1.append(")");
                    Runnable _function_1 = () -> {};
                    this.context._execute(_builder_1.toString(), _function_1);
                } else {
                    Direction _direction_1 = ((ExecutionEvent)slot).getDirection();
                    boolean _equals_1 = Objects.equals(_direction_1, Direction.IN);
                    if (_equals_1) {
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append("inEventQueue.add(");
                        String _name_2 = ((ExecutionEvent)slot).getName();
                        _builder_2.append(_name_2);
                        _builder_2.append(")");
                        Runnable _function_2 = () -> {};
                        this.context._execute(_builder_2.toString(), _function_2);
                        this._exec("runCycle");
                    } else {
                        this._valueSemantics.setValue(slot, value);
                        ((ExecutionEvent)slot).setRaised(true);
                        Direction _direction_2 = ((ExecutionEvent)slot).getDirection();
                        boolean _equals_2 = Objects.equals(_direction_2, Direction.OUT);
                        if (_equals_2) {
                            Consumer<ExecutionEvent> _function_3 = c -> {
                                StringConcatenation _builder_3 = new StringConcatenation();
                                _builder_3.append("raise(");
                                String _name_3 = c.getName();
                                _builder_3.append(_name_3);
                                Runnable _function_4 = () -> this.instance(c).raise(c, value);
                                this.context._launch(_builder_3.toString(), _function_4);
                            };
                            ((ExecutionEvent)slot).getConnections().forEach(_function_3);
                        }
                    }
                }
            };
            this.context._execute(_builder.toString(), _function);
        }
    }

    @Override
    public void set(Object slot, Object value) {
        this._valueSemantics.setValue(slot, value);
    }

    @Override
    public void provideExecution(Object program) {
        boolean _hasMethod;
        boolean _contains;
        boolean _matched = false;
        if (program instanceof Operation && (_contains = IterableExtensions.contains((Iterable)Iterables.filter(this.declarations(), Operation.class), (Object)program))) {
            _matched = true;
            this.doInvoke(program);
        }
        if (!_matched && Objects.equals(program, INIT)) {
            _matched = true;
            this.init();
        }
        if (!_matched && Objects.equals(program, ON_START)) {
            _matched = true;
            this.onStart();
        }
        if (!_matched && program instanceof String && (_hasMethod = this.hasMethod((String)program))) {
            _matched = true;
            this.doInvoke(this.lookupOperation((String)program));
        }
        if (!_matched && program instanceof BaseExecution.Invokation) {
            _matched = true;
            this.doInvoke(((BaseExecution.Invokation)program).getCaller(), ((BaseExecution.Invokation)program).getOperation());
        }
        if (!_matched) {
            throw new IllegalArgumentException("Cannot execute '" + String.valueOf(program) + "'");
        }
    }

    protected CompositeSlot getHeap() {
        CompositeSlot _xblockexpression = null;
        if (this.heap != null) {
            return this.heap;
        }
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equals(_name, "heap");
        };
        _xblockexpression = (CompositeSlot)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)EcoreUtil2.getAllContainers((EObject)this.instanceSlot), CompositeSlot.class), (Functions.Function1)_function);
        return _xblockexpression;
    }

    @Override
    protected ExecutionSlot _resolveSlot(CompositeSlot slot, String symbol) {
        CompositeSlot pkgSlot;
        ExecutionSlot s = this.slotByName(slot, symbol);
        if (s == null && (pkgSlot = this.resolvePackageSlotById(this.declarationPackage().getName())) != slot) {
            Object _resolve = this.context.resolve(pkgSlot, symbol);
            s = (ExecutionSlot)_resolve;
        }
        if (s == null) {
            List<CompositeSlot> _imported = this.imported();
            for (CompositeSlot import_ : _imported) {
                if (import_ instanceof CompositeSlot) {
                    s = this.slotByName(import_, symbol);
                }
                if (s == null) continue;
                return s;
            }
        }
        if (s == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Can not resolve <");
            _builder.append(symbol);
            _builder.append("> for <");
            String _name = slot.getName();
            _builder.append(_name);
            _builder.append(">");
            InterpreterException _interpreterException = new InterpreterException(_builder.toString());
            this.context._throw(_interpreterException);
        }
        return s;
    }

    protected List<CompositeSlot> imported() {
        Functions.Function1 _function = it -> this.resolvePackageSlotById((String)it);
        return ListExtensions.map((List)this.declarationPackage().getImports(), (Functions.Function1)_function);
    }

    protected CompositeSlot resolvePackageSlotById(String id) {
        Functions.Function2 _function = (s, c) -> {
            Functions.Function1 _function_1 = it -> {
                String _name = it.getName();
                return Objects.equals(_name, c);
            };
            return (CompositeSlot)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)s.getSlots(), CompositeSlot.class), (Functions.Function1)_function_1);
        };
        return (CompositeSlot)IterableExtensions.fold((Iterable)((Iterable)Conversions.doWrapArray((Object)id.split("\\."))), (Object)this.getHeap(), (Functions.Function2)_function);
    }

    protected boolean hasMethod(String name) {
        Operation _lookupOperation = this.lookupOperation(name);
        return _lookupOperation != null;
    }

    public Operation lookupOperation(String name) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equals(_name, name);
        };
        return (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter(this.declarations(), Operation.class), (Functions.Function1)_function));
    }

    protected List<Operation> allOperations(Package it) {
        return IterableExtensions.toList((Iterable)Iterables.filter((Iterable)it.getMember(), Operation.class));
    }

    protected EObject _featureOrReference(FeatureCall it) {
        return it.getFeature();
    }

    protected EObject _featureOrReference(ElementReferenceExpression it) {
        return it.getReference();
    }

    protected Operation resolveOperation(Declaration decl) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            String _name_1 = decl.getName();
            return Objects.equals(_name, _name_1);
        };
        return (Operation)IterableExtensions.findFirst((Iterable)Iterables.filter(this.declarations(), Operation.class), (Functions.Function1)_function);
    }

    @XbaseGenerated
    protected void initMember(Declaration p) {
        if (p instanceof Part) {
            this._initMember((Part)p);
            return;
        }
        if (p instanceof Property) {
            this._initMember((Property)p);
            return;
        }
        if (p != null) {
            this._initMember(p);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(p).toString());
    }

    @XbaseGenerated
    protected boolean isPart(Property it) {
        if (it instanceof Part) {
            return this._isPart((Part)it);
        }
        if (it != null) {
            return this._isPart(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @Override
    @XbaseGenerated
    public void invoke(Object slot, Object operation) {
        if (slot instanceof ReferenceSlot) {
            this._invoke((ReferenceSlot)slot, operation);
            return;
        }
        if (slot != null) {
            this._invoke(slot, operation);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(slot, operation).toString());
    }

    @XbaseGenerated
    public void doInvoke(Object it) {
        if (it instanceof Operation) {
            this._doInvoke((Operation)it);
            return;
        }
        if (it instanceof ArgumentExpression) {
            this._doInvoke((ArgumentExpression)it);
            return;
        }
        if (it == null) {
            this._doInvoke((Void)null);
            return;
        }
        this._doInvoke(it);
    }

    @XbaseGenerated
    public void doInvoke(Object caller, Object operation) {
        if (caller instanceof ArgumentExpression && operation instanceof Operation) {
            this._doInvoke((ArgumentExpression)caller, (Operation)operation);
            return;
        }
        if (caller != null && operation != null) {
            this._doInvoke(caller, operation);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(caller, operation).toString());
    }

    @Override
    @XbaseGenerated
    public Object resolveSlot(Object slot, Object symbol) {
        if (slot instanceof ReferenceSlot && symbol instanceof String) {
            return this._resolveSlot((ReferenceSlot)slot, (String)symbol);
        }
        if (slot instanceof CompositeSlot && symbol instanceof String) {
            return this._resolveSlot((CompositeSlot)slot, (String)symbol);
        }
        if (slot != null && symbol != null) {
            return this._resolveSlot(slot, symbol);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(slot, symbol).toString());
    }

    @XbaseGenerated
    protected EObject featureOrReference(ArgumentExpression it) {
        if (it instanceof ElementReferenceExpression) {
            return this._featureOrReference((ElementReferenceExpression)it);
        }
        if (it instanceof FeatureCall) {
            return this._featureOrReference((FeatureCall)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

