/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter.types;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.yakindu.base.expressions.interpreter.base.IInstanceFactory;
import com.yakindu.base.expressions.interpreter.base.IInterpreter;
import com.yakindu.base.expressions.interpreter.base.InstanceSemantics;
import com.yakindu.base.expressions.interpreter.base.InterpreterException;
import com.yakindu.base.expressions.interpreter.base.ResolvingRuntimeInstance;
import com.yakindu.base.expressions.interpreter.base.ValueSemantics;
import com.yakindu.base.expressions.interpreter.types.ArrayInstance;
import com.yakindu.base.expressions.interpreter.types.ComplexTypeInstance;
import com.yakindu.base.expressions.interpreter.types.MapInstance;
import com.yakindu.base.expressions.interpreter.types.PackageHelper;
import com.yakindu.base.expressions.interpreter.types.PackageInstance;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Direction;
import com.yakindu.base.types.EnumerationType;
import com.yakindu.base.types.Event;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.Part;
import com.yakindu.base.types.PrimitiveType;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Reaction;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeBuilder;
import com.yakindu.base.types.TypeParameter;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.annotations.ClassificationAnnotations;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.ITypeSemantics;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.base.types.typesystem.ITypeValueProvider;
import com.yakindu.sct.model.sruntime.CompositeSlot;
import com.yakindu.sct.model.sruntime.ExecutionEvent;
import com.yakindu.sct.model.sruntime.ExecutionSlot;
import com.yakindu.sct.model.sruntime.ExecutionVariable;
import com.yakindu.sct.model.sruntime.ReferenceExecutionEvent;
import com.yakindu.sct.model.sruntime.ReferenceSlot;
import com.yakindu.sct.model.sruntime.SRuntimeFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@Singleton
public class RuntimeInstanceFactory
implements IInstanceFactory {
    @Extension
    protected SRuntimeFactory runtimeFactory = SRuntimeFactory.eINSTANCE;
    @Inject
    @Extension
    protected Injector injector;
    @Inject
    @Extension
    protected ITypeSystemInferrer _iTypeSystemInferrer;
    @Inject
    @Extension
    protected ITypeSemantics _iTypeSemantics;
    @Inject
    @Extension
    protected ValueSemantics _valueSemantics;
    @Inject
    @Extension
    protected InstanceSemantics _instanceSemantics;
    @Inject
    @Extension
    protected PackageHelper _packageHelper;
    @Inject
    @Extension
    protected TypeBuilder typeBuilder;
    @Inject
    @Extension
    protected ClassificationAnnotations _classificationAnnotations;
    @Inject
    protected IInterpreter.Context instanceContext;
    @Inject
    @Extension
    protected ITypeSystem ts;
    @Inject
    protected ITypeValueProvider typeValueProvider;
    protected long instanceCount = 0L;

    protected long newInstanceId() {
        return this.instanceCount++;
    }

    @Override
    public Object newInstance(Object type) {
        return this.createNewInstance(type);
    }

    protected Object _createNewInstance(Object type) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Don't know how to create new instance of type ");
        Class<?> _class = null;
        if (type != null) {
            _class = type.getClass();
        }
        String _name = _class.getName();
        _builder.append(_name);
        _builder.append(" ! ");
        throw new InterpreterException(_builder.toString());
    }

    protected Object _createNewInstance(Event eventDecl) {
        Object _heap = this.heap();
        ExecutionSlot _createInstanceMember = this.createInstanceMember((Declaration)eventDecl, (EObject)_heap);
        Procedures.Procedure1 _function = it -> {
            List<ExecutionSlot> _slots = this.slots(this.instanceContext.getHeap());
            _slots.add((ExecutionSlot)it);
        };
        return ObjectExtensions.operator_doubleArrow((Object)_createInstanceMember, (Procedures.Procedure1)_function);
    }

    protected Object _createNewInstance(Property varDecl) {
        Object _heap = this.heap();
        ExecutionSlot _createInstanceMember = this.createInstanceMember((Declaration)varDecl, (EObject)_heap);
        Procedures.Procedure1 _function = it -> {
            it.setFqName(it.getName());
            List<ExecutionSlot> _slots = this.slots(this.heap());
            _slots.add((ExecutionSlot)it);
        };
        return ObjectExtensions.operator_doubleArrow((Object)_createInstanceMember, (Procedures.Procedure1)_function);
    }

    protected Object _createNewInstance(Package pkg) {
        boolean _tripleEquals;
        CompositeSlot pkgSlot = this.provideSlot(pkg);
        IInterpreter.Instance _instance = this._instanceSemantics.instance(pkgSlot);
        boolean bl = _tripleEquals = _instance == null;
        if (_tripleEquals) {
            this._instanceSemantics.adaptInstance((EObject)pkgSlot, this.createPackageInstance(pkgSlot, pkg));
            this.createInstanceMembers(pkg, pkgSlot);
            Consumer<Package> _function = it -> this.createNewInstance(it);
            this._packageHelper.importedPackages((EObject)pkg).forEach(_function);
            this.instanceContext._invoke(pkgSlot, "init", new Object[0]);
        }
        return pkgSlot;
    }

    protected CompositeSlot provideSlot(Package pkg) {
        Object _heap = this.heap();
        Functions.Function2 _function = (s, c) -> {
            CompositeSlot _xblockexpression = null;
            Functions.Function1 _function_1 = slot -> {
                String _name = slot.getName();
                return Objects.equals(_name, c);
            };
            CompositeSlot packageSlot = (CompositeSlot)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)s.getSlots(), CompositeSlot.class), (Functions.Function1)_function_1);
            if (packageSlot == null) {
                CompositeSlot _doubleArrow;
                CompositeSlot _createCompositeSlot = this.runtimeFactory.createCompositeSlot();
                Procedures.Procedure1 _function_2 = it -> {
                    boolean _tripleNotEquals;
                    it.setName(c);
                    Object _xifexpression = null;
                    Object _heap_1 = this.heap();
                    boolean bl = _tripleNotEquals = s != _heap_1;
                    if (_tripleNotEquals) {
                        String _fqName = s.getFqName();
                        String _plus = _fqName + ".";
                        _xifexpression = _plus + c;
                    } else {
                        _xifexpression = c;
                    }
                    it.setFqName((String)_xifexpression);
                };
                packageSlot = _doubleArrow = (CompositeSlot)ObjectExtensions.operator_doubleArrow((Object)_createCompositeSlot, (Procedures.Procedure1)_function_2);
                s.getSlots().add(packageSlot);
            }
            _xblockexpression = packageSlot;
            return _xblockexpression;
        };
        return (CompositeSlot)IterableExtensions.fold((Iterable)((Iterable)Conversions.doWrapArray((Object)pkg.getName().split("\\."))), (Object)((CompositeSlot)_heap), (Functions.Function2)_function);
    }

    protected IInterpreter.Instance createPackageInstance(CompositeSlot instanceMemory, Package pkg) {
        PackageInstance _packageInstance = new PackageInstance();
        Procedures.Procedure1 _function = it -> {
            this.injector.injectMembers(it);
            it.setUp(instanceMemory, pkg, this.instanceContext, this);
        };
        return (IInterpreter.Instance)ObjectExtensions.operator_doubleArrow((Object)_packageInstance, (Procedures.Procedure1)_function);
    }

    protected void createInstanceMembers(Package it, CompositeSlot slot) {
        Functions.Function1 _function = it_1 -> it_1 instanceof Property || it_1 instanceof Event;
        Consumer<Declaration> _function_1 = m -> {
            ExecutionSlot mSlot = this.createInstanceMember((Declaration)m, (EObject)it);
            if (mSlot != null) {
                this.add(slot, mSlot);
            }
        };
        IterableExtensions.filter((Iterable)it.getMember(), (Functions.Function1)_function).forEach(_function_1);
    }

    protected Object _createNewInstance(ComplexType it) {
        return this.createNewInstance(this.typeBuilder._typeSpecifier((Type)it));
    }

    protected Object _createNewInstance(TypeSpecifier it) {
        return this.createNewInstance(this._iTypeSystemInferrer.infer((EObject)it));
    }

    protected Object _createNewInstance(ITypeSystemInferrer.InferenceResult it) {
        CompositeSlot _xifexpression = null;
        boolean _isArray = this.ts.isArray(it.getType());
        if (_isArray) {
            _xifexpression = this.createNewArray(it);
        } else {
            Object _xifexpression_1 = null;
            boolean _isMap = this.ts.isMap(it.getType());
            _xifexpression_1 = _isMap ? this.createNewMap(it) : this.createNewInstance(it.getType(), it);
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected Object _createNewInstance(Object type, TypeSpecifier ts) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Don't know how to create new instance of type ");
        Class<?> _class = null;
        if (type != null) {
            _class = type.getClass();
        }
        String _name = _class.getName();
        _builder.append(_name);
        _builder.append(" ! ");
        throw new InterpreterException(_builder.toString());
    }

    protected Object _createNewInstance(TypeParameter type, TypeSpecifier ts) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Can't create instance for unbound type parameter ");
        String _name = null;
        if (type != null) {
            _name = type.getName();
        }
        _builder.append(_name);
        _builder.append(" ! ");
        throw new InterpreterException(_builder.toString());
    }

    protected Object _createNewInstance(ComplexType type, ITypeSystemInferrer.InferenceResult ts) {
        CompositeSlot _createCompositeSlot = this.runtimeFactory.createCompositeSlot();
        Procedures.Procedure1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            String _name = type.getName();
            _builder.append(_name);
            _builder.append("#");
            long _newInstanceId = this.newInstanceId();
            _builder.append((Object)_newInstanceId);
            it.setName(_builder.toString());
            it.setFqName(it.getName());
            it.setType((Type)type);
            it.setVisible(false);
        };
        CompositeSlot rtInstance = (CompositeSlot)ObjectExtensions.operator_doubleArrow((Object)_createCompositeSlot, (Procedures.Procedure1)_function);
        List<ExecutionSlot> _slots = this.slots(this.heap());
        _slots.add((ExecutionSlot)rtInstance);
        this._instanceSemantics.adaptInstance((EObject)rtInstance, this.createComplexTypeInstance(rtInstance, type));
        this.createInstanceMembers(type, rtInstance);
        this.instanceContext._invoke(rtInstance, "init", new Object[0]);
        return rtInstance;
    }

    protected Object _createNewInstance(PrimitiveType type, ITypeSystemInferrer.InferenceResult ts) {
        return this.createExecutionVariable((Type)type);
    }

    protected Object _createNewInstance(EnumerationType type, ITypeSystemInferrer.InferenceResult ts) {
        return this.createExecutionVariable((Type)type);
    }

    protected ExecutionVariable createExecutionVariable(Type type) {
        ExecutionVariable _createExecutionVariable = this.runtimeFactory.createExecutionVariable();
        Procedures.Procedure1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            String _name = type.getName();
            _builder.append(_name);
            _builder.append("#");
            long _newInstanceId = this.newInstanceId();
            _builder.append((Object)_newInstanceId);
            it.setName(_builder.toString());
            it.setFqName(it.getName());
            it.setType(type);
            it.setValue(this.defaultValue(type));
            it.setVisible(true);
        };
        return (ExecutionVariable)ObjectExtensions.operator_doubleArrow((Object)_createExecutionVariable, (Procedures.Procedure1)_function);
    }

    protected IInterpreter.Instance createComplexTypeInstance(CompositeSlot instanceMemory, ComplexType type) {
        ComplexTypeInstance _complexTypeInstance = new ComplexTypeInstance();
        Procedures.Procedure1 _function = it -> this.setUpInstance((ComplexTypeInstance)it, instanceMemory, type);
        return (IInterpreter.Instance)ObjectExtensions.operator_doubleArrow((Object)_complexTypeInstance, (Procedures.Procedure1)_function);
    }

    protected void setUpInstance(ComplexTypeInstance it, CompositeSlot instanceMemory, ComplexType type) {
        this.injector.injectMembers((Object)it);
        it.setUp(instanceMemory, type, this.instanceContext, this);
    }

    protected void createInstanceMembers(ComplexType it, CompositeSlot slot) {
        Functions.Function1 _function = it_1 -> it_1 instanceof Property || it_1 instanceof Event;
        Consumer<Declaration> _function_1 = m -> {
            Procedures.Procedure1 _function_2;
            ExecutionSlot _createInstanceMember = this.createInstanceMember((Declaration)m, (EObject)it);
            ExecutionSlot mSlot = (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)_createInstanceMember, (Procedures.Procedure1)(_function_2 = it_1 -> {
                it_1.setFqName(it_1.getName());
                boolean _isSynthetic = this._classificationAnnotations.isSynthetic((EObject)m);
                boolean _not = !_isSynthetic;
                it_1.setVisible(_not);
            }));
            if (mSlot != null) {
                List _slots = slot.getSlots();
                _slots.add(mSlot);
            }
        };
        IterableExtensions.filter((Iterable)it.getAllFeatures(), (Functions.Function1)_function).forEach(_function_1);
    }

    public ExecutionSlot createInstanceMember(Declaration it, EObject parent) {
        return this.doCreateInstanceMember(it, parent);
    }

    protected ExecutionSlot _doCreateInstanceMember(Declaration it, EObject parent) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Don't know how to create new instance of type ");
        Class<?> _class = null;
        if (it != null) {
            _class = it.getClass();
        }
        String _name = _class.getName();
        _builder.append(_name);
        _builder.append(" in ");
        Class<?> _class_1 = null;
        if (parent != null) {
            _class_1 = parent.getClass();
        }
        String _name_1 = _class_1.getName();
        _builder.append(_name_1);
        _builder.append("! ");
        throw new InterpreterException(_builder.toString());
    }

    protected ExecutionSlot _doCreateInstanceMember(Property prop, EObject parent) {
        return this.createInstanceMemberByType((Declaration)prop, this._iTypeSystemInferrer.infer((EObject)prop).getType(), parent);
    }

    protected ExecutionSlot _doCreateInstanceMember(Property prop, ComplexType parent) {
        return this.createInstanceMemberByType((Declaration)prop, this._iTypeSystemInferrer.infer((EObject)prop).getType(), (EObject)parent);
    }

    protected ExecutionSlot _doCreateInstanceMember(Event event, EObject parent) {
        Type _type = event.getType();
        ITypeSystemInferrer.InferenceResult _infer = null;
        if (_type != null) {
            _infer = this._iTypeSystemInferrer.infer((EObject)_type);
        }
        Type _type_1 = null;
        if (_infer != null) {
            _type_1 = _infer.getType();
        }
        return this.createInstanceMemberByType((Declaration)event, _type_1, parent);
    }

    protected ExecutionSlot _doCreateInstanceMember(Reaction reaction, EObject parent) {
        return null;
    }

    protected ExecutionSlot _doCreateInstanceMember(Operation op, EObject parent) {
        return null;
    }

    protected ExecutionSlot _doCreateInstanceMember(EnumerationType prop, Package parent) {
        return null;
    }

    protected ExecutionSlot _doCreateInstanceMember(ComplexType prop, EObject parent) {
        return null;
    }

    protected ExecutionSlot _createInstanceMemberByType(Declaration decl, Type type, EObject parent) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Don't know how to create new instance of type ");
        Class<?> _class = null;
        if (type != null) {
            _class = type.getClass();
        }
        String _name = _class.getName();
        _builder.append(_name);
        _builder.append(" for ");
        Class<?> _class_1 = null;
        if (decl != null) {
            _class_1 = decl.getClass();
        }
        String _name_1 = _class_1.getName();
        _builder.append(_name_1);
        _builder.append(" in ");
        Class<?> _class_2 = null;
        if (parent != null) {
            _class_2 = parent.getClass();
        }
        String _name_2 = _class_2.getName();
        _builder.append(_name_2);
        _builder.append("! ");
        throw new InterpreterException(_builder.toString());
    }

    protected ExecutionSlot _createInstanceMemberByType(Property prop, Type type, EObject parent) {
        ExecutionVariable _createExecutionVariable = this.createExecutionVariable(type);
        Procedures.Procedure1 _function = v -> {
            v.setName(prop.getName());
            boolean _isConst = prop.isConst();
            boolean _not = !_isConst;
            v.setWritable(_not);
        };
        return (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)_createExecutionVariable, (Procedures.Procedure1)_function);
    }

    protected ExecutionSlot _createInstanceMemberByType(Property prop, EnumerationType type, EObject parent) {
        ExecutionVariable _createExecutionVariable = this.createExecutionVariable((Type)type);
        Procedures.Procedure1 _function = v -> {
            v.setName(prop.getName());
            boolean _isConst = prop.isConst();
            boolean _not = !_isConst;
            v.setWritable(_not);
        };
        return (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)_createExecutionVariable, (Procedures.Procedure1)_function);
    }

    protected ExecutionSlot _createInstanceMemberByType(Property prop, ComplexType type, EObject parent) {
        ReferenceSlot _createReferenceSlot = this.runtimeFactory.createReferenceSlot();
        Procedures.Procedure1 _function = s -> {
            s.setName(prop.getName());
            s.setType((Type)type);
            boolean _isConst = prop.isConst();
            boolean _not = !_isConst;
            s.setWritable(_not);
            s.setReference(null);
        };
        return (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)_createReferenceSlot, (Procedures.Procedure1)_function);
    }

    protected ExecutionSlot _createInstanceMemberByType(Part prop, ComplexType type, EObject parent) {
        Object _createNewInstance = this.createNewInstance(this._iTypeSystemInferrer.infer((EObject)prop));
        Procedures.Procedure1 _function = s -> {
            s.setName(prop.getName());
            s.setType((Type)type);
            boolean _isConst = prop.isConst();
            boolean _not = !_isConst;
            s.setWritable(_not);
        };
        return (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)((ExecutionSlot)_createNewInstance), (Procedures.Procedure1)_function);
    }

    protected ExecutionSlot _createInstanceMemberByType(Event event, Type type, EObject parent) {
        ExecutionEvent _createExecutionEvent = this.runtimeFactory.createExecutionEvent();
        Procedures.Procedure1 _function = it -> {
            it.setName(event.getName());
            it.setType(event.getType());
            it.setValue(this.defaultValue(type));
            it.setDirection(Direction.get((int)event.getDirection().getValue()));
        };
        return (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)_createExecutionEvent, (Procedures.Procedure1)_function);
    }

    protected ExecutionSlot _createInstanceMemberByType(Event event, Void type, EObject parent) {
        ExecutionEvent _createExecutionEvent = this.runtimeFactory.createExecutionEvent();
        Procedures.Procedure1 _function = it -> {
            it.setName(event.getName());
            it.setType(event.getType());
            it.setDirection(Direction.get((int)event.getDirection().getValue()));
        };
        return (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)_createExecutionEvent, (Procedures.Procedure1)_function);
    }

    protected ExecutionSlot _createInstanceMemberByType(Event event, ComplexType type, EObject parent) {
        ReferenceExecutionEvent _createReferenceExecutionEvent = this.runtimeFactory.createReferenceExecutionEvent();
        Procedures.Procedure1 _function = it -> {
            it.setName(event.getName());
            it.setType((Type)type);
            it.setDirection(Direction.get((int)event.getDirection().getValue()));
            it.setReference(null);
        };
        return (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)_createReferenceExecutionEvent, (Procedures.Procedure1)_function);
    }

    protected CompositeSlot createNewArray(ITypeSystemInferrer.InferenceResult inferenceResult) {
        CompositeSlot _createCompositeSlot = this.runtimeFactory.createCompositeSlot();
        Procedures.Procedure1 _function = it -> {
            it.setTypeSpecifier(inferenceResult.asTypeSpecifier());
            StringConcatenation _builder = new StringConcatenation();
            String _name = it.getType().getName();
            _builder.append(_name);
            _builder.append("#");
            long _newInstanceId = this.newInstanceId();
            _builder.append((Object)_newInstanceId);
            it.setName(_builder.toString());
            it.setFqName(it.getName());
            it.setVisible(false);
            if (inferenceResult.getArraySize().isPresent() && (Integer)inferenceResult.getArraySize().get() > 0) {
                List _slots = it.getSlots();
                Iterable<ExecutionSlot> _createArraySlots = this.createArraySlots(inferenceResult);
                Iterables.addAll((Collection)_slots, _createArraySlots);
            }
        };
        CompositeSlot instance = (CompositeSlot)ObjectExtensions.operator_doubleArrow((Object)_createCompositeSlot, (Procedures.Procedure1)_function);
        List<ExecutionSlot> _slots = this.slots(this.heap());
        _slots.add((ExecutionSlot)instance);
        this._instanceSemantics.adaptInstance((EObject)instance, this.createArrayInstance(instance));
        this.instanceContext._invoke(instance, "init", new Object[0]);
        return instance;
    }

    protected IInterpreter.Instance createArrayInstance(CompositeSlot instanceMemory) {
        ArrayInstance _arrayInstance = new ArrayInstance();
        Procedures.Procedure1 _function = it -> {
            this.injector.injectMembers(it);
            it.setUp(instanceMemory, this.instanceContext, this);
        };
        return (IInterpreter.Instance)ObjectExtensions.operator_doubleArrow((Object)_arrayInstance, (Procedures.Procedure1)_function);
    }

    public ExecutionSlot createSlotForCollectionElement(ITypeSystemInferrer.InferenceResult elementTypeSpecifier) {
        Procedures.Procedure1 _function;
        ExecutionSlot _xblockexpression = null;
        Type elementType = elementTypeSpecifier.getType();
        ExecutionSlot _switchResult = null;
        boolean _matched = false;
        if (elementType instanceof EnumerationType) {
            _matched = true;
            ExecutionVariable _createExecutionVariable = this.runtimeFactory.createExecutionVariable();
            Procedures.Procedure1 _function2 = it -> {
                Object _defaultValue = this.defaultValue(elementType);
                Object _asValue = null;
                if (_defaultValue != null) {
                    _asValue = this._valueSemantics.asValue(_defaultValue);
                }
                it.setValue(_asValue);
                it.setWritable(true);
            };
            return (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)_createExecutionVariable, (Procedures.Procedure1)_function2);
        }
        if (!_matched && elementType instanceof ComplexType && (this.ts.isArray(elementTypeSpecifier.getType()) || this._iTypeSemantics.isValueType(elementType))) {
            _matched = true;
            Object _newInstance = this.newInstance(elementTypeSpecifier);
            return (ExecutionSlot)_newInstance;
        }
        if (!_matched && elementType instanceof ComplexType) {
            _matched = true;
            ReferenceSlot _createReferenceSlot = this.runtimeFactory.createReferenceSlot();
            _function = s -> {
                s.setType(elementType);
                s.setWritable(true);
                s.setReference(null);
            };
            _switchResult = (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)_createReferenceSlot, (Procedures.Procedure1)_function);
        }
        if (!_matched) {
            ExecutionVariable _createExecutionVariable = this.runtimeFactory.createExecutionVariable();
            _function = it -> {
                Object _defaultValue = this.defaultValue(elementType);
                Object _asValue = null;
                if (_defaultValue != null) {
                    _asValue = this._valueSemantics.asValue(_defaultValue);
                }
                it.setValue(_asValue);
                it.setWritable(true);
            };
            _switchResult = (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)_createExecutionVariable, (Procedures.Procedure1)_function);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public Iterable<ExecutionSlot> createArraySlots(ITypeSystemInferrer.InferenceResult specifier) {
        Integer _get = (Integer)specifier.getArraySize().get();
        int _minus = _get - 1;
        Functions.Function1 _function = current -> {
            ExecutionSlot _createSlotForCollectionElement = this.createSlotForCollectionElement((ITypeSystemInferrer.InferenceResult)IterableExtensions.head((Iterable)specifier.getBindings()));
            Procedures.Procedure1 _function_1 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("[");
                _builder.append(current);
                _builder.append("]");
                it.setName(_builder.toString());
                it.setType(((ITypeSystemInferrer.InferenceResult)IterableExtensions.head((Iterable)specifier.getBindings())).getType());
            };
            return (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)_createSlotForCollectionElement, (Procedures.Procedure1)_function_1);
        };
        return IterableExtensions.map((Iterable)new IntegerRange(0, _minus), (Functions.Function1)_function);
    }

    protected CompositeSlot createNewMap(ITypeSystemInferrer.InferenceResult inferenceResult) {
        CompositeSlot _createCompositeSlot = this.runtimeFactory.createCompositeSlot();
        Procedures.Procedure1 _function = it -> {
            it.setTypeSpecifier(inferenceResult.asTypeSpecifier());
            StringConcatenation _builder = new StringConcatenation();
            String _name = it.getType().getName();
            _builder.append(_name);
            _builder.append("#");
            long _newInstanceId = this.newInstanceId();
            _builder.append((Object)_newInstanceId);
            it.setName(_builder.toString());
            it.setFqName(it.getName());
        };
        CompositeSlot instance = (CompositeSlot)ObjectExtensions.operator_doubleArrow((Object)_createCompositeSlot, (Procedures.Procedure1)_function);
        List<ExecutionSlot> _slots = this.slots(this.heap());
        _slots.add((ExecutionSlot)instance);
        this._instanceSemantics.adaptInstance((EObject)instance, this.createMapInstance(instance));
        this.instanceContext._invoke(instance, "init", new Object[0]);
        return instance;
    }

    protected IInterpreter.Instance createMapInstance(CompositeSlot instanceMemory) {
        MapInstance _mapInstance = new MapInstance();
        Procedures.Procedure1 _function = it -> {
            this.injector.injectMembers(it);
            it.setUp(instanceMemory, this.instanceContext, this);
        };
        return (IInterpreter.Instance)ObjectExtensions.operator_doubleArrow((Object)_mapInstance, (Procedures.Procedure1)_function);
    }

    protected Object defaultValue(Type t) {
        Object _defaultValue = this.typeValueProvider.defaultValue(t);
        Object _asValue = null;
        if (_defaultValue != null) {
            _asValue = this._valueSemantics.asValue(_defaultValue);
        }
        return _asValue;
    }

    protected void add(CompositeSlot it, ExecutionSlot child) {
        it.getSlots().add(child);
        StringConcatenation _builder = new StringConcatenation();
        String _fqName = it.getFqName();
        _builder.append(_fqName);
        _builder.append(".");
        String _name = child.getName();
        _builder.append(_name);
        child.setFqName(_builder.toString());
    }

    protected List<ExecutionSlot> _slots(Object it) {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList());
    }

    protected List<ExecutionSlot> _slots(CompositeSlot it) {
        return it.getSlots();
    }

    @Override
    public Object copyInstance(Object instance) {
        return this.doCopy(instance);
    }

    protected ExecutionSlot _doCopy(Object instance) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Don't know how to copy instance of type ");
        Class<?> _class = null;
        if (instance != null) {
            _class = instance.getClass();
        }
        String _name = _class.getName();
        _builder.append(_name);
        _builder.append(" ! ");
        throw new InterpreterException(_builder.toString());
    }

    protected ExecutionSlot _doCopy(CompositeSlot slot) {
        CompositeSlot _copy = (CompositeSlot)EcoreUtil.copy((EObject)slot);
        Procedures.Procedure1 _function = it -> {
            boolean _tripleNotEquals;
            String _name = slot.getName();
            String _plus = _name + "@copy";
            it.setName(_plus);
            IInterpreter.Instance _instance = this._instanceSemantics.instance(slot);
            boolean bl = _tripleNotEquals = _instance != null;
            if (_tripleNotEquals) {
                this.cloneInstance(this._instanceSemantics.instance(slot), (ExecutionSlot)it);
            }
        };
        return (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)_copy, (Procedures.Procedure1)_function);
    }

    protected ExecutionSlot _doCopy(ReferenceSlot slot) {
        ReferenceSlot _copy = (ReferenceSlot)EcoreUtil.copy((EObject)slot);
        Procedures.Procedure1 _function = it -> it.setReference(slot.getReference());
        return (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)_copy, (Procedures.Procedure1)_function);
    }

    protected ExecutionSlot _doCopy(ExecutionSlot slot) {
        return (ExecutionSlot)EcoreUtil.copy((EObject)slot);
    }

    protected Object _cloneInstance(ResolvingRuntimeInstance it, CompositeSlot slot) {
        Object _clone = it.clone();
        ResolvingRuntimeInstance cloneInstance = (ResolvingRuntimeInstance)_clone;
        cloneInstance.setUp(slot, it.getExecutionContext());
        this._instanceSemantics.adaptInstance((EObject)slot, cloneInstance);
        return null;
    }

    protected Object _cloneInstance(Object it, ExecutionSlot slot) {
        return null;
    }

    protected Object heap() {
        return this.instanceContext.getHeap();
    }

    @XbaseGenerated
    protected Object createNewInstance(Object it) {
        if (it instanceof ComplexType) {
            return this._createNewInstance((ComplexType)it);
        }
        if (it instanceof Event) {
            return this._createNewInstance((Event)it);
        }
        if (it instanceof Property) {
            return this._createNewInstance((Property)it);
        }
        if (it instanceof Package) {
            return this._createNewInstance((Package)it);
        }
        if (it instanceof TypeSpecifier) {
            return this._createNewInstance((TypeSpecifier)it);
        }
        if (it instanceof ITypeSystemInferrer.InferenceResult) {
            return this._createNewInstance((ITypeSystemInferrer.InferenceResult)it);
        }
        if (it != null) {
            return this._createNewInstance(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    protected Object createNewInstance(Object type, Object ts) {
        if (type instanceof EnumerationType && ts instanceof ITypeSystemInferrer.InferenceResult) {
            return this._createNewInstance((EnumerationType)type, (ITypeSystemInferrer.InferenceResult)ts);
        }
        if (type instanceof TypeParameter && ts instanceof TypeSpecifier) {
            return this._createNewInstance((TypeParameter)type, (TypeSpecifier)ts);
        }
        if (type instanceof ComplexType && ts instanceof ITypeSystemInferrer.InferenceResult) {
            return this._createNewInstance((ComplexType)type, (ITypeSystemInferrer.InferenceResult)ts);
        }
        if (type instanceof PrimitiveType && ts instanceof ITypeSystemInferrer.InferenceResult) {
            return this._createNewInstance((PrimitiveType)type, (ITypeSystemInferrer.InferenceResult)ts);
        }
        if (type != null && ts instanceof TypeSpecifier) {
            return this._createNewInstance(type, (TypeSpecifier)ts);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type, ts).toString());
    }

    @XbaseGenerated
    public ExecutionSlot doCreateInstanceMember(Declaration prop, EObject parent) {
        if (prop instanceof EnumerationType && parent instanceof Package) {
            return this._doCreateInstanceMember((EnumerationType)prop, (Package)parent);
        }
        if (prop instanceof Property && parent instanceof ComplexType) {
            return this._doCreateInstanceMember((Property)prop, (ComplexType)parent);
        }
        if (prop instanceof ComplexType && parent != null) {
            return this._doCreateInstanceMember((ComplexType)prop, parent);
        }
        if (prop instanceof Event && parent != null) {
            return this._doCreateInstanceMember((Event)prop, parent);
        }
        if (prop instanceof Operation && parent != null) {
            return this._doCreateInstanceMember((Operation)prop, parent);
        }
        if (prop instanceof Property && parent != null) {
            return this._doCreateInstanceMember((Property)prop, parent);
        }
        if (prop instanceof Reaction && parent != null) {
            return this._doCreateInstanceMember((Reaction)prop, parent);
        }
        if (prop != null && parent != null) {
            return this._doCreateInstanceMember(prop, parent);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(prop, parent).toString());
    }

    @XbaseGenerated
    protected ExecutionSlot createInstanceMemberByType(Declaration prop, Type type, EObject parent) {
        if (prop instanceof Part && type instanceof ComplexType) {
            return this._createInstanceMemberByType((Part)prop, (ComplexType)type, parent);
        }
        if (prop instanceof Property && type instanceof EnumerationType) {
            return this._createInstanceMemberByType((Property)prop, (EnumerationType)type, parent);
        }
        if (prop instanceof Event && type instanceof ComplexType) {
            return this._createInstanceMemberByType((Event)prop, (ComplexType)type, parent);
        }
        if (prop instanceof Property && type instanceof ComplexType) {
            return this._createInstanceMemberByType((Property)prop, (ComplexType)type, parent);
        }
        if (prop instanceof Event && type != null) {
            return this._createInstanceMemberByType((Event)prop, type, parent);
        }
        if (prop instanceof Property && type != null) {
            return this._createInstanceMemberByType((Property)prop, type, parent);
        }
        if (prop instanceof Event && type == null) {
            return this._createInstanceMemberByType((Event)prop, (Void)null, parent);
        }
        if (prop != null && type != null) {
            return this._createInstanceMemberByType(prop, type, parent);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(prop, type, parent).toString());
    }

    @XbaseGenerated
    protected List<ExecutionSlot> slots(Object it) {
        if (it instanceof CompositeSlot) {
            return this._slots((CompositeSlot)it);
        }
        if (it != null) {
            return this._slots(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    protected ExecutionSlot doCopy(Object slot) {
        if (slot instanceof ReferenceSlot) {
            return this._doCopy((ReferenceSlot)slot);
        }
        if (slot instanceof CompositeSlot) {
            return this._doCopy((CompositeSlot)slot);
        }
        if (slot instanceof ExecutionSlot) {
            return this._doCopy((ExecutionSlot)slot);
        }
        if (slot != null) {
            return this._doCopy(slot);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(slot).toString());
    }

    @XbaseGenerated
    protected Object cloneInstance(Object it, ExecutionSlot slot) {
        if (it instanceof ResolvingRuntimeInstance && slot instanceof CompositeSlot) {
            return this._cloneInstance((ResolvingRuntimeInstance)it, (CompositeSlot)slot);
        }
        if (it != null && slot != null) {
            return this._cloneInstance(it, slot);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, slot).toString());
    }
}

