/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter.types;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.yakindu.base.expressions.interpreter.base.IInstanceFactory;
import com.yakindu.base.expressions.interpreter.base.IInterpreter;
import com.yakindu.base.expressions.interpreter.base.InstanceSemantics;
import com.yakindu.base.expressions.interpreter.base.InterpreterException;
import com.yakindu.base.expressions.interpreter.base.SRuntimeInterpreter;
import com.yakindu.base.expressions.interpreter.base.ValueSemantics;
import com.yakindu.base.expressions.interpreter.scheduling.ITimeTaskScheduler;
import com.yakindu.base.expressions.interpreter.types.PackageHelper;
import com.yakindu.sct.model.sruntime.CompositeSlot;
import com.yakindu.sct.model.sruntime.ExecutionArgument;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.sruntime.ExecutionEvent;
import com.yakindu.sct.model.sruntime.ExecutionSlot;
import com.yakindu.sct.model.sruntime.ReferenceSlot;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public abstract class TypesInterpreter
extends SRuntimeInterpreter {
    @Inject
    @Extension
    protected Injector injector;
    @Inject
    @Extension
    protected IInstanceFactory factory;
    @Inject
    @Extension
    protected InstanceSemantics _instanceSemantics;
    @Inject
    @Extension
    protected PackageHelper _packageHelper;
    @Inject
    @Extension
    protected ValueSemantics _valueSemantics;
    @Inject
    @Accessors
    protected ITimeTaskScheduler timingService;
    protected IInterpreter.Execution execution;

    @Override
    public Object newInstance(Object type) {
        String _simpleName = type.getClass().getSimpleName();
        String _plus = "newInstance(" + _simpleName;
        String _plus_1 = _plus + ")";
        Runnable _function = () -> this.pushValue(this.factory.newInstance(type));
        return this.process(_plus_1, _function);
    }

    @Override
    public void reset() {
        this.cleanupMemory();
    }

    @Override
    public void prepareExecution(Object program) {
        this.execution.provideExecution(program);
    }

    @Override
    public void setValue(Object slot, Object value) {
        this.doSet(slot, value);
    }

    protected void _doSet(Object e, Object value) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Don't know how to set member of type ");
        Class<?> _class = null;
        if (e != null) {
            _class = e.getClass();
        }
        String _name = _class.getName();
        _builder.append(_name);
        _builder.append(" ! ");
        throw new InterpreterException(_builder.toString());
    }

    protected void _doSet(ExecutionSlot slot, Object value) {
        String _name = slot.getName();
        String _plus = "request set " + _name;
        Runnable _function = () -> {
            String _name_1 = slot.getName();
            String _plus_1 = "set " + _name_1;
            Runnable _function_1 = () -> {
                IInterpreter.Instance inst = this.instance(slot);
                if (inst != null) {
                    inst.set(slot, value);
                } else {
                    this._valueSemantics.setValue(slot, value);
                }
            };
            this._execute(_plus_1, _function_1);
        };
        this.process(_plus, _function);
    }

    @Override
    public void set(Object slot, Object value) {
        this.do_Set(slot, value);
    }

    protected void _do_Set(Object e, Object value) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Don't know how to set member of type ");
        Class<?> _class = null;
        if (e != null) {
            _class = e.getClass();
        }
        String _name = _class.getName();
        _builder.append(_name);
        _builder.append(" ! ");
        throw new InterpreterException(_builder.toString());
    }

    protected void _do_Set(ExecutionSlot slot, Object value) {
        String _name = slot.getName();
        String _plus = "set " + _name;
        Runnable _function = () -> {
            IInterpreter.Instance inst = this.instance(slot);
            if (inst != null) {
                inst.set(slot, value);
            } else {
                this._valueSemantics.setValue(slot, value);
            }
        };
        this._execute(_plus, _function);
    }

    @Override
    public Object get(Object slot) {
        return this._valueSemantics.asValue(slot);
    }

    @Override
    public Object getValue(Object slot) {
        return this._valueSemantics.asValue(slot);
    }

    @Override
    public void _invoke(Object receiver, String operation, Object ... args) {
        this.do_invoke(receiver, operation, args);
    }

    protected void _do_invoke(Object receiver, String operation, Object ... args) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Don't know how to invoke operation for receiver of type ");
        Class<?> _class = null;
        if (receiver != null) {
            _class = receiver.getClass();
        }
        String _name = _class.getName();
        _builder.append(_name);
        _builder.append(" ! ");
        throw new InterpreterException(_builder.toString());
    }

    protected void _do_invoke(CompositeSlot receiver, String operation, Object ... args) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("call ");
        String _name = receiver.getName();
        _builder.append(_name);
        _builder.append(".");
        _builder.append(operation);
        Runnable _function = () -> {
            Consumer<Object> _function_1 = it -> this.pushValue(it);
            ((List)Conversions.doWrapArray((Object)args)).forEach(_function_1);
            this.instance(receiver).provideExecution(operation);
        };
        Procedures.Procedure1 _function_1 = onError -> {
            throw new InterpreterException((Throwable)onError);
        };
        this._try(_builder.toString(), _function, (Procedures.Procedure1<? super Throwable>)_function_1);
    }

    @Override
    public Object invokeOperation(Object receiver, String operation, Object ... args) {
        return this.doInvoke(receiver, operation, args);
    }

    protected Object _doInvoke(Object receiver, String operation, Object ... args) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Don't know how to invoke operation for receiver of type ");
        Class<?> _class = null;
        if (receiver != null) {
            _class = receiver.getClass();
        }
        String _name = _class.getName();
        _builder.append(_name);
        _builder.append(" ! ");
        throw new InterpreterException(_builder.toString());
    }

    protected Object _doInvoke(CompositeSlot receiver, String operation, Object ... args) {
        Runnable _function = () -> {
            Consumer<Object> _function_1 = it -> this.pushValue(it);
            ((List)Conversions.doWrapArray((Object)args)).forEach(_function_1);
            this.instance(receiver).provideExecution(operation);
        };
        return this.process("request invoke " + operation, _function);
    }

    @Override
    public void raiseEvent(Object e, Object value) {
        this.doRaise(e, value);
    }

    protected void _doRaise(Object e, Object value) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Don't know how to raise event of type ");
        Class<?> _class = null;
        if (e != null) {
            _class = e.getClass();
        }
        String _name = _class.getName();
        _builder.append(_name);
        _builder.append(" ! ");
        throw new InterpreterException(_builder.toString());
    }

    protected void _doRaise(ExecutionEvent e, Object value) {
        String _name = e.getName();
        String _plus = "request raise " + _name;
        Runnable _function = () -> {
            String _name_1 = e.getName();
            String _plus_1 = "raise " + _name_1;
            Runnable _function_1 = () -> this.executeRaise(e, value);
            this._execute(_plus_1, _function_1);
        };
        this.process(_plus, _function);
    }

    protected void executeRaise(ExecutionEvent e, Object value) {
        this.raise(e, value);
    }

    @Override
    public void _requestExecution(Object program, IInterpreter.Execution requester) {
        if (requester == this.execution) {
            CompositeSlot _SELF = this.SELF();
            IInterpreter.Instance _instance = null;
            if (_SELF != null) {
                _instance = this.instance(_SELF);
            }
            if (_instance != null) {
                _instance.provideExecution(program);
            }
        } else {
            this.execution.provideExecution(program);
        }
    }

    @Override
    public void _schedule(String jobId, long duration, boolean periodic, Runnable action) {
        Runnable _function = () -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("timeout(");
            _builder.append(jobId);
            _builder.append(")");
            this.process(_builder.toString(), action);
        };
        ITimeTaskScheduler.TimeTask _timeTask = new ITimeTaskScheduler.TimeTask(jobId, _function);
        this.timingService.scheduleTimeTask(_timeTask, periodic, duration);
    }

    @Override
    public void _unschedule(String jobId) {
        this.timingService.unscheduleTimeTask(jobId);
    }

    @Override
    public void raise(Object o, Object value) {
        this.raiseSlot(o, value);
    }

    protected void _raiseSlot(Object o, Object value) {
        String _name = o.getClass().getName();
        String _plus = "Cannot raise on slot of type " + _name;
        throw new InterpreterException(_plus);
    }

    protected void _raiseSlot(ExecutionEvent it, Object value) {
        boolean _tripleNotEquals;
        IInterpreter.Instance _instance = this.instance(it);
        boolean bl = _tripleNotEquals = _instance != null;
        if (_tripleNotEquals) {
            this.instance(it).raise(it, value);
        } else {
            it.setRaised(true);
            this.set(it, value);
        }
    }

    @Override
    public long currentTime() {
        return this.timingService.getCurrentTime();
    }

    @Override
    public Object resolve(Object owner, Object symbol) {
        Object _xifexpression = null;
        if (owner == null) {
            Object slot;
            Object _xblockexpression = null;
            ExecutionContext _localScope = this.localScope();
            Object _resolveSlot = null;
            if (_localScope != null) {
                _resolveSlot = this.resolveSlot(_localScope, symbol);
            }
            if ((slot = _resolveSlot) != null) {
                return slot;
            }
            _xifexpression = _xblockexpression = this.resolveSlot(this.heap, symbol);
        } else {
            _xifexpression = this.resolveSlot(owner, symbol);
        }
        return _xifexpression;
    }

    protected Object _resolveSlot(Object slot, Object symbol) {
        throw new InterpreterException("Cannot resolve symbol '" + String.valueOf(symbol) + "' on slot '" + String.valueOf(slot) + "'!");
    }

    protected Object _resolveSlot(ExecutionArgument slot, String symbol) {
        return this.resolveSlot(slot.getValue(), symbol);
    }

    protected Object _resolveSlot(CompositeSlot slot, String symbol) {
        Object SELF;
        Functions.Function1 _function = s -> {
            String _name = s.getName();
            return Objects.equals(_name, symbol);
        };
        Object resolvedSlot = IterableExtensions.findFirst((Iterable)slot.getSlots(), (Functions.Function1)_function);
        if (resolvedSlot != null) {
            return resolvedSlot;
        }
        IInterpreter.Instance inst = this.instance(slot);
        if (inst != null && inst instanceof IInterpreter.Resolver) {
            resolvedSlot = inst.resolve(slot, symbol);
        }
        if (resolvedSlot != null) {
            return resolvedSlot;
        }
        Functions.Function1 _function_1 = s -> {
            String _name = s.getName();
            return Objects.equals(_name, InstanceSemantics.SELF_NAME);
        };
        ExecutionSlot selfSlot = (ExecutionSlot)IterableExtensions.findFirst((Iterable)slot.getSlots(), (Functions.Function1)_function_1);
        if (selfSlot != null && (SELF = selfSlot.getValue()) != slot) {
            resolvedSlot = this.resolve(SELF, symbol);
        }
        return resolvedSlot;
    }

    protected Object _resolveSlot(ReferenceSlot slot, String symbol) {
        boolean _tripleNotEquals;
        ExecutionSlot _reference = slot.getReference();
        boolean bl = _tripleNotEquals = _reference != null;
        if (_tripleNotEquals) {
            return this.resolveSlot(slot.getReference(), symbol);
        }
        throw new InterpreterException("Cannot resolve '" + symbol + "' for null reference");
    }

    protected Object _resolveSlot(CompositeSlot slot, Long index) {
        boolean _greaterThan;
        int _size = slot.getSlots().size();
        boolean bl = _greaterThan = (long)_size > index;
        if (_greaterThan) {
            return slot.getSlots().get(index.intValue());
        }
        int _size_1 = slot.getSlots().size();
        int _minus = _size_1 - 1;
        String _plus = "Array index (" + String.valueOf(index) + ") out of bounds (0.." + String.valueOf((Object)_minus);
        String _plus_1 = _plus + "). ";
        throw new InterpreterException(_plus_1);
    }

    public CompositeSlot SELF() {
        ExecutionContext _localScope = this.localScope();
        Object _resolve = null;
        if (_localScope != null) {
            _resolve = this.resolve(_localScope, InstanceSemantics.SELF_NAME);
        }
        Object _value = this.getValue(_resolve);
        return (CompositeSlot)_value;
    }

    @Override
    public IInterpreter.Instance instance(Object it) {
        return this._instanceSemantics.instance(it);
    }

    @XbaseGenerated
    public void doSet(Object slot, Object value) {
        if (slot instanceof ExecutionSlot) {
            this._doSet((ExecutionSlot)slot, value);
            return;
        }
        if (slot != null) {
            this._doSet(slot, value);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(slot, value).toString());
    }

    @XbaseGenerated
    public void do_Set(Object slot, Object value) {
        if (slot instanceof ExecutionSlot) {
            this._do_Set((ExecutionSlot)slot, value);
            return;
        }
        if (slot != null) {
            this._do_Set(slot, value);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(slot, value).toString());
    }

    @XbaseGenerated
    public void do_invoke(Object receiver, String operation, Object[] args) {
        if (receiver instanceof CompositeSlot) {
            this._do_invoke((CompositeSlot)receiver, operation, args);
            return;
        }
        if (receiver != null) {
            this._do_invoke(receiver, operation, args);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(receiver, operation, args).toString());
    }

    @XbaseGenerated
    protected Object doInvoke(Object receiver, String operation, Object[] args) {
        if (receiver instanceof CompositeSlot) {
            return this._doInvoke((CompositeSlot)receiver, operation, args);
        }
        if (receiver != null) {
            return this._doInvoke(receiver, operation, args);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(receiver, operation, args).toString());
    }

    @XbaseGenerated
    public void doRaise(Object e, Object value) {
        if (e instanceof ExecutionEvent) {
            this._doRaise((ExecutionEvent)e, value);
            return;
        }
        if (e != null) {
            this._doRaise(e, value);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e, value).toString());
    }

    @XbaseGenerated
    public void raiseSlot(Object it, Object value) {
        if (it instanceof ExecutionEvent) {
            this._raiseSlot((ExecutionEvent)it, value);
            return;
        }
        if (it != null) {
            this._raiseSlot(it, value);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, value).toString());
    }

    @XbaseGenerated
    public Object resolveSlot(Object slot, Object symbol) {
        if (slot instanceof ReferenceSlot && symbol instanceof String) {
            return this._resolveSlot((ReferenceSlot)slot, (String)symbol);
        }
        if (slot instanceof CompositeSlot && symbol instanceof Long) {
            return this._resolveSlot((CompositeSlot)slot, (Long)symbol);
        }
        if (slot instanceof CompositeSlot && symbol instanceof String) {
            return this._resolveSlot((CompositeSlot)slot, (String)symbol);
        }
        if (slot instanceof ExecutionArgument && symbol instanceof String) {
            return this._resolveSlot((ExecutionArgument)slot, (String)symbol);
        }
        if (slot != null && symbol != null) {
            return this._resolveSlot(slot, symbol);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(slot, symbol).toString());
    }

    @Pure
    public ITimeTaskScheduler getTimingService() {
        return this.timingService;
    }

    public void setTimingService(ITimeTaskScheduler timingService) {
        this.timingService = timingService;
    }
}

