/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.cpp.qt;

import com.google.inject.Inject;
import com.yakindu.sct.generator.c.extensions.GenmodelEntries;
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations;
import com.yakindu.sct.generator.cpp.files.TimerServiceSource;
import com.yakindu.sct.generator.cpp.qt.QtNaming;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class QtTimerServiceImplementation
extends TimerServiceSource {
    @Inject
    @Extension
    private QtNaming _qtNaming;
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;

    public String content(ExecutionFlow it, GeneratorEntry entry, @Extension IGenArtifactConfigurations locations) {
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._genmodelEntries.getLicenseText(entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"");
        String _relativeTo = locations.relativeTo(this._cppFileNaming.h(this._cppFileNaming.timerServiceModule()), this._cppFileNaming.cpp(this._cppFileNaming.timerServiceModule()));
        _builder.append(_relativeTo);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("using namespace sc::qt;");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("SCTimer::SCTimer(QObject *parent, ");
        CharSequence _weakPtr = this._cppPointers.weakPtr();
        _builder.append((Object)_weakPtr);
        _builder.append("sc::timer::TimedInterface");
        CharSequence _pointerType = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType);
        _builder.append(" machine, const sc::eventid id) :");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("machine(machine),");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("eventId(id)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("connect(this, SIGNAL(timeout()), this, SLOT(triggerTimeEvent()));");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void SCTimer::triggerTimeEvent()");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("emit fireTimeEvent(machine.lock(), eventId);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("SCTimer::~SCTimer()");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("SCTimerService::SCTimerService(QObject *parent)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("SCTimerService::~SCTimerService() ");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void SCTimerService::setTimer(");
        CharSequence _sharedPtr = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr);
        _builder.append("sc::timer::TimedInterface");
        CharSequence _pointerType_1 = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType_1);
        _builder.append(" statemachine, sc::eventid event, ");
        String _fqName = this._cppTypes.sc_time().fqName();
        _builder.append(_fqName);
        _builder.append(" time_ms, bool isPeriodic)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        CharSequence _sharedPtr_1 = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr_1, "    ");
        _builder.append("SCTimer");
        CharSequence _pointerType_2 = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType_2, "    ");
        _builder.append(" timer = nullptr;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("// retrieve the timer map for the state machine");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("QMap<sc::eventid, ");
        CharSequence _sharedPtr_2 = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr_2, "    ");
        _builder.append("SCTimer");
        CharSequence _pointerType_3 = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType_3, "    ");
        _builder.append("> *eventTimerMap = machineTimerMapMap.value(statemachine);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("// retrieve and stop a timer if it already exists for the event.");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if (eventTimerMap != nullptr) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if (eventTimerMap->contains(event)) {");
        _builder.newLine();
        _builder.append("           ");
        CharSequence _sharedPtr_3 = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr_3, "           ");
        _builder.append("SCTimer");
        CharSequence _pointerType_4 = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType_4, "           ");
        _builder.append(" timer = eventTimerMap->value(event);");
        _builder.newLineIfNotEmpty();
        _builder.append("           ");
        _builder.append("timer->stop();");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("//setup the event timer map for the state machine if it not alrewady exists");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if ( eventTimerMap == nullptr) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("eventTimerMap = new QMap<sc::eventid, ");
        CharSequence _sharedPtr_4 = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr_4, "        ");
        _builder.append("SCTimer");
        CharSequence _pointerType_5 = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType_5, "        ");
        _builder.append(">();");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("machineTimerMapMap.insert(statemachine, eventTimerMap);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("// create a timer if it not already exists");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if (timer == nullptr) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("timer = ");
        CharSequence _makeSharedPtr = this._cppPointers.makeSharedPtr();
        _builder.append((Object)_makeSharedPtr, "        ");
        _builder.append("SCTimer");
        CharSequence _pointerType_6 = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType_6, "        ");
        _builder.append("(this, statemachine, event);");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("eventTimerMap->insert(event, timer);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("timer->connect(timer.get(), SIGNAL(fireTimeEvent(");
        CharSequence _sharedPtr_5 = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr_5, "        ");
        _builder.append("sc::timer::TimedInterface");
        CharSequence _pointerType_7 = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType_7, "        ");
        _builder.append(",sc::eventid)), this, SLOT(raiseTimeEvent(");
        CharSequence _sharedPtr_6 = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr_6, "        ");
        _builder.append("sc::timer::TimedInterface");
        CharSequence _pointerType_8 = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType_8, "        ");
        _builder.append(",sc::eventid)));");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("// amor the timer");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("timer->setTimerType(Qt::TimerType::PreciseTimer);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("timer->setInterval(time_ms);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("timer->setSingleShot(!isPeriodic);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("timer->start();");
        _builder.newLine();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        CharSequence _sharedPtr_7 = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr_7);
        _builder.append("SCTimer");
        CharSequence _pointerType_9 = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType_9);
        _builder.append(" SCTimerService::getTimer(");
        CharSequence _sharedPtr_8 = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr_8);
        _builder.append("sc::timer::TimedInterface");
        CharSequence _pointerType_10 = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType_10);
        _builder.append(" machine, sc::eventid event)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        CharSequence _sharedPtr_9 = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr_9, "    ");
        _builder.append("SCTimer");
        CharSequence _pointerType_11 = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType_11, "    ");
        _builder.append(" timer = nullptr;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("// retrieve the timer map for the state machine");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("QMap<sc::eventid, ");
        CharSequence _sharedPtr_10 = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr_10, "    ");
        _builder.append("SCTimer");
        CharSequence _pointerType_12 = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType_12, "    ");
        _builder.append("> *eventTimerMap = machineTimerMapMap.value(machine);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("// retrieve and a timer registered for the event.");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if (eventTimerMap != nullptr) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("if (eventTimerMap->contains(event)) {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("timer = eventTimerMap->value(event);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return timer;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("void SCTimerService::unsetTimer(");
        CharSequence _sharedPtr_11 = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr_11);
        _builder.append("sc::timer::TimedInterface");
        CharSequence _pointerType_13 = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType_13);
        _builder.append(" statemachine, sc::eventid event)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        CharSequence _sharedPtr_12 = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr_12, "    ");
        _builder.append("SCTimer");
        CharSequence _pointerType_14 = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType_14, "    ");
        _builder.append(" timer = this->getTimer(statemachine, event);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if (timer != nullptr) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("timer->stop();");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("// do nothing else as the timer may be reused...");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("void SCTimerService::raiseTimeEvent(");
        CharSequence _sharedPtr_13 = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr_13);
        _builder.append("sc::timer::TimedInterface");
        CharSequence _pointerType_15 = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType_15);
        _builder.append(" machine, sc::eventid event)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        CharSequence _sharedPtr_14 = this._cppPointers.sharedPtr();
        _builder.append((Object)_sharedPtr_14, "    ");
        _builder.append("SCTimer");
        CharSequence _pointerType_16 = this._cppPointers.pointerType();
        _builder.append((Object)_pointerType_16, "    ");
        _builder.append(" timer = this->getTimer(machine, event);");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("if (timer != nullptr && timer->isSingleShot()) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("timer->stop();");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if (machine != nullptr) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("machine->raiseTimeEvent(event);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("void SCTimerService::cancel()");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }
}

