/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.search.ui;

import com.google.common.collect.Sets;
import com.yakindu.base.base.NamedElement;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.search.core.filter.ClassesFilter;
import com.yakindu.sct.search.core.filter.FeatureFilter;
import com.yakindu.sct.search.core.filter.FeatureRegexFilter;
import com.yakindu.sct.search.core.filter.ModelFilter;
import com.yakindu.sct.search.core.filter.NoFilter;
import com.yakindu.sct.search.core.filter.PatternBuilder;
import com.yakindu.sct.search.ui.ModelSearchPlugin;
import com.yakindu.sct.search.ui.utils.NavigationUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.xtext.EcoreUtil2;

public class UIModelElementDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "com.yakindu.sct.modelsearch.ui.filter";
    private Resource resource;

    public UIModelElementDialog(Shell shell, Resource resource) {
        super(shell);
        this.resource = resource;
        this.setListLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)));
        this.setDetailsLabelProvider(new FilterLabelDetailProvider());
        this.setSelectionHistory(new ModelElementSelectionHistory());
        this.setSeparatorLabel("Statechart matches");
        this.addListFilter(new ResourceFilter(resource.getURI()));
        this.setTitle("Navigate to Model Element");
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ModelItemFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        if (itemsFilter instanceof ModelItemFilter) {
            List members = EcoreUtil2.eAllContentsAsList((Resource)this.resource);
            progressMonitor.beginTask("Search", members.size());
            for (EObject eObject : members) {
                contentProvider.add((Object)eObject, itemsFilter);
                progressMonitor.worked(1);
            }
        }
        progressMonitor.done();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = ModelSearchPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = ModelSearchPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        if (item instanceof NamedElement) {
            return ((NamedElement)item).getName();
        }
        return "";
    }

    protected Comparator<Object> getItemsComparator() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String name1 = o1 instanceof NamedElement ? ((NamedElement)o1).getName() : "";
                String name2 = o2 instanceof NamedElement ? ((NamedElement)o2).getName() : "";
                return name1.compareTo(name2);
            }
        };
    }

    protected void okPressed() {
        StructuredSelection selectedItems = this.getSelectedItems();
        if (selectedItems.size() > 0) {
            NavigationUtils.navigate((EObject)selectedItems.getFirstElement());
        }
        super.okPressed();
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    public static class FilterLabelDetailProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        protected ILabelProvider delegate = new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));

        public Image getImage(Object element) {
            return this.delegate.getImage(element);
        }

        public String getText(Object entry) {
            URI uri = EcoreUtil.getURI((EObject)((EObject)entry));
            return uri.trimFragment().toPlatformString(true);
        }
    }

    public class ModelElementSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private static final String FRAGMENT = "uriFragment";

        protected Object restoreItemFromMemento(IMemento element) {
            String string = element.getString(FRAGMENT);
            if (string != null) {
                return UIModelElementDialog.this.resource.getEObject(string);
            }
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento element) {
            element.putString(FRAGMENT, EcoreUtil.getURI((EObject)((EObject)item)).fragment());
        }
    }

    protected class ModelItemFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private ModelFilter filter;

        public ModelItemFilter() {
            super((FilteredItemsSelectionDialog)UIModelElementDialog.this);
            String patternText = PatternBuilder.NonRegexPatternHelper.generateRegexTextPattern((String)this.getPattern());
            if (patternText.equals("")) {
                patternText = ".*";
            }
            Pattern filterPattern = Pattern.compile(patternText, 2);
            NoFilter newFilter = new NoFilter();
            ClassesFilter classFilter = new ClassesFilter((Set)Sets.newHashSet((Object[])new Class[]{State.class, Region.class}));
            FeatureFilter featureFilter = new FeatureFilter("name");
            FeatureRegexFilter regeExFilter = new FeatureRegexFilter(filterPattern);
            regeExFilter.setShouldMatchBeginning(true);
            featureFilter.addChild((ModelFilter)regeExFilter);
            classFilter.addChild((ModelFilter)featureFilter);
            newFilter.addChild((ModelFilter)classFilter);
            this.filter = newFilter;
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            if (item instanceof EObject) {
                return this.filter.apply((EObject)item).size() > 0;
            }
            return false;
        }
    }

    public static class ResourceFilter
    extends ViewerFilter {
        private URI validURI;

        public ResourceFilter(URI validURI) {
            this.validURI = validURI;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.validURI.equals(((EObject)element).eResource().getURI());
        }
    }
}

