/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.search.ui;

import com.yakindu.sct.search.core.IModelSearchEngine;
import com.yakindu.sct.search.core.IModelSearchResultListener;
import com.yakindu.sct.search.core.ModelSearchResultEntry;
import com.yakindu.sct.search.core.ModelSearchResultEvent;
import com.yakindu.sct.search.ui.SearchImages;
import com.yakindu.sct.search.ui.UIModelSearchQuery;
import com.yakindu.sct.search.ui.UIModelSearchResult;
import com.yakindu.sct.search.ui.actions.NavigateToAction;
import com.yakindu.sct.search.ui.listener.ResultTreeDoubleClickListener;
import com.yakindu.sct.search.ui.provider.LocationLabelProvider;
import com.yakindu.sct.search.ui.provider.ModelSearchContentProvider;
import com.yakindu.sct.search.ui.provider.ResultColumnLabelProvider;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class UIModelSearchResultPage
implements ISearchResultPage,
IModelSearchResultListener {
    private TreeViewer viewer;
    private ISearchResultViewPart viewPart;
    private String id;
    private IPageSite pageSite;
    private UIModelSearchResult search;
    private Point mouseLocation;
    MouseMoveListener moveListener = new MouseMoveListener(){

        public void mouseMove(MouseEvent e) {
            UIModelSearchResultPage.this.mouseLocation = new Point(e.x, e.y);
        }
    };
    MouseAdapter clickListener = new MouseAdapter(){

        public void mouseUp(MouseEvent e) {
            ViewerCell cell = UIModelSearchResultPage.this.viewer.getCell(UIModelSearchResultPage.this.mouseLocation);
            if (cell == null || cell.getColumnIndex() == 0) {
                return;
            }
            Object element = cell.getElement();
            if (element instanceof ModelSearchResultEntry) {
                return;
            }
        }
    };

    public void createControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 268436228);
        TreeViewerColumn path = new TreeViewerColumn(this.viewer, 0, 0);
        path.setLabelProvider((CellLabelProvider)new LocationLabelProvider());
        TreeViewerColumn result = new TreeViewerColumn(this.viewer, 0, 1);
        result.setLabelProvider((CellLabelProvider)new ResultColumnLabelProvider(this.viewer));
        path.getColumn().setWidth(300);
        path.getColumn().setText("Location");
        result.getColumn().setWidth(300);
        result.getColumn().setText("Matches");
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ModelSearchContentProvider(this.viewer));
        this.viewer.addDoubleClickListener((IDoubleClickListener)new ResultTreeDoubleClickListener());
        this.viewer.getControl().addMouseListener((MouseListener)this.clickListener);
        this.viewer.getControl().addMouseMoveListener(this.moveListener);
        this.viewer.getControl().setMenu(new Menu((Control)parent));
        this.viewer.getTree().setItemCount(0);
        this.viewer.setUseHashlookup(true);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object element;
                ISelection selection = UIModelSearchResultPage.this.viewer.getSelection();
                if (!selection.isEmpty() && selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) instanceof EObject) {
                    manager.add((IAction)new NavigateToAction((EObject)element));
                }
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.hookAction();
    }

    public void dispose() {
        this.viewer.getControl().dispose();
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public String getID() {
        return this.id;
    }

    public String getLabel() {
        if (this.search != null) {
            return this.getLabel(this.search);
        }
        return "";
    }

    protected String getLabel(UIModelSearchResult search) {
        return search.getQuery().getLabel() + " - " + search.getResults().size() + " matches" + this.getCandidatesLabel(search);
    }

    protected String getCandidatesLabel(UIModelSearchResult search) {
        Object candidateStr = "";
        if (search.getQuery() instanceof IModelSearchEngine.ModelSearchQuery) {
            List candidates = ((IModelSearchEngine.ModelSearchQuery)search.getQuery()).getCandidates();
            if (!candidates.isEmpty()) {
                Iterable candidateNames = IterableExtensions.map((Iterable)candidates, r -> r.getURI().lastSegment().toString());
                candidateStr = " in " + IterableExtensions.join((Iterable)candidateNames, (CharSequence)", ");
            } else {
                candidateStr = " (no search resources selected, please check advanced search settings)";
            }
        }
        return candidateStr;
    }

    public IPageSite getSite() {
        return this.pageSite;
    }

    public Object getUIState() {
        return null;
    }

    public ISearchResultViewPart getViewPart() {
        return this.viewPart;
    }

    public void notify(final ModelSearchResultEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                int action = event.getAction();
                if (action == 1) {
                    UIModelSearchResultPage.this.viewer.setInput(null);
                } else if (action == 2) {
                    UIModelSearchResultPage.this.viewer.expandAll();
                } else if (action == 3) {
                    ModelSearchResultEntry firstMatch = ((ModelSearchContentProvider)UIModelSearchResultPage.this.viewer.getContentProvider()).getFirstMatch();
                    UIModelSearchResultPage.this.viewer.expandToLevel((Object)firstMatch, -1);
                } else {
                    UIModelSearchResultPage.this.search.addResults(event.getSearchResult());
                    UIModelSearchResultPage.this.viewPart.updateLabel();
                    UIModelSearchResultPage.this.viewer.setInput((Object)event);
                    UIModelSearchResultPage.this.viewer.getTree().setItemCount(((ModelSearchContentProvider)UIModelSearchResultPage.this.viewer.getContentProvider()).getRootNodes().size());
                }
            }
        });
    }

    private void hookAction() {
        IToolBarManager mgr = this.getSite().getActionBars().getToolBarManager();
        mgr.add((IContributionItem)new Separator());
        CollapseAllAction collapse = new CollapseAllAction(this.viewer);
        mgr.add((IAction)collapse);
        ExpandAllAction expand = new ExpandAllAction(this.viewer);
        mgr.add((IAction)expand);
        this.getSite().getActionBars().getToolBarManager().update(true);
    }

    public void init(IPageSite site) throws PartInitException {
        this.pageSite = site;
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void setID(String ID) {
        this.id = ID;
    }

    public void setInput(ISearchResult search, Object uiState) {
        this.search = (UIModelSearchResult)search;
        this.viewer.getTree().clearAll(true);
        this.viewer.getTree().removeAll();
        if (this.search != null && !this.search.getResults().isEmpty()) {
            this.viewPart.updateLabel();
            ModelSearchResultEvent dummyEvent = new ModelSearchResultEvent(this.search.getResults());
            this.viewer.setInput((Object)dummyEvent);
            this.viewer.getTree().setItemCount(((ModelSearchContentProvider)this.viewer.getContentProvider()).getRootNodes().size());
        } else {
            this.viewer.setInput(null);
        }
        if (search != null) {
            ((UIModelSearchQuery)search.getQuery()).getEngine().addListener((IModelSearchResultListener)this);
        }
    }

    public void setViewPart(ISearchResultViewPart part) {
        this.viewPart = part;
    }

    public static class CollapseAllAction
    extends Action {
        private TreeViewer fViewer;

        public CollapseAllAction(TreeViewer viewer) {
            super("Collapse all");
            this.fViewer = viewer;
            this.setToolTipText("Collapse all");
            this.setImageDescriptor(SearchImages.COLLAPSE_ALL.imageDescriptor());
        }

        public void run() {
            if (this.fViewer != null) {
                this.fViewer.collapseAll();
            }
        }
    }

    public static class ExpandAllAction
    extends Action {
        private TreeViewer fViewer;

        public ExpandAllAction(TreeViewer viewer) {
            super("Expand all");
            this.fViewer = viewer;
            this.setToolTipText("Expand all");
            this.setImageDescriptor(SearchImages.EXPAND_ALL.imageDescriptor());
        }

        public void run() {
            if (this.fViewer != null) {
                this.fViewer.getTree().setRedraw(false);
                this.fViewer.expandAll();
                this.fViewer.getTree().setRedraw(true);
            }
        }
    }
}

