/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.search.core;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.ImplementedBy;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.yakindu.sct.search.core.IModelSearchResultListener;
import com.yakindu.sct.search.core.ModelSearchResultEntry;
import com.yakindu.sct.search.core.ModelSearchResultEvent;
import com.yakindu.sct.search.core.filter.ModelFilter;
import com.yakindu.sct.search.core.filter.NoFilter;
import com.yakindu.sct.search.core.impl.DefaultModelSearchEngine;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.resource.Resource;

@ImplementedBy(value=DefaultModelSearchEngine.class)
public interface IModelSearchEngine {
    public void addListener(IModelSearchResultListener var1);

    public void removeListener(IModelSearchResultListener var1);

    public List<ModelSearchResultEntry> findResults(ModelSearchQuery var1) throws Exception;

    public void notifyListeners(List<ModelSearchResultEntry> var1);

    public void notifyListeners(ModelSearchResultEvent var1);

    public static class ModelSearchQuery {
        private List<Resource> candidates;
        private ModelFilter filterFunction;
        private IModelSearchEngine engine;

        public ModelSearchQuery(List<Resource> candidates) {
            Injector injector = Guice.createInjector((Module[])new Module[0]);
            this.engine = (IModelSearchEngine)injector.getInstance(IModelSearchEngine.class);
            this.candidates = candidates;
            this.filterFunction = new NoFilter();
        }

        public ModelSearchQuery(Resource candidate) {
            this(Lists.newArrayList((Object[])new Resource[]{candidate}));
        }

        public List<Resource> getCandidates() {
            return this.candidates;
        }

        public IModelSearchEngine getEngine() {
            return this.engine;
        }

        public ModelFilter getFilterFunction() {
            return this.filterFunction;
        }

        public void setCandidates(List<Resource> candidates) {
            this.candidates = candidates;
        }

        public void setFilterFunction(ModelFilter filterFunction) {
            Assert.isNotNull((Object)filterFunction);
            this.filterFunction = filterFunction;
        }
    }
}

