/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.search.core.filter;

import com.yakindu.sct.search.core.Marker;
import com.yakindu.sct.search.core.SearchEntry;
import com.yakindu.sct.search.core.filter.ModelFilter;
import com.yakindu.sct.search.core.filter.PatternBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class FeatureRegexFilter
extends ModelFilter {
    private Pattern pattern;
    private boolean shouldMatchBeginning = false;

    public FeatureRegexFilter(Pattern pattern) {
        this.pattern = pattern;
    }

    public FeatureRegexFilter(String text) {
        this.pattern = new PatternBuilder(text, true, false).getPattern();
    }

    public FeatureRegexFilter(String text, boolean isCaseSensitive, boolean isRegexFilter) {
        this.pattern = new PatternBuilder(text, isCaseSensitive, isRegexFilter).getPattern();
    }

    @Override
    public List<SearchEntry> apply(EObject initValue, Object input) {
        Object feature;
        EObject object;
        ArrayList<SearchEntry> returnList = new ArrayList<SearchEntry>();
        boolean isSearchEntry = input instanceof SearchEntry;
        EObject eObject = object = isSearchEntry ? ((SearchEntry)input).getReference() : (EObject)input;
        if (object instanceof EAttribute && (feature = initValue.eGet((EStructuralFeature)((EAttribute)object))) instanceof String && feature != null) {
            Matcher matcher = this.pattern.matcher((String)feature);
            boolean shouldForward = false;
            SearchEntry searchEntry = new SearchEntry(object);
            while (matcher.find()) {
                if (matcher.start() == matcher.end()) continue;
                if (this.shouldMatchBeginning && matcher.start() != 0) break;
                if (!shouldForward) {
                    shouldForward = true;
                }
                Marker marker = new Marker(matcher.start(), matcher.end());
                searchEntry.getMarker().add(marker);
            }
            if (shouldForward) {
                returnList.addAll(this.notifyChildren(initValue, searchEntry));
            }
        }
        return returnList;
    }

    public void setShouldMatchBeginning(boolean shouldMatchBeginning) {
        this.shouldMatchBeginning = shouldMatchBeginning;
    }
}

