/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.search.core.filter;

import java.util.regex.Pattern;

public class PatternBuilder {
    private Pattern pattern;
    private String patternText;
    private String sourceText;

    public PatternBuilder(String text) {
        this(text, true, false);
    }

    public PatternBuilder(String text, boolean isCaseSensitive, boolean isRegexFilter) {
        this.sourceText = text;
        this.patternText = !isRegexFilter ? NonRegexPatternHelper.generateRegexTextPattern(text) : text;
        this.pattern = isCaseSensitive ? Pattern.compile(this.patternText) : Pattern.compile(this.patternText, 2);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getPatternText() {
        return this.patternText;
    }

    public String getSourceText() {
        return this.sourceText;
    }

    public static class NonRegexPatternHelper {
        public static String generateRegexTextPattern(String text) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean escaping = false;
            int i = 0;
            while (i < text.length()) {
                char singleChar = text.charAt(i);
                switch (singleChar) {
                    case '!': 
                    case '$': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '[': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        if (escaping) {
                            stringBuffer.append("\\\\");
                        }
                        stringBuffer.append('\\');
                        stringBuffer.append(singleChar);
                        escaping = false;
                        break;
                    }
                    case '\\': {
                        if (escaping) {
                            stringBuffer.append("\\\\");
                        }
                        escaping = !escaping;
                        break;
                    }
                    case '*': {
                        if (escaping) {
                            stringBuffer.append('\\');
                            stringBuffer.append(singleChar);
                        } else {
                            stringBuffer.append(".*");
                        }
                        escaping = false;
                        break;
                    }
                    case '?': {
                        if (escaping) {
                            stringBuffer.append('\\');
                            stringBuffer.append(singleChar);
                        } else {
                            stringBuffer.append(".");
                        }
                        escaping = false;
                        break;
                    }
                    default: {
                        if (escaping) {
                            stringBuffer.append("\\\\");
                        }
                        stringBuffer.append(singleChar);
                        escaping = false;
                    }
                }
                ++i;
            }
            return stringBuffer.toString();
        }
    }
}

