/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.search.core.filter.sct;

import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.expressions.Literal;
import com.yakindu.sct.search.core.ModelElementNameProvider;
import com.yakindu.sct.search.core.filter.PatternBuilder;
import com.yakindu.sct.search.core.filter.sct.CrossReferenceFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;

public class CrossReferenceTextFilter
extends CrossReferenceFilter {
    private PatternBuilder[] patternBuilder;
    private ModelElementNameProvider names = new ModelElementNameProvider();
    private String elementText;
    private List<Resource> candidateResources;
    private boolean isCaseSensitive;
    private boolean isRegexFilter;

    public CrossReferenceTextFilter(String elementText, List<Resource> resources, boolean isCaseSensitive, boolean isRegexFilter) {
        this.elementText = elementText;
        this.candidateResources = resources;
        this.isCaseSensitive = isCaseSensitive;
        this.isRegexFilter = isRegexFilter;
        this.calculateTextReferences();
    }

    protected void calculateTextReferences() {
        String[] elementParts = this.elementText.split("/");
        this.patternBuilder = new PatternBuilder[elementParts.length];
        int i = 0;
        while (i < elementParts.length) {
            this.patternBuilder[i] = new PatternBuilder(elementParts[i], this.isCaseSensitive, this.isRegexFilter);
            ++i;
        }
        for (Resource resource : this.candidateResources) {
            EList contents = resource.getContents();
            for (EObject eObject : contents) {
                List objectsOfTypeNamedElement = EcoreUtil2.eAllOfType((EObject)eObject, NamedElement.class);
                List objectsOfLiteral = EcoreUtil2.eAllOfType((EObject)eObject, Literal.class);
                ArrayList objectsToCheck = new ArrayList();
                objectsToCheck.addAll(objectsOfTypeNamedElement);
                objectsToCheck.addAll(objectsOfLiteral);
                for (EObject object : objectsToCheck) {
                    if (!this.passCheck(object, elementParts.length, this.isCaseSensitive, this.isRegexFilter)) continue;
                    super.calculateReferences(object);
                }
            }
        }
    }

    private boolean passCheck(EObject object, int partsleft, boolean isCaseSensitive, boolean isRegexFilter) {
        String name = this.names.get(object);
        if (name == null) {
            return false;
        }
        return this.passCheck(object, partsleft, name, isCaseSensitive, isRegexFilter);
    }

    private boolean passCheck(EObject object, int partsleft, String text, boolean isCaseSensitive, boolean isRegexFilter) {
        int index = partsleft - 1;
        if (this.patternBuilder[index].getPattern().matcher(text).matches()) {
            return this.passContainerCheck(object, isCaseSensitive, isRegexFilter, index);
        }
        if (text.contains("/")) {
            return this.passNameWithDelimiterCheck(object, text, isCaseSensitive, isRegexFilter, index);
        }
        if (index == 0 && this.patternBuilder[index].getSourceText().contains(".")) {
            return this.passInterfaceCheck(object, text, isCaseSensitive);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean passContainerCheck(EObject object, boolean isCaseSensitive, boolean isRegexFilter, int index) {
        if (index == 0) {
            return true;
        }
        parent = object.eContainer();
        if (parent != null) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            if ((parent = parent.eContainer()) != null) continue;
            return false;
lbl8:
            // 2 sources

            ** while (!(parent instanceof NamedElement))
        }
lbl9:
        // 1 sources

        return this.passCheck(parent, index, isCaseSensitive, isRegexFilter);
    }

    private boolean passInterfaceCheck(EObject object, String text, boolean isCaseSensitive) {
        Pattern leftPattern;
        Pattern rightPattern;
        int patternLastIndexOfDot;
        int patternIndexOfDot = this.patternBuilder[0].getPatternText().indexOf("\\.");
        if (patternIndexOfDot != (patternLastIndexOfDot = this.patternBuilder[0].getPatternText().lastIndexOf("\\.")) || patternIndexOfDot == -1 || patternLastIndexOfDot == -1) {
            return false;
        }
        String rightPatternPart = this.patternBuilder[0].getPatternText().substring(patternIndexOfDot + 2, this.patternBuilder[0].getPatternText().length());
        String leftPatternPart = this.patternBuilder[0].getPatternText().substring(0, patternIndexOfDot);
        if (isCaseSensitive) {
            rightPattern = Pattern.compile(rightPatternPart);
            leftPattern = Pattern.compile(leftPatternPart);
        } else {
            rightPattern = Pattern.compile(rightPatternPart, 2);
            leftPattern = Pattern.compile(leftPatternPart, 2);
        }
        if (rightPattern.matcher(text).matches()) {
            EObject eContainer = object.eContainer();
            if (eContainer == null) {
                return false;
            }
            if (eContainer instanceof NamedElement) {
                String name = ((NamedElement)eContainer).getName();
                if (name == null) {
                    return false;
                }
                return leftPattern.matcher(name).matches();
            }
            return false;
        }
        return false;
    }

    private boolean passNameWithDelimiterCheck(EObject object, String text, boolean isCaseSensitive, boolean isRegexFilter, int index) {
        String[] textParts = text.split("/");
        if (textParts.length - 1 > index) {
            return false;
        }
        int tempIndex = index;
        int i = textParts.length - 1;
        while (i >= 0) {
            tempIndex = index - (textParts.length - 1 - i);
            if (!this.patternBuilder[tempIndex].getPattern().matcher(textParts[i]).matches()) {
                if (tempIndex == 0 && i == 0 && this.patternBuilder[tempIndex].getPatternText().contains("\\.")) {
                    return this.passInterfaceCheck(object, textParts[0], isCaseSensitive);
                }
                return false;
            }
            --i;
        }
        index = tempIndex;
        return this.passContainerCheck(object, isCaseSensitive, isRegexFilter, index);
    }

    @Override
    protected void doReset() {
        this.resources.clear();
        this.resourceToReferences.clear();
        this.referenceMap.clear();
        this.calculateTextReferences();
    }
}

