/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.search.core.impl;

import com.google.inject.Singleton;
import com.yakindu.sct.search.core.IModelSearchEngine;
import com.yakindu.sct.search.core.IModelSearchResultListener;
import com.yakindu.sct.search.core.ModelSearchResultEntry;
import com.yakindu.sct.search.core.ModelSearchResultEvent;
import com.yakindu.sct.search.core.SearchEntry;
import com.yakindu.sct.search.core.filter.ModelFilter;
import com.yakindu.sct.search.core.filter.TransformFunction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

@Singleton
public class DefaultModelSearchEngine
implements IModelSearchEngine {
    private Set<IModelSearchResultListener> listeners = new HashSet<IModelSearchResultListener>();

    @Override
    public void addListener(IModelSearchResultListener l) {
        this.listeners.add(l);
    }

    @Override
    public List<ModelSearchResultEntry> findResults(IModelSearchEngine.ModelSearchQuery query) throws Exception {
        Assert.isNotNull((Object)query);
        ArrayList<ModelSearchResultEntry> matches = new ArrayList<ModelSearchResultEntry>();
        List<Resource> candiates = query.getCandidates();
        ModelFilter filterFunction = query.getFilterFunction();
        for (Resource resource : candiates) {
            matches.addAll(this.findResults(resource, filterFunction));
        }
        return matches;
    }

    protected List<ModelSearchResultEntry> findResults(Resource resource, ModelFilter filter) {
        ArrayList<ModelSearchResultEntry> matches = new ArrayList<ModelSearchResultEntry>();
        TreeIterator contents = resource.getAllContents();
        while (contents.hasNext()) {
            EObject content = (EObject)contents.next();
            List<SearchEntry> results = filter.apply(content);
            TransformFunction transform = new TransformFunction(content);
            List<ModelSearchResultEntry> apply = transform.apply(results);
            matches.addAll(apply);
        }
        if (matches.size() > 0) {
            this.notifyListeners(matches);
        }
        return matches;
    }

    @Override
    public void notifyListeners(List<ModelSearchResultEntry> matches) {
        ModelSearchResultEvent event = new ModelSearchResultEvent(matches);
        for (IModelSearchResultListener listener : this.listeners) {
            listener.notify(event);
        }
    }

    @Override
    public void notifyListeners(ModelSearchResultEvent ev) {
        for (IModelSearchResultListener listener : this.listeners) {
            listener.notify(ev);
        }
    }

    @Override
    public void removeListener(IModelSearchResultListener l) {
        this.listeners.remove(l);
    }
}

