/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.java;

import com.google.inject.Inject;
import com.yakindu.sct.generator.core.IExecutionFlowGenerator;
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess;
import com.yakindu.sct.generator.java.GeneratorPredicate;
import com.yakindu.sct.generator.java.GenmodelEntries;
import com.yakindu.sct.generator.java.files.ICycleBased;
import com.yakindu.sct.generator.java.files.IEventDriven;
import com.yakindu.sct.generator.java.files.IStatemachine;
import com.yakindu.sct.generator.java.files.ITimed;
import com.yakindu.sct.generator.java.files.ITimerService;
import com.yakindu.sct.generator.java.files.ITracingListener;
import com.yakindu.sct.generator.java.files.Observable;
import com.yakindu.sct.generator.java.files.Observer;
import com.yakindu.sct.generator.java.files.RuntimeService;
import com.yakindu.sct.generator.java.files.Statemachine;
import com.yakindu.sct.generator.java.files.TimerService;
import com.yakindu.sct.generator.java.files.TraceEvent;
import com.yakindu.sct.generator.java.files.TraceEventType;
import com.yakindu.sct.generator.java.files.VirtualTimer;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions;
import com.yakindu.sct.model.sexec.naming.INamingService;
import com.yakindu.sct.model.sexec.transformation.config.IFlowConfiguration;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class JavaGenerator
implements IExecutionFlowGenerator {
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private GeneratorPredicate _generatorPredicate;
    @Inject
    @Extension
    private ShadowEventExtensions _shadowEventExtensions;
    @Inject
    @Extension
    private SExecExtensions _sExecExtensions;
    @Inject
    @Extension
    private IStatemachine _iStatemachine;
    @Inject
    @Extension
    private ICycleBased _iCycleBased;
    @Inject
    @Extension
    private IEventDriven _iEventDriven;
    @Inject
    @Extension
    private ITimed _iTimed;
    @Inject
    @Extension
    private ITimerService _iTimerService;
    @Inject
    @Extension
    private TimerService _timerService;
    @Inject
    @Extension
    private VirtualTimer _virtualTimer;
    @Inject
    @Extension
    private ITracingListener _iTracingListener;
    @Inject
    @Extension
    private TraceEvent _traceEvent;
    @Inject
    @Extension
    private TraceEventType _traceEventType;
    @Inject
    @Extension
    private RuntimeService _runtimeService;
    @Inject
    @Extension
    private Statemachine _statemachine;
    @Inject
    @Extension
    private Observer _observer;
    @Inject
    @Extension
    private Observable _observable;
    @Inject
    @Extension
    private IFlowConfiguration _iFlowConfiguration;
    @Inject
    private INamingService namingService;

    public void generate(ExecutionFlow flow, GeneratorEntry entry, ISCTFileSystemAccess fsa) {
        boolean _tracingGeneric;
        boolean _createRuntimeService;
        this.namingService.initializeNamingService(flow);
        this._iStatemachine.generateIStatemachine(flow, entry, (IFileSystemAccess)fsa);
        boolean _isCycleBased = this._iFlowConfiguration.isCycleBased();
        if (_isCycleBased) {
            this._iCycleBased.generateICycleBased(flow, entry, (IFileSystemAccess)fsa);
        } else {
            this._iEventDriven.generateIEventDriven(flow, entry, (IFileSystemAccess)fsa);
        }
        if (this._sExecExtensions.isTimed(flow) || this._genmodelEntries.createTimerService(entry) || this._genmodelEntries.createVirtualTimerService(entry)) {
            this._iTimed.generateITimed(flow, entry, (IFileSystemAccess)fsa);
            this._iTimerService.generateITimerService(flow, entry, (IFileSystemAccess)fsa);
            this._virtualTimer.generateVirtualTimerService(flow, entry, (IFileSystemAccess)fsa);
            boolean _createTimerService = this._genmodelEntries.createTimerService(entry);
            if (_createTimerService) {
                this._timerService.generateTimerService(flow, entry, (IFileSystemAccess)fsa);
            } else {
                boolean _createVirtualTimerService = this._genmodelEntries.createVirtualTimerService(entry);
                if (_createVirtualTimerService) {
                    this._virtualTimer.generateVirtualTimerService(flow, entry, (IFileSystemAccess)fsa);
                }
            }
        }
        if (_createRuntimeService = this._genmodelEntries.createRuntimeService(entry)) {
            this._runtimeService.generateRuntimeService(flow, entry, (IFileSystemAccess)fsa);
        }
        this._statemachine.generateStatemachine(flow, entry, (IFileSystemAccess)fsa);
        boolean _tracingUsed = this._genmodelEntries.tracingUsed(entry);
        if (_tracingUsed) {
            this._iTracingListener.generateTracingListener(flow, entry, (IFileSystemAccess)fsa);
        }
        if (_tracingGeneric = this._genmodelEntries.tracingGeneric(entry)) {
            this._traceEvent.generateTraceEvent(flow, entry, (IFileSystemAccess)fsa);
            this._traceEventType.generateTraceEventType(flow, entry, (IFileSystemAccess)fsa);
        }
        if (this._generatorPredicate.useOutEventObservables() && this._sExecExtensions.hasOutgoingEvents(flow) || !IterableExtensions.isNullOrEmpty((Iterable)this._shadowEventExtensions.getShadowEvents(flow)) || this._genmodelEntries.tracingGeneric(entry)) {
            this._observable.generateObservable(flow, entry, (IFileSystemAccess)fsa);
            this._observer.generateObserver(flow, entry, (IFileSystemAccess)fsa);
        }
    }
}

