/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.java.files;

import com.google.inject.Inject;
import com.yakindu.sct.generator.core.extensions.StringHelper;
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.generator.java.GenmodelEntries;
import com.yakindu.sct.generator.java.Naming;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ITimerService {
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private OutputConfigProvider _outputConfigProvider;
    @Inject
    @Extension
    private ICoreLibraryHelper _iCoreLibraryHelper;
    @Inject
    @Extension
    private StringHelper _stringHelper;

    public void generateITimerService(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
        boolean _skipLibraryFiles = this._iCoreLibraryHelper.getSkipLibraryFiles(entry);
        if (_skipLibraryFiles) {
            return;
        }
        String _path = this._stringHelper.toPath(this._genmodelEntries.getLibraryPackage(entry));
        String _plus = _path + "/";
        String _java = this._naming.java(this._naming.iTimerService());
        String fileName = _plus + _java;
        fsa.generateFile(fileName, this._outputConfigProvider.getLibraryOutputConfig(entry), this.content(entry));
    }

    public CharSequence content(GeneratorEntry entry) {
        return this.content(this._genmodelEntries.getLicenseText(entry), this._genmodelEntries.getLibraryPackage(entry));
    }

    public CharSequence content(String licenseText, String pkg) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(licenseText);
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)pkg);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("package ");
            _builder.append(pkg);
            _builder.append(";");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Defines methods to set and unset timers for a state machine's timed event triggers.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public interface ");
        String _iTimerService = this._naming.iTimerService();
        _builder.append(_iTimerService);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Starts the timing for a given time event id.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param callback\t\tan ");
        String _iTimed = this._naming.iTimed();
        _builder.append(_iTimed, "\t ");
        _builder.append(" object that is called when the timer expires");
        _builder.newLineIfNotEmpty();
        _builder.append("\t ");
        _builder.append("* @param eventID\t\tthe id of the state machine's time event");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param time\t\t\ttime in milliseconds after which the time event should be triggered");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param isPeriodic\tset to true to trigger the time event periodically");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setTimer(");
        String _iTimed_1 = this._naming.iTimed();
        _builder.append(_iTimed_1, "\t");
        _builder.append(" callback, int eventID, long time, boolean isPeriodic);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Unsets a time event.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param callback\tan ");
        String _iTimed_2 = this._naming.iTimed();
        _builder.append(_iTimed_2, "\t ");
        _builder.append(" object that is called when the timer expires");
        _builder.newLineIfNotEmpty();
        _builder.append("\t ");
        _builder.append("* @param eventID\tthe id of the state machine's time event");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void unsetTimer(");
        String _iTimed_3 = this._naming.iTimed();
        _builder.append(_iTimed_3, "\t");
        _builder.append(" callback, int eventID);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

