/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.java.files;

import com.google.inject.Inject;
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.generator.java.GenmodelEntries;
import com.yakindu.sct.generator.java.Naming;
import com.yakindu.sct.generator.java.features.OutEventObservables;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;

public class Observable {
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private OutEventObservables _outEventObservables;
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private OutputConfigProvider _outputConfigProvider;
    @Inject
    @Extension
    private ICoreLibraryHelper _iCoreLibraryHelper;

    public void generateObservable(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
        boolean _skipLibraryFiles = this._iCoreLibraryHelper.getSkipLibraryFiles(entry);
        if (_skipLibraryFiles) {
            return;
        }
        String _rxPackagePath = this._outEventObservables.rxPackagePath(entry);
        String _plus = _rxPackagePath + "/";
        String _java = this._naming.java(this._outEventObservables.observableClass());
        String fileName = _plus + _java;
        fsa.generateFile(fileName, this._outputConfigProvider.getLibraryOutputConfig(entry), this.content(entry));
    }

    private CharSequence content(GeneratorEntry it) {
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._genmodelEntries.getLicenseText(it);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        String _rxPackage = this._outEventObservables.rxPackage(it);
        _builder.append(_rxPackage);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.ArrayList;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class Observable<T> {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private List<Observer<T>> observers = new ArrayList<>();");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void next(T value) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for (Observer<T> observer : observers) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("observer.next(value);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean subscribe(Observer<T> observer) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return observer != null ? this.observers.add(observer) : false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean unsubscribe(Observer<T> observer) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return observer != null ? this.observers.remove(observer) : false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

