/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.java.files;

import com.google.inject.Inject;
import com.yakindu.sct.generator.core.extensions.StringHelper;
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.generator.java.GenmodelEntries;
import com.yakindu.sct.generator.java.Naming;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TraceEvent {
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private ICoreLibraryHelper _iCoreLibraryHelper;
    @Inject
    @Extension
    private OutputConfigProvider _outputConfigProvider;
    @Inject
    @Extension
    private StringHelper _stringHelper;

    public void generateTraceEvent(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
        boolean _skipLibraryFiles = this._iCoreLibraryHelper.getSkipLibraryFiles(entry);
        if (_skipLibraryFiles) {
            return;
        }
        String _path = this._stringHelper.toPath(this._genmodelEntries.getLibraryPackage(entry));
        String _plus = _path + "/";
        String _java = this._naming.java(this._naming.traceEventClass());
        String fileName = _plus + _java;
        fsa.generateFile(fileName, this._outputConfigProvider.getLibraryOutputConfig(entry), this.content(entry));
    }

    private CharSequence content(GeneratorEntry it) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._genmodelEntries.getLicenseText(it);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this._genmodelEntries.getLibraryPackage(it));
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("package ");
            String _libraryPackage = this._genmodelEntries.getLibraryPackage(it);
            _builder.append(_libraryPackage);
            _builder.append(";");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Instances represent state machine trace events. ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public class ");
        String _traceEventClass = this._naming.traceEventClass();
        _builder.append(_traceEventClass);
        _builder.append("<M extends ");
        String _iStatemachine = this._naming.iStatemachine();
        _builder.append(_iStatemachine);
        _builder.append(", S, F> {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected ");
        String _traceEventTypeEnum = this._naming.traceEventTypeEnum();
        _builder.append(_traceEventTypeEnum, "\t");
        _builder.append(" type;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected M machine;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected S state;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected F feature;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected Object value;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _traceEventClass_1 = this._naming.traceEventClass();
        _builder.append(_traceEventClass_1, "\t");
        _builder.append("(");
        String _traceEventTypeEnum_1 = this._naming.traceEventTypeEnum();
        _builder.append(_traceEventTypeEnum_1, "\t");
        _builder.append(" type, M machine) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("this(type, machine, null, null, null);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _traceEventClass_2 = this._naming.traceEventClass();
        _builder.append(_traceEventClass_2, "\t");
        _builder.append("(");
        String _traceEventTypeEnum_2 = this._naming.traceEventTypeEnum();
        _builder.append(_traceEventTypeEnum_2, "\t");
        _builder.append(" type, M machine, S state, F feature, Object value) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("this.type = type;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.machine = machine;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.state = state;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.feature = feature;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.value = value;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _traceEventTypeEnum_3 = this._naming.traceEventTypeEnum();
        _builder.append(_traceEventTypeEnum_3, "\t");
        _builder.append(" getType() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return type;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public M getMachine() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return machine;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public S getState() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return state;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public F getFeature() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return feature;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Object getValue() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return value;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

