/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.java.files;

import com.google.inject.Inject;
import com.yakindu.sct.generator.core.extensions.StringHelper;
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider;
import com.yakindu.sct.generator.java.GenmodelEntries;
import com.yakindu.sct.generator.java.Naming;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;

public class VirtualTimer {
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private StatechartAnnotations _statechartAnnotations;
    @Inject
    @Extension
    private StringHelper _stringHelper;
    @Inject
    @Extension
    private OutputConfigProvider _outputConfigProvider;
    private GeneratorEntry entry;
    private Statechart statechart;

    public void generateVirtualTimerService(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
        this.entry = entry;
        this.statechart = this._genmodelEntries.getStatechart(entry);
        String fileName = this.getFileName(entry);
        CharSequence content = this.toCode(entry);
        fsa.generateFile(fileName, this._outputConfigProvider.getLibraryOutputConfig(entry), content);
    }

    public void generateWithStatechart(Statechart st, GeneratorEntry entry, IFileSystemAccess fsa) {
        this.entry = entry;
        this.statechart = st;
        String fileName = this.getFileName(entry);
        CharSequence content = this.toCode(entry);
        fsa.generateFile(fileName, "LIBRARY_TARGET_FOLDER", content);
    }

    protected String getFileName(GeneratorEntry it) {
        StringConcatenation _builder = new StringConcatenation();
        String _path = this._stringHelper.toPath(this._genmodelEntries.getLibraryPackage(it));
        _builder.append(_path);
        _builder.append("/VirtualTimer.java");
        return _builder.toString();
    }

    protected CharSequence toCode(GeneratorEntry it) {
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._genmodelEntries.getLicenseText(this.entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        String _libraryPackage = this._genmodelEntries.getLibraryPackage(it);
        _builder.append(_libraryPackage);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.math.BigInteger;");
        _builder.newLine();
        _builder.append("import java.util.PriorityQueue;");
        _builder.newLine();
        _builder.append("import java.util.Queue;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class VirtualTimer implements ");
        String _iTimerService = this._naming.iTimerService();
        _builder.append(_iTimerService);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private BigInteger stopTime = BigInteger.ZERO;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected BigInteger currentTime = BigInteger.ZERO;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected long cyclePeriod = 0;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected BigInteger scheduleCount = BigInteger.ZERO;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private Queue<VirtualTimeTask> tasks;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public abstract static class VirtualTimeTask implements Runnable, Comparable<VirtualTimeTask> {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("BigInteger nextExecutionTime = BigInteger.ZERO;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("long interval = 0;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("long period = -1;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("BigInteger scheduleOrder = BigInteger.ZERO;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("boolean isCanceled = false;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public int compareTo(VirtualTimeTask o) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("BigInteger diff = BigInteger.ZERO;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (!nextExecutionTime.equals(o.nextExecutionTime)) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("diff = nextExecutionTime.subtract(o.nextExecutionTime);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} else if (o instanceof CycleTimeEventTask && !(this instanceof CycleTimeEventTask)) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return -1;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} else if (!(o instanceof CycleTimeEventTask) && this instanceof CycleTimeEventTask) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return 1;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("diff = scheduleOrder.subtract(o.scheduleOrder);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return diff.compareTo(BigInteger.ZERO);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public boolean isCanceled() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return isCanceled;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public void cancel() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("isCanceled = true;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public static class VirtualTimeEventTask extends VirtualTimeTask {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("private final int eventID;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("private ");
        String _iTimed = this._naming.iTimed();
        _builder.append(_iTimed, "\t\t");
        _builder.append(" callback;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public VirtualTimeEventTask(");
        String _iTimed_1 = this._naming.iTimed();
        _builder.append(_iTimed_1, "\t\t");
        _builder.append(" callback, int eventID) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("this.callback = callback;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("this.eventID = eventID;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public int getEventId() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return eventID;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public ");
        String _iTimed_2 = this._naming.iTimed();
        _builder.append(_iTimed_2, "\t\t");
        _builder.append(" getCallback() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("return callback;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public void run() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("callback.raiseTimeEvent(eventID);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public static class CycleTimeEventTask extends VirtualTimeTask {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("private ");
        boolean _isCycleBased = this._statechartAnnotations.isCycleBased(this.statechart);
        if (_isCycleBased) {
            String _iCycleBased = this._naming.iCycleBased();
            _builder.append(_iCycleBased, "\t\t");
        } else {
            String _iEventDriven = this._naming.iEventDriven();
            _builder.append(_iEventDriven, "\t\t");
        }
        _builder.append(" statemachine;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public CycleTimeEventTask(");
        boolean _isCycleBased_1 = this._statechartAnnotations.isCycleBased(this.statechart);
        if (_isCycleBased_1) {
            String _iCycleBased_1 = this._naming.iCycleBased();
            _builder.append(_iCycleBased_1, "\t\t");
        } else {
            String _iEventDriven_1 = this._naming.iEventDriven();
            _builder.append(_iEventDriven_1, "\t\t");
        }
        _builder.append(" statemachine) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("this.statemachine = statemachine;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public void run() {");
        _builder.newLine();
        boolean _isCycleBased_2 = this._statechartAnnotations.isCycleBased(this.statechart);
        if (_isCycleBased_2) {
            _builder.append("\t\t\t");
            _builder.append("statemachine.runCycle();");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public VirtualTimer() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tasks = new PriorityQueue<VirtualTimeTask>();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public VirtualTimer(long cyclePeriod) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tasks = new PriorityQueue<VirtualTimeTask>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.cyclePeriod = cyclePeriod;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void timeLeap(long ms) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stopTime = currentTime.add(BigInteger.valueOf(ms));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("processTasks();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void cycleLeap(long cycles){");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("int elapsedCycles = 0;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("while (elapsedCycles < cycles) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("VirtualTimeTask cycleTask = getCycleTask();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (cycleTask == null)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("long timeToNextCycle = cycleTask.nextExecutionTime.subtract(currentTime).longValue();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timeLeap(timeToNextCycle);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("elapsedCycles += 1;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setTimer(");
        String _iTimed_3 = this._naming.iTimed();
        _builder.append(_iTimed_3, "\t");
        _builder.append(" callback, int eventID, long duration, boolean isPeriodical) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if (duration <= 0)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("duration = 1;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("VirtualTimeEventTask timeEventTask = new VirtualTimeEventTask(callback, eventID);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (isPeriodical) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("schedulePeriodicalTask(timeEventTask, duration, duration);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("scheduleTask(timeEventTask, duration);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void unsetTimer(");
        String _iTimed_4 = this._naming.iTimed();
        _builder.append(_iTimed_4, "\t");
        _builder.append(" callback, int eventID) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("VirtualTimeTask timerTask = getTask(callback, eventID);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (timerTask != null)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timerTask.cancel();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void scheduleTask(VirtualTimeTask task, long interval) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("task.interval = interval;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("scheduleInternal(task, currentTime.add(BigInteger.valueOf(interval)), -1);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void schedulePeriodicalTask(VirtualTimeTask task, long interval, long period) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("scheduleInternal(task, currentTime.add(BigInteger.valueOf(interval)), period);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private void scheduleInternal(VirtualTimeTask task, BigInteger time, long period) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("task.nextExecutionTime = time;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("task.period = period;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("task.scheduleOrder = scheduleCount;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("scheduleCount = scheduleCount.add(BigInteger.ONE);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tasks.add(task);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected VirtualTimeTask getTask(");
        String _iTimed_5 = this._naming.iTimed();
        _builder.append(_iTimed_5, "\t");
        _builder.append(" callback, int eventName) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("for (VirtualTimeTask virtualTimeTask : tasks) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (!(virtualTimeTask instanceof VirtualTimeEventTask))");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("continue;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (((VirtualTimeEventTask) virtualTimeTask).getEventId() == eventName");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("&& ((VirtualTimeEventTask) virtualTimeTask).getCallback() == callback)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return virtualTimeTask;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected CycleTimeEventTask getCycleTask() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for (VirtualTimeTask task : tasks) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (task instanceof CycleTimeEventTask && !task.isCanceled()) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return (CycleTimeEventTask) task;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected void processTasks() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("boolean processTasks = !tasks.isEmpty();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("while (processTasks) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("VirtualTimeTask task = tasks.peek();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (task == null)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (task.isCanceled) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("tasks.remove();");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("continue;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (task.nextExecutionTime.compareTo(stopTime) <= 0) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("currentTime = task.nextExecutionTime;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("task = tasks.poll();");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("if (task.period > -1) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("task.nextExecutionTime = currentTime.add(BigInteger.valueOf(task.period));");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("tasks.add(task);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("task.run();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("currentTime = stopTime;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("processTasks = false;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public synchronized void stop() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for (VirtualTimeTask timerTask : tasks) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timerTask.cancel();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("cancel();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void cancel() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("synchronized (tasks) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("tasks.clear();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

