/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.extension.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.yakindu.base.base.BasePackage;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.DomainStatus;
import com.yakindu.sct.domain.extension.IDomain;
import com.yakindu.sct.domain.extension.IDomainDocumentationProvider;
import com.yakindu.sct.domain.extension.IDomainStatusProvider;
import com.yakindu.sct.domain.extension.impl.LazyCombiningModule;
import com.yakindu.sct.domain.extension.impl.ModuleContribution;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;

public class DomainImpl
implements IDomain {
    private String domainID;
    private String name;
    private String description;
    private URL imagePath;
    private IDomainStatusProvider statusProvider;
    private IDomainDocumentationProvider documentationProvider;
    private Iterable<ModuleContribution> modules;
    private LoadingCache<CacheKey, Injector> injectorCache;

    public DomainImpl(String domainID, String name, String description, URL imagePath, Iterable<ModuleContribution> modules) {
        this(domainID, name, description, imagePath, modules, new IDomainStatusProvider.DefaultDomainStatusProvider(), new IDomainDocumentationProvider.NullImpl());
    }

    public DomainImpl(String domainID, String name, String description, URL imagePath, Iterable<ModuleContribution> modules, IDomainStatusProvider provider, IDomainDocumentationProvider docuProvider) {
        this.domainID = domainID;
        this.name = name;
        this.description = description;
        this.imagePath = imagePath;
        this.modules = modules;
        this.statusProvider = provider;
        this.documentationProvider = docuProvider;
        this.initializeCache();
    }

    protected void initializeCache() {
        this.injectorCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, Injector>(){

            public Injector load(CacheKey key) throws Exception {
                return DomainImpl.this.createInjector(key.getFeature(), key.getOptions());
            }
        });
    }

    @Override
    public String getDomainID() {
        return this.domainID;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public URL getImagePath() {
        return this.imagePath;
    }

    @Override
    public Injector getInjector(String feature, boolean useCache, String ... options) {
        if (useCache) {
            try {
                return (Injector)this.injectorCache.get((Object)new CacheKey(feature, options));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return this.createInjector(feature, options);
    }

    @Override
    public Injector getInjector(String feature, String ... options) {
        return this.getInjector(feature, true, options);
    }

    public Injector createInjector(String feature, String ... options) {
        return Guice.createInjector((Module[])new Module[]{this.getModule(feature, options)});
    }

    @Override
    public Module getModule(String feature, String ... options) {
        IDomain domain;
        ArrayList<Module> modules = new ArrayList<Module>();
        for (ModuleContribution module : this.modules) {
            if (!feature.equals(module.getFeature()) && !"all".equals(module.getFeature())) continue;
            modules.add(module.getModuleProvider().getModule(options));
        }
        if (modules.size() == 0 && !"com.yakindu.sct.generator".equals(feature) && (domain = DomainRegistry.getDomain(BasePackage.Literals.DOMAIN_ELEMENT__DOMAIN_ID.getDefaultValueLiteral())) != null) {
            return domain.getModule(feature, options);
        }
        LazyCombiningModule result = new LazyCombiningModule(modules);
        return result;
    }

    @Override
    public DomainStatus getAvailabilityStatus() {
        return this.statusProvider.getDomainStatus();
    }

    @Override
    public IDomainDocumentationProvider getDocumentationProvider() {
        return this.documentationProvider;
    }

    protected static class CacheKey {
        private String feature;
        private String[] options;

        public CacheKey(String feature, String[] options) {
            this.feature = feature;
            this.options = options;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.feature == null ? 0 : this.feature.hashCode());
            result = 31 * result + Arrays.hashCode(this.options);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.feature == null ? other.feature != null : !this.feature.equals(other.feature)) {
                return false;
            }
            return Arrays.equals(this.options, other.options);
        }

        public String getFeature() {
            return this.feature;
        }

        public String[] getOptions() {
            return this.options;
        }
    }
}

