/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.refactoring.refactor.impl;

import com.yakindu.base.expressions.expressions.ExpressionsFactory;
import com.yakindu.base.expressions.expressions.ReactionEffect;
import com.yakindu.base.expressions.expressions.ReactionTrigger;
import com.yakindu.base.types.Effect;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Trigger;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.stext.stext.ExitEvent;
import com.yakindu.sct.model.stext.stext.LocalReaction;
import com.yakindu.sct.model.stext.stext.StextFactory;
import com.yakindu.sct.refactoring.refactor.AbstractRefactoring;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class FoldOutgoingActionsRefactoring
extends AbstractRefactoring<State> {
    @Override
    protected void internalExecute() {
        EList outgoingTransitions = ((State)this.getContextObject()).getOutgoingTransitions();
        List<Expression> actionsToFold = this.getFoldableActions((EList<Transition>)outgoingTransitions);
        this.addActionsToExitReaction(actionsToFold);
    }

    @Override
    public boolean isExecutable() {
        return super.isExecutable() && this.atLeastOneFoldableAction() && this.noOutgoingTransitionLeavesCompositeWithExitActions();
    }

    private boolean noOutgoingTransitionLeavesCompositeWithExitActions() {
        return !this.helper.oneOutgoingTransitionLeavesCompositeWithExitActions((State)this.getContextObject());
    }

    private boolean atLeastOneFoldableAction() {
        EList transitions = ((State)this.getContextObject()).getOutgoingTransitions();
        return this.getFirstFoldableAction(this.helper.getAllActions((List<Transition>)transitions), 0) != null;
    }

    private List<Expression> getFoldableActions(EList<Transition> transitions) {
        Expression firstFoldableAction;
        ArrayList<Expression> foldableActions = new ArrayList<Expression>();
        int index = 0;
        while ((firstFoldableAction = this.getFirstFoldableAction(this.helper.getAllActions((List<Transition>)transitions), index)) != null) {
            foldableActions.add(firstFoldableAction);
            ++index;
        }
        this.removeFirstActions(transitions, index);
        return foldableActions;
    }

    private void addActionsToExitReaction(List<Expression> actionsToAdd) {
        if (actionsToAdd.isEmpty()) {
            return;
        }
        EList<Expression> actionsOriginal = this.helper.getFirstExitActions((State)this.getContextObject());
        if (actionsOriginal == null) {
            actionsOriginal = this.createExitBlock(actionsToAdd);
        } else {
            actionsOriginal.addAll(actionsToAdd);
        }
    }

    private EList<Expression> createExitBlock(List<Expression> actionsToAdd) {
        LocalReaction newLocalReaction = StextFactory.eINSTANCE.createLocalReaction();
        ReactionTrigger newReactionTrigger = ExpressionsFactory.eINSTANCE.createReactionTrigger();
        ExitEvent exitEvent = StextFactory.eINSTANCE.createExitEvent();
        ReactionEffect newReactionEffect = ExpressionsFactory.eINSTANCE.createReactionEffect();
        newLocalReaction.setTrigger((Trigger)newReactionTrigger);
        newReactionTrigger.getTriggers().add((Object)exitEvent);
        newReactionEffect.getActions().addAll(actionsToAdd);
        newLocalReaction.setEffect((Effect)newReactionEffect);
        Scope scope = (Scope)((State)this.getContextObject()).getScopes().get(0);
        scope.getReactions().add((Object)newLocalReaction);
        EList actionsOriginal = newReactionEffect.getActions();
        return actionsOriginal;
    }

    private void removeFirstActions(EList<Transition> transitions, int number) {
        for (Transition transition : transitions) {
            List<Expression> actionsToRemove = this.getFirstActions(transition, number);
            Effect effect = transition.getEffect();
            if (effect instanceof ReactionEffect && actionsToRemove.size() == ((ReactionEffect)effect).getActions().size()) {
                EcoreUtil.delete((EObject)effect, (boolean)true);
                continue;
            }
            for (Expression action : actionsToRemove) {
                EcoreUtil.delete((EObject)action);
            }
        }
    }

    private List<Expression> getFirstActions(Transition transition, int number) {
        ArrayList<Expression> firstActions = new ArrayList<Expression>();
        Effect effect = transition.getEffect();
        if (effect instanceof ReactionEffect) {
            ReactionEffect reactionEffect = (ReactionEffect)effect;
            EList actions = reactionEffect.getActions();
            int i = 0;
            while (i < number) {
                firstActions.add((Expression)actions.get(i));
                ++i;
            }
        }
        return firstActions;
    }

    private Expression getFirstFoldableAction(List<List<Expression>> allActions, int index) {
        Expression actionToCheck = null;
        for (List<Expression> actionList : allActions) {
            if (index >= actionList.size()) {
                return null;
            }
            Expression firstAction = actionList.get(index);
            if (actionToCheck == null) {
                actionToCheck = firstAction;
                continue;
            }
            if (EcoreUtil.equals((EObject)actionToCheck, (EObject)firstAction)) continue;
            return null;
        }
        return actionToCheck;
    }

    @Override
    protected String getCommandLabel() {
        return "Fold Outgoing Actions";
    }
}

