/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.refactoring.refactor.impl;

import com.yakindu.base.expressions.expressions.ExpressionsFactory;
import com.yakindu.base.expressions.expressions.ReactionEffect;
import com.yakindu.base.types.Effect;
import com.yakindu.base.types.Expression;
import com.yakindu.sct.model.sgraph.Reaction;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.stext.stext.EntryEvent;
import com.yakindu.sct.refactoring.refactor.AbstractRefactoring;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class UnfoldEntryActionsRefactoring
extends AbstractRefactoring<State> {
    @Override
    protected void internalExecute() {
        this.unfoldEntryActions();
    }

    @Override
    public boolean isExecutable() {
        return super.isExecutable() && this.hasAtLeastOneEntryAction() && this.hasAtLeastOneIncomingTransition() && this.noIncomingTransitionEntersCompositeWithEntryActions();
    }

    private boolean noIncomingTransitionEntersCompositeWithEntryActions() {
        return !this.helper.oneIncomingTransitionEntersCompositeWithEntryActions((State)this.getContextObject());
    }

    private boolean hasAtLeastOneEntryAction() {
        return this.helper.hasEntryAction((State)this.getContextObject());
    }

    private boolean hasAtLeastOneIncomingTransition() {
        return !((State)this.getContextObject()).getIncomingTransitions().isEmpty();
    }

    private void unfoldEntryActions() {
        ArrayList<Expression> actionsToUnfold = new ArrayList<Expression>(this.helper.extractAllLocalActionsForEventType((State)this.getContextObject(), EntryEvent.class));
        this.addActionsToIncomingTransitions(actionsToUnfold);
        this.helper.removeReactionsOfEventType((EList<Reaction>)((State)this.getContextObject()).getLocalReactions(), EntryEvent.class);
    }

    private void addActionsToIncomingTransitions(List<Expression> actionsToAdd) {
        for (Transition transition : ((State)this.getContextObject()).getIncomingTransitions()) {
            this.addActionsToTransition(transition, EcoreUtil.copyAll(actionsToAdd));
        }
    }

    private void addActionsToTransition(Transition transition, Collection<Expression> actionsToAdd) {
        Effect effect = transition.getEffect();
        if (effect instanceof ReactionEffect) {
            ReactionEffect reactionEffect = (ReactionEffect)effect;
            reactionEffect.getActions().addAll(actionsToAdd);
        } else {
            ReactionEffect reactionEffect = ExpressionsFactory.eINSTANCE.createReactionEffect();
            reactionEffect.getActions().addAll(actionsToAdd);
            transition.setEffect((Effect)reactionEffect);
        }
    }

    @Override
    protected String getCommandLabel() {
        return "Unfold Entry Actions";
    }
}

