/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.refactoring.refactor.impl;

import com.yakindu.base.expressions.expressions.ExpressionsFactory;
import com.yakindu.base.expressions.expressions.ReactionEffect;
import com.yakindu.base.types.Effect;
import com.yakindu.base.types.Expression;
import com.yakindu.sct.model.sgraph.Reaction;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.stext.stext.ExitEvent;
import com.yakindu.sct.refactoring.refactor.AbstractRefactoring;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class UnfoldExitActionsRefactoring
extends AbstractRefactoring<State> {
    @Override
    protected void internalExecute() {
        this.unfoldExitActions();
    }

    @Override
    public boolean isExecutable() {
        return super.isExecutable() && this.hasAtLeastOneExitAction() && this.hasAtLeastOneOutgoingTransition() && this.noOutgoingTransitionLeavesCompositeWithExitActions();
    }

    private boolean hasAtLeastOneExitAction() {
        return this.helper.hasExitAction((State)this.getContextObject());
    }

    private boolean noOutgoingTransitionLeavesCompositeWithExitActions() {
        return !this.helper.oneOutgoingTransitionLeavesCompositeWithExitActions((State)this.getContextObject());
    }

    private boolean hasAtLeastOneOutgoingTransition() {
        return !((State)this.getContextObject()).getOutgoingTransitions().isEmpty();
    }

    private void unfoldExitActions() {
        ArrayList<Expression> actionsToUnfold = new ArrayList<Expression>(this.helper.extractAllLocalActionsForEventType((State)this.getContextObject(), ExitEvent.class));
        this.addActionsToOutgoingTransitions(actionsToUnfold);
        this.helper.removeReactionsOfEventType((EList<Reaction>)((State)this.getContextObject()).getLocalReactions(), ExitEvent.class);
    }

    private void addActionsToOutgoingTransitions(List<Expression> actionsToAdd) {
        for (Transition transition : ((State)this.getContextObject()).getOutgoingTransitions()) {
            this.addActionsToTransition(transition, EcoreUtil.copyAll(actionsToAdd));
        }
    }

    private void addActionsToTransition(Transition transition, Collection<Expression> actionsToAdd) {
        Effect effect = transition.getEffect();
        if (effect instanceof ReactionEffect) {
            ReactionEffect reactionEffect = (ReactionEffect)effect;
            reactionEffect.getActions().addAll(0, actionsToAdd);
        } else {
            ReactionEffect reactionEffect = ExpressionsFactory.eINSTANCE.createReactionEffect();
            reactionEffect.getActions().addAll(actionsToAdd);
            transition.setEffect((Effect)reactionEffect);
        }
    }

    @Override
    protected String getCommandLabel() {
        return "Unfold Exit Actions";
    }
}

