/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.simulation.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.PerspectiveManager;
import org.eclipse.debug.internal.ui.viewers.AsynchronousSchedulingRuleFactory;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.UIJob;

public class TestingPerspectiveManager
extends PerspectiveManager
implements ILaunchListener {
    private static final String LAUNCH_TYPE = "com.yakindu.sctunit.simulation.core.launch";
    public static final String TESTING_PERSPECTIVE = "com.yakindu.sct.ui.TestingPerspective";

    public void launchAdded(ILaunch launch) {
        try {
            ILaunchConfigurationType type = launch.getLaunchConfiguration().getType();
            if (type.getIdentifier().equals(LAUNCH_TYPE)) {
                this.schedulePerspectiveSwitchJob(TESTING_PERSPECTIVE);
            }
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
    }

    protected void schedulePerspectiveSwitchJob(final String perspectiveID) {
        UIJob switchJob = new UIJob(DebugUIPlugin.getStandardDisplay(), "Perspective Switch Job"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
                if (window != null && !TestingPerspectiveManager.this.isCurrentPerspective(window, perspectiveID)) {
                    TestingPerspectiveManager.this.switchToPerspective(window, perspectiveID);
                }
                return Status.OK_STATUS;
            }
        };
        switchJob.setSystem(true);
        switchJob.setPriority(10);
        switchJob.setRule(AsynchronousSchedulingRuleFactory.getDefault().newSerialPerObjectRule((Object)this));
        switchJob.schedule();
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
    }
}

