/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.simulation.ui.console;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.yakindu.base.expressions.interpreter.IExpressionInterpreter;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.simulation.core.debugmodel.SCTDebugTarget;
import com.yakindu.sctunit.sCTUnit.ExpressionStatement;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.diagnostics.Diagnostic;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.impl.Linker;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.ListBasedDiagnosticConsumer;

public class SCTUnitConsole
extends IOConsole
implements IDebugEventSetListener,
IDebugContextListener {
    @Inject
    private IExpressionInterpreter interpreter;
    @Inject
    private IParser parser;
    @Inject
    private Linker linker;
    @Inject
    private Provider<ResourceSet> setProvider;
    @Inject
    private Provider<XtextResource> resourceProvider;
    private IDebugTarget debugTarget;
    private ExpressionEvaluator expressionEvaluator;

    public SCTUnitConsole(String name, String consoleType, ImageDescriptor imageDescriptor) {
        super(name, consoleType, imageDescriptor);
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void activate() {
        super.activate();
        this.setActiveSession();
        this.startStreamListener();
    }

    protected void startStreamListener() {
        this.expressionEvaluator = new ExpressionEvaluator((InputStream)this.getInputStream(), this.newOutputStream(), this.newOutputStream());
        Thread t = new Thread(this.expressionEvaluator);
        t.start();
    }

    protected void setActiveSession() {
        IDebugTarget debugTarget;
        IAdaptable debugContext = DebugUITools.getDebugContext();
        if (debugContext != null && (debugTarget = (IDebugTarget)debugContext.getAdapter(IDebugTarget.class)) != null && !debugTarget.isTerminated()) {
            this.debugTarget = debugTarget;
            if (debugTarget != null) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.newOutputStream()));){
                        this.clearConsole();
                        writer.write("Connected to " + debugTarget.getName() + "\n");
                        writer.flush();
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent debugEvent = debugEventArray[n2];
            if (debugEvent.getSource() instanceof SCTDebugTarget && debugEvent.getSource() == this.debugTarget) {
                this.handleDebugEvent(debugEvent);
            }
            ++n2;
        }
    }

    protected void handleDebugEvent(DebugEvent debugEvent) {
        switch (debugEvent.getKind()) {
            case 8: {
                this.expressionEvaluator.cancel();
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            PlatformObject object = (PlatformObject)((IStructuredSelection)event.getContext()).getFirstElement();
            if (object == null) {
                return;
            }
            IDebugTarget newTarget = null;
            newTarget = object instanceof Launch ? ((Launch)object).getDebugTarget() : (IDebugTarget)object.getAdapter(IDebugTarget.class);
            if (newTarget != this.debugTarget && newTarget != null && !newTarget.isTerminated()) {
                this.debugTarget = newTarget;
                this.setActiveSession();
            }
        }
    }

    protected class ExpressionEvaluator
    implements Runnable {
        private BufferedReader reader;
        private BufferedWriter errWriter;
        private BufferedWriter resultWriter;

        public ExpressionEvaluator(InputStream in, IOConsoleOutputStream err, IOConsoleOutputStream result) {
            this.configureStreams(in, err, result);
        }

        private void configureStreams(InputStream in, IOConsoleOutputStream err, IOConsoleOutputStream result) {
            this.reader = new BufferedReader(new InputStreamReader(in));
            err.setColor(Display.getDefault().getSystemColor(3));
            this.errWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)err));
            result.setColor(Display.getDefault().getSystemColor(16));
            this.resultWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)result));
        }

        @Override
        public void run() {
            try {
                String line = this.reader.readLine();
                while (line != null) {
                    try {
                        this.handleExpression(line);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                    line = this.reader.readLine();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void cancel() {
            try {
                SCTUnitConsole.this.clearConsole();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void handleExpression(String expression) throws IOException {
            if (SCTUnitConsole.this.debugTarget == null) {
                this.errWriter.write("Error: Not connected to a debug session.\n");
                this.errWriter.flush();
                return;
            }
            if (expression == null || expression.trim().length() == 0) {
                return;
            }
            switch (expression) {
                case "help": {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp();
                    break;
                }
                case "clear": {
                    SCTUnitConsole.this.clearConsole();
                    break;
                }
                default: {
                    this.parseSCTUnitCommand(expression);
                }
            }
        }

        protected void parseSCTUnitCommand(String expression) throws IOException {
            Object evalResult;
            ParserRule parserRule = XtextFactory.eINSTANCE.createParserRule();
            parserRule.setName(ExpressionStatement.class.getSimpleName());
            IParseResult result = SCTUnitConsole.this.parser.parse(parserRule, (Reader)new StringReader(expression));
            if (result.getRootASTElement() == null) {
                return;
            }
            if (result.hasSyntaxErrors()) {
                this.errWriter.write("Syntax error: " + ((INode)result.getSyntaxErrors().iterator().next()).getSyntaxErrorMessage().getMessage() + "\n");
                this.errWriter.flush();
                return;
            }
            ResourceSet resourceSet = (ResourceSet)SCTUnitConsole.this.setProvider.get();
            Resource resource = (Resource)SCTUnitConsole.this.resourceProvider.get();
            resource.setURI(URI.createURI((String)"sctunit_console.sctunit"));
            resource.getContents().add((Object)result.getRootASTElement());
            resourceSet.getResources().add((Object)resource);
            resourceSet.getResources().add((Object)((EObject)SCTUnitConsole.this.debugTarget.getAdapter(EObject.class)).eResource());
            ListBasedDiagnosticConsumer diagnosticsConsumer = new ListBasedDiagnosticConsumer();
            SCTUnitConsole.this.linker.linkModel(result.getRootASTElement(), (IDiagnosticConsumer)diagnosticsConsumer);
            List errors = diagnosticsConsumer.getResult(Severity.ERROR);
            Iterator iterator = errors.iterator();
            if (iterator.hasNext()) {
                Diagnostic diagnostic = (Diagnostic)iterator.next();
                this.errWriter.write("Linking error: " + diagnostic.getMessage());
                this.errWriter.flush();
                return;
            }
            if (result.getRootASTElement() != null && !result.hasSyntaxErrors() && errors.isEmpty() && (evalResult = SCTUnitConsole.this.interpreter.evaluate(((ExpressionStatement)result.getRootASTElement()).getExpression(), (ExecutionContext)SCTUnitConsole.this.debugTarget.getAdapter(ExecutionContext.class))) != null) {
                this.resultWriter.write(">> " + String.valueOf(evalResult) + "\n");
                this.resultWriter.flush();
            }
        }
    }
}

