/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.license.lmx;

import com.yakindu.licmgmt.IEclipseLicenseManager;
import com.yakindu.licmgmt.IEclipseLicenseService;
import com.yakindu.licmgmt.LicenseException;
import com.yakindu.sct.license.ILicenseService;
import com.yakindu.sct.license.LicenseStatus;
import java.util.HashMap;
import java.util.Map;

public class LmxLicenseService
implements ILicenseService {
    private Map<String, Boolean> acquireStatus = new HashMap<String, Boolean>();

    public LicenseStatus getLicenseStatus(String licensedFeatureId, String licensedFeatureVersion) {
        try {
            IEclipseLicenseManager licenseManager = IEclipseLicenseService.INSTANCE.getLicenseManager(licensedFeatureId, licensedFeatureVersion);
            if (!licenseManager.isEnabled()) {
                return new LicenseStatus(LicenseStatus.Status.DISABLED);
            }
            if (!this.isAcquired(licensedFeatureId)) {
                licenseManager.acquire();
                this.acquireStatus.put(licensedFeatureId, true);
            }
            if (licenseManager.isCheckedOut()) {
                if (licenseManager.isTrial()) {
                    return new LicenseStatus(LicenseStatus.Status.TRIAL);
                }
                return LicenseStatus.VALID;
            }
            return new LicenseStatus(LicenseStatus.Status.NON_EXISTING, licenseManager.getStatusMessage());
        }
        catch (LicenseException e) {
            return new LicenseStatus(LicenseStatus.Status.NON_EXISTING, e.getMessage());
        }
    }

    protected boolean isAcquired(String licensedFeatureId) {
        return this.acquireStatus.getOrDefault(licensedFeatureId, false);
    }
}

