/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.cpp.extensions;

import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.TimeEventSpec;
import com.yakindu.base.types.Declaration;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions;
import com.yakindu.sctunit.generator.c.features.CSCTUnitGenmodelEntries;
import com.yakindu.sctunit.generator.cpp.CppSCTUnitGenerator;
import com.yakindu.sctunit.generator.cpp.extensions.CppMockingExtensions;
import com.yakindu.sctunit.generator.cpp.extensions.SCTUnitCppNaming;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitElement;
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite;
import com.yakindu.sctunit.sCTUnit.TestPackage;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class JUnitTest {
    @Inject
    @Extension
    private SCTUnitCppNaming _sCTUnitCppNaming;
    @Inject
    @Extension
    private BaseNavigationExtensions _baseNavigationExtensions;
    @Inject
    @Extension
    private CSCTUnitGenmodelEntries _cSCTUnitGenmodelEntries;
    @Inject
    @Extension
    private CppMockingExtensions _cppMockingExtensions;
    @Inject
    protected GeneratorEntry entry;
    @Inject
    protected ICoreLibraryHelper helper;

    public void generateJUnitTest(TestPackage it, IFileSystemAccess fsa, String targetProjectName, CppSCTUnitGenerator generator, GeneratorEntry entry) {
        String targetProjectString = this.helper.getTargetProjectValue(entry).getStringValue();
        StringConcatenation _builder = new StringConcatenation();
        String _java = this._sCTUnitCppNaming.java(this._sCTUnitCppNaming.testClassName(this._baseNavigationExtensions.getSCTUnitElement(it)));
        _builder.append(_java);
        String testFileName = _builder.toString();
        CharSequence content = this.generateTest(this._baseNavigationExtensions.getSCTUnitElement(it), targetProjectString);
        fsa.generateFile(testFileName, "C_JUnit_Output", content);
    }

    protected CharSequence _generateTest(SCTUnitClass it, String targetProjectString) {
        boolean _not_2;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._cSCTUnitGenmodelEntries.getLicenseText(this.entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        _builder.append(targetProjectString);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this._sCTUnitCppNaming.namespace((Declaration)this._baseNavigationExtensions.getTestPackage((SCTUnitElement)it)).toString());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append(".");
        }
        CharSequence _namespace = this._sCTUnitCppNaming.namespace((Declaration)it);
        _builder.append((Object)_namespace);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import org.junit.Before;");
        _builder.newLine();
        _builder.append("import org.junit.runner.RunWith;");
        _builder.newLine();
        _builder.append("import com.yakindu.sct.generator.c.gtest.GTest;");
        _builder.newLine();
        _builder.append("import com.yakindu.sct.generator.c.gtest.GTestRunner;");
        _builder.newLine();
        _builder.append("import com.yakindu.sct.generator.c.gtest.GTestHelper;");
        _builder.newLine();
        _builder.append("import com.yakindu.sct.generator.c.gtest.GTestHelper.Compiler;");
        _builder.newLine();
        boolean _isMockingRequired = this._cppMockingExtensions.isMockingRequired(it);
        if (_isMockingRequired) {
            _builder.append("import com.yakindu.sct.generator.c.gtest.GMockHelper;");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("@GTest(");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("statechartBundle = \"");
        String _segment = it.getStatechart().eResource().getURI().segment(1);
        _builder.append(_segment, "\t");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("sourceFile = \"");
        String _targetFolderString = this._cSCTUnitGenmodelEntries.getTargetFolderString(this.entry);
        _builder.append(_targetFolderString, "\t");
        _builder.append("/");
        String _cc = this._sCTUnitCppNaming.cc(this._sCTUnitCppNaming.testClassName((SCTUnitElement)it));
        _builder.append(_cc, "\t");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("program = \"");
        String _targetFolderString_1 = this._cSCTUnitGenmodelEntries.getTargetFolderString(this.entry);
        _builder.append(_targetFolderString_1, "\t");
        _builder.append("/");
        boolean _isEmpty = this._cSCTUnitGenmodelEntries.getIdentifierModuleName(this.entry).isEmpty();
        boolean bl2 = _not_1 = !_isEmpty;
        if (_not_1) {
            String _identifierModuleName = this._cSCTUnitGenmodelEntries.getIdentifierModuleName(this.entry);
            _builder.append(_identifierModuleName, "\t");
        } else {
            String _className = this._sCTUnitCppNaming.className((EObject)it.getStatechart());
            _builder.append(_className, "\t");
        }
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("model = \"");
        String _modelFromUri = this.getModelFromUri(it.getStatechart().eResource().getURI());
        _builder.append(_modelFromUri, "\t");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("additionalFilesToCopy = {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"");
        FeatureParameterValue _libraryTargetFeature = this._cSCTUnitGenmodelEntries.getLibraryTargetFeature(this.entry);
        boolean bl3 = _tripleEquals = _libraryTargetFeature == null;
        if (_tripleEquals) {
            String _targetFolderString_2 = this._cSCTUnitGenmodelEntries.getTargetFolderString(this.entry);
            _builder.append(_targetFolderString_2, "\t\t");
        } else {
            String _libraryTargetFolderString = this._cSCTUnitGenmodelEntries.getLibraryTargetFolderString(this.entry);
            _builder.append(_libraryTargetFolderString, "\t\t");
        }
        _builder.append("/");
        String _timerServiceFileName = this._sCTUnitCppNaming.timerServiceFileName(it);
        _builder.append(_timerServiceFileName, "\t\t");
        _builder.append(".h\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\"");
        FeatureParameterValue _libraryTargetFeature_1 = this._cSCTUnitGenmodelEntries.getLibraryTargetFeature(this.entry);
        boolean bl4 = _tripleEquals_1 = _libraryTargetFeature_1 == null;
        if (_tripleEquals_1) {
            String _targetFolderString_3 = this._cSCTUnitGenmodelEntries.getTargetFolderString(this.entry);
            _builder.append(_targetFolderString_3, "\t\t");
        } else {
            String _libraryTargetFolderString_1 = this._cSCTUnitGenmodelEntries.getLibraryTargetFolderString(this.entry);
            _builder.append(_libraryTargetFolderString_1, "\t\t");
        }
        _builder.append("/");
        String _timerServiceFileName_1 = this._sCTUnitCppNaming.timerServiceFileName(it);
        _builder.append(_timerServiceFileName_1, "\t\t");
        _builder.append(".cpp\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("},");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("additionalFilesToCompile = {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"");
        boolean _isEmpty_1 = this._cSCTUnitGenmodelEntries.getIdentifierModuleName(this.entry).isEmpty();
        boolean bl5 = _not_2 = !_isEmpty_1;
        if (_not_2) {
            String _identifierModuleName_1 = this._cSCTUnitGenmodelEntries.getIdentifierModuleName(this.entry);
            _builder.append(_identifierModuleName_1, "\t\t");
        } else {
            String _className_1 = this._sCTUnitCppNaming.className((EObject)it.getStatechart());
            _builder.append(_className_1, "\t\t");
        }
        _builder.append(".cpp\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\"");
        String _timerServiceFileName_2 = this._sCTUnitCppNaming.timerServiceFileName(it);
        _builder.append(_timerServiceFileName_2, "\t\t");
        _builder.append(".cpp\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append(")");
        _builder.newLine();
        _builder.append("@RunWith(GTestRunner.class)");
        _builder.newLine();
        _builder.append("public class ");
        String _testClassName = this._sCTUnitCppNaming.testClassName((SCTUnitElement)it);
        _builder.append(_testClassName);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        boolean _isMockingRequired_1 = this._cppMockingExtensions.isMockingRequired(it);
        if (_isMockingRequired_1) {
            _builder.append("protected final GTestHelper helper = new GMockHelper(this);");
            _builder.newLine();
        } else {
            _builder.append("protected final GTestHelper helper = new GTestHelper(this, Compiler.GPLUSPLUS);");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Before");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setUp() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("helper.generate();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("helper.compile();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public String asPath(String namespace) {
        if (namespace != null && !namespace.isEmpty()) {
            String _replace = namespace.replace(".", "/");
            return _replace + "/";
        }
        return "";
    }

    protected CharSequence _generateTest(SCTUnitSuite it, String targetProjectString) {
        boolean _not;
        StringConcatenation _xblockexpression = null;
        Iterable prop = this._baseNavigationExtensions.getSCTUnitClasses(it);
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._cSCTUnitGenmodelEntries.getLicenseText(this.entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        _builder.append(targetProjectString);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this._sCTUnitCppNaming.namespace((Declaration)this._baseNavigationExtensions.getTestPackage((SCTUnitElement)it)).toString());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append(".");
        }
        CharSequence _namespace = this._sCTUnitCppNaming.namespace((Declaration)it);
        _builder.append((Object)_namespace);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("import org.junit.runner.RunWith;");
        _builder.newLine();
        _builder.append("import org.junit.runners.Suite;");
        _builder.newLine();
        _builder.append("import org.junit.runners.Suite.SuiteClasses;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@RunWith(Suite.class)");
        _builder.newLine();
        _builder.append("@SuiteClasses({");
        _builder.newLine();
        boolean _hasElements = false;
        for (SCTUnitClass group : prop) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append("\t");
            if (group != null) {
                String _testClassName = this._sCTUnitCppNaming.testClassName((SCTUnitElement)group);
                _builder.append(_testClassName, "\t");
                _builder.append(".class");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append("})");
        _builder.newLine();
        _builder.append("public class ");
        String _testClassName_1 = this._sCTUnitCppNaming.testClassName((SCTUnitElement)it);
        _builder.append(_testClassName_1);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected boolean isTimed(SCTUnitClass it) {
        Functions.Function1 _function = it_1 -> it_1 instanceof TimeEventSpec;
        EObject _findFirst = (EObject)IteratorExtensions.findFirst((Iterator)it.getStatechart().eAllContents(), (Functions.Function1)_function);
        return _findFirst != null;
    }

    protected String getModelFromUri(URI uri) {
        Object model = uri.segment(2);
        int i = 3;
        while (i < uri.segmentsList().size()) {
            String _segment = uri.segment(i);
            String _plus = (String)model + "/" + _segment;
            model = _plus;
            ++i;
        }
        return model;
    }

    @XbaseGenerated
    public CharSequence generateTest(SCTUnitElement it, String targetProjectString) {
        if (it instanceof SCTUnitClass) {
            return this._generateTest((SCTUnitClass)it, targetProjectString);
        }
        if (it instanceof SCTUnitSuite) {
            return this._generateTest((SCTUnitSuite)it, targetProjectString);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, targetProjectString).toString());
    }
}

