/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.c.extensions;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.IntLiteral;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Parameter;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.generator.c.extensions.Naming;
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.concepts.EventQueue;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sctunit.generator.base.extensions.BaseMockingExtensions;
import com.yakindu.sctunit.generator.base.extensions.BaseStatementExtensions;
import com.yakindu.sctunit.generator.c.extensions.MockClassExtension;
import com.yakindu.sctunit.generator.c.extensions.SCTUnitCNaming;
import com.yakindu.sctunit.inferrer.TypesProvider;
import com.yakindu.sctunit.sCTUnit.MockReturnStatement;
import com.yakindu.sctunit.sCTUnit.MockingStatement;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class CMockingExtensions
extends BaseMockingExtensions {
    @Inject
    @Extension
    protected MockClassExtension _mockClassExtension;
    @Inject
    @Extension
    protected SCTUnitCNaming _sCTUnitCNaming;
    @Inject
    @Extension
    protected Naming _naming;
    @Inject
    @Extension
    private ICodegenTypeSystemAccess _iCodegenTypeSystemAccess;
    @Inject
    protected TypesProvider provider;
    @Inject
    @Extension
    protected BaseStatementExtensions _baseStatementExtensions;
    @Inject
    @Extension
    protected EventQueue _eventQueue;
    @Inject(optional=true)
    private ExecutionFlow flow;

    public ITypeSystem getTypeSystem(EObject context) {
        return this.provider.getTypeSystem(context);
    }

    public CharSequence initializeOperationMocks(SCTUnitOperation it) {
        StringConcatenation _xblockexpression = null;
        Set<Operation> operations = this.getAllOperations(this.getAllMockStatementsInOperation(it));
        StringConcatenation _builder = new StringConcatenation();
        for (Operation op : operations) {
            CharSequence _initializeOperationMock = this.initializeOperationMock(op, this.isOperationForStatement(this._baseNavigationExtensions.getSCTUnitClass(it), op, MockReturnStatement.class));
            _builder.append((Object)_initializeOperationMock);
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence resetOperationMocks(SCTUnitOperation it) {
        StringConcatenation _xblockexpression = null;
        Set<Operation> operations = this.getAllOperations(this.getAllMockStatementsInOperation(it));
        StringConcatenation _builder = new StringConcatenation();
        List _reverse = ListExtensions.reverse((List)IterableExtensions.toList(operations));
        for (Operation op : _reverse) {
            CharSequence _resetOperationMock = this.resetOperationMock(op);
            _builder.append((Object)_resetOperationMock);
            _builder.newLineIfNotEmpty();
        }
        List _reverse_1 = ListExtensions.reverse((List)IterableExtensions.toList(operations));
        for (Operation op_1 : _reverse_1) {
            CharSequence _freeOperationMock = this.freeOperationMock(op_1);
            _builder.append((Object)_freeOperationMock);
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateOperationMockClasses(SCTUnitClass it) {
        StringConcatenation _builder = new StringConcatenation();
        Set<Operation> _allOperations = this.getAllOperations(this.getAllMockStatementsInClass(it));
        for (Operation op : _allOperations) {
            CharSequence _generateMockClass = this._mockClassExtension.generateMockClass(op, this.getAllMockStatementsForOperation(it, op), it);
            _builder.append((Object)_generateMockClass);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateVerifyCalled(VerifyCalledStatement it) {
        CharSequence _xifexpression = null;
        boolean _isNegated = it.isNegated();
        boolean _not = !_isNegated;
        _xifexpression = _not ? this.generatePositiveVerify(it) : this.generateNegativeVerify(it);
        return _xifexpression;
    }

    protected CharSequence generatePositiveVerify(VerifyCalledStatement it) {
        boolean _tripleNotEquals;
        StringConcatenation _xblockexpression = null;
        EList<Expression> params = this.getExpressions(it.getReference());
        StringConcatenation _builder = new StringConcatenation();
        IntLiteral _times = it.getTimes();
        boolean bl = _tripleNotEquals = _times != null;
        if (_tripleNotEquals) {
            _builder.append("EXPECT_TRUE(");
            CharSequence _operationMockObjectName = this._sCTUnitCNaming.operationMockObjectName(this._mockClassExtension.getOperationOfMockStatement((MockingStatement)it));
            _builder.append((Object)_operationMockObjectName);
            _builder.append("->calledAtLeast(");
            long _value = it.getTimes().getValue();
            _builder.append((Object)_value);
            for (Expression param : params) {
                _builder.append(", ");
                CharSequence _code = this._baseExpressionExtensions.code((EObject)param);
                _builder.append((Object)_code);
            }
            _builder.append("));");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("EXPECT_TRUE(");
            CharSequence _operationMockObjectName_1 = this._sCTUnitCNaming.operationMockObjectName(this._mockClassExtension.getOperationOfMockStatement((MockingStatement)it));
            _builder.append((Object)_operationMockObjectName_1);
            _builder.append("->calledAtLeastOnce(");
            boolean _hasElements = false;
            for (Expression param_1 : params) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _code_1 = this._baseExpressionExtensions.code((EObject)param_1);
                _builder.append((Object)_code_1);
            }
            _builder.append("));");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence generateNegativeVerify(VerifyCalledStatement it) {
        StringConcatenation _xblockexpression = null;
        EList<Expression> params = this.getExpressions(it.getReference());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("EXPECT_FALSE(");
        CharSequence _operationMockObjectName = this._sCTUnitCNaming.operationMockObjectName(this._mockClassExtension.getOperationOfMockStatement((MockingStatement)it));
        _builder.append((Object)_operationMockObjectName);
        _builder.append("->calledAtLeastOnce(");
        boolean _hasElements = false;
        for (Expression param : params) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _code = this._baseExpressionExtensions.code((EObject)param);
            _builder.append((Object)_code);
        }
        _builder.append("));");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateMock(MockReturnStatement it) {
        boolean _tripleEquals;
        StringConcatenation _xblockexpression = null;
        Expression _value = it.getValue();
        boolean bl = _tripleEquals = _value == null;
        if (_tripleEquals) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(this.getExpressions(it.getReference()));
        if (_isNullOrEmpty) {
            CharSequence _operationMockObjectName = this._sCTUnitCNaming.operationMockObjectName(this._mockClassExtension.getOperationOfMockStatement((MockingStatement)it));
            _builder.append((Object)_operationMockObjectName);
            _builder.append("->setDefaultBehavior(&");
            CharSequence _operationMockClassName = this._sCTUnitCNaming.operationMockClassName(this._mockClassExtension.getOperationOfMockStatement((MockingStatement)it));
            _builder.append((Object)_operationMockClassName);
            _builder.append("::");
            CharSequence _functionNameForReturnStatement = this._mockClassExtension.functionNameForReturnStatement(it);
            _builder.append((Object)_functionNameForReturnStatement);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _operationMockObjectName_1 = this._sCTUnitCNaming.operationMockObjectName(this._mockClassExtension.getOperationOfMockStatement((MockingStatement)it));
            _builder.append((Object)_operationMockObjectName_1);
            _builder.append("->");
            CharSequence _setReturnBehavior = this._mockClassExtension.setReturnBehavior(this._mockClassExtension.getOperationOfMockStatement((MockingStatement)it));
            _builder.append((Object)_setReturnBehavior);
            _builder.append("(");
            EList<Expression> _expressions = this.getExpressions(it.getReference());
            boolean _hasElements = false;
            for (Expression param : _expressions) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _code = this._baseExpressionExtensions.code((EObject)param);
                _builder.append((Object)_code);
            }
            _builder.append(",&");
            CharSequence _operationMockClassName_1 = this._sCTUnitCNaming.operationMockClassName(this._mockClassExtension.getOperationOfMockStatement((MockingStatement)it));
            _builder.append((Object)_operationMockClassName_1);
            _builder.append("::");
            CharSequence _functionNameForReturnStatement_1 = this._mockClassExtension.functionNameForReturnStatement(it);
            _builder.append((Object)_functionNameForReturnStatement_1);
            _builder.append(");");
        }
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence initializeOperationMock(Operation it, boolean initialize) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _operationMockObjectName = this._sCTUnitCNaming.operationMockObjectName(it);
        _builder.append((Object)_operationMockObjectName);
        _builder.append(" = new ");
        CharSequence _operationMockClassName = this._sCTUnitCNaming.operationMockClassName(it);
        _builder.append((Object)_operationMockClassName);
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        if (initialize) {
            CharSequence _operationMockObjectName_1 = this._sCTUnitCNaming.operationMockObjectName(it);
            _builder.append((Object)_operationMockObjectName_1);
            _builder.append("->initializeBehavior();");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence freeOperationMock(Operation it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("delete ");
        CharSequence _operationMockObjectName = this._sCTUnitCNaming.operationMockObjectName(it);
        _builder.append((Object)_operationMockObjectName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence resetOperationMock(Operation it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _operationMockObjectName = this._sCTUnitCNaming.operationMockObjectName(it);
        _builder.append((Object)_operationMockObjectName);
        _builder.append("->reset();");
        return _builder;
    }

    public CharSequence generateRequiredOperations(SCTUnitClass it) {
        StringConcatenation _xblockexpression = null;
        Functions.Function1 _function = s -> s.getDeclarations();
        List statechartOperations = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)it.getStatechart().getScopes(), (Functions.Function1)_function)), Operation.class));
        Functions.Function1 _function_1 = op -> {
            boolean _contains = statechartOperations.contains(op);
            return !_contains;
        };
        Iterable mockedOperations = IterableExtensions.filter(this.getAllOperations(this.getAllMockStatementsInClass(it)), (Functions.Function1)_function_1);
        StringConcatenation _builder = new StringConcatenation();
        for (Operation op2 : statechartOperations) {
            boolean _isOperationForStatement_1;
            boolean _isOperationForStatement;
            CharSequence _generateStatechartOperationSignature = this.generateStatechartOperationSignature(it, op2);
            _builder.append((Object)_generateStatechartOperationSignature);
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("SC_UNUSED(");
            CharSequence _statechartNaming = this._sCTUnitCNaming.statechartNaming();
            _builder.append((Object)_statechartNaming, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            if (!this.isOperationForStatement(it, op2, VerifyCalledStatement.class) && !this.isOperationForStatement(it, op2, MockReturnStatement.class)) {
                EList _parameters = op2.getParameters();
                for (Parameter param : _parameters) {
                    _builder.append("\t");
                    _builder.append("SC_UNUSED(");
                    String _name = param.getName();
                    _builder.append(_name, "\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
            }
            if (_isOperationForStatement = this.isOperationForStatement(it, op2, VerifyCalledStatement.class)) {
                _builder.append("\t");
                CharSequence _generateVerifyStatement = this.generateVerifyStatement(op2);
                _builder.append((Object)_generateVerifyStatement, "\t");
                _builder.newLineIfNotEmpty();
            }
            if (_isOperationForStatement_1 = this.isOperationForStatement(it, op2, MockReturnStatement.class)) {
                _builder.append("\t");
                CharSequence _generateMockReturnStatement = this.generateMockReturnStatement(op2);
                _builder.append((Object)_generateMockReturnStatement, "\t");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                CharSequence _defaultReturn = this._mockClassExtension.defaultReturn(op2.getType());
                _builder.append((Object)_defaultReturn, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
        }
        for (Operation op_1 : mockedOperations) {
            boolean _isOperationForStatement_3;
            CharSequence _generateOperationSignature = this.generateOperationSignature(op_1);
            _builder.append((Object)_generateOperationSignature);
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("SC_UNUSED(");
            CharSequence _statechartNaming_1 = this._sCTUnitCNaming.statechartNaming();
            _builder.append((Object)_statechartNaming_1, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            boolean _isOperationForStatement_2 = this.isOperationForStatement(it, op_1, VerifyCalledStatement.class);
            if (_isOperationForStatement_2) {
                _builder.append("\t");
                CharSequence _generateVerifyStatement_1 = this.generateVerifyStatement(op_1);
                _builder.append((Object)_generateVerifyStatement_1, "\t");
                _builder.newLineIfNotEmpty();
            }
            if (_isOperationForStatement_3 = this.isOperationForStatement(it, op_1, MockReturnStatement.class)) {
                _builder.append("\t");
                CharSequence _generateMockReturnStatement_1 = this.generateMockReturnStatement(op_1);
                _builder.append((Object)_generateMockReturnStatement_1, "\t");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                CharSequence _defaultReturn_1 = this._mockClassExtension.defaultReturn(op_1.getType());
                _builder.append((Object)_defaultReturn_1, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence generateStatechartOperationSignature(SCTUnitClass it, Operation op) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(op.getTypeSpecifier());
        _builder.append(_targetLanguageName);
        _builder.append(" ");
        String _asFunction = this._naming.asFunction(op);
        _builder.append(_asFunction);
        _builder.append("(");
        boolean _requiresIncomingEventQueue = this._eventQueue.requiresIncomingEventQueue(this.flow);
        boolean bl = _not = !_requiresIncomingEventQueue;
        if (_not) {
            _builder.append("const ");
        }
        String _type = this._naming.type((Notifier)this.getContainerOfType((EObject)op, Statechart.class));
        _builder.append(_type);
        _builder.append("* ");
        CharSequence _statechartNaming = this._sCTUnitCNaming.statechartNaming();
        _builder.append((Object)_statechartNaming);
        EList _parameters = op.getParameters();
        for (Parameter param : _parameters) {
            _builder.append(", const ");
            String _targetLanguageName_1 = this._iCodegenTypeSystemAccess.getTargetLanguageName(param.getType());
            _builder.append(_targetLanguageName_1);
            _builder.append(" ");
            String _name = param.getName();
            _builder.append(_name);
        }
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateOperationSignature(Operation it) {
        StringConcatenation _builder = new StringConcatenation();
        String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(it.getTypeSpecifier());
        _builder.append(_targetLanguageName);
        _builder.append(" ");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append("(");
        EList _parameters = it.getParameters();
        boolean _hasElements = false;
        for (Parameter param : _parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _targetLanguageName_1 = this._iCodegenTypeSystemAccess.getTargetLanguageName(param.getTypeSpecifier());
            _builder.append(_targetLanguageName_1);
            _builder.append(" ");
            String _name_1 = param.getName();
            _builder.append(_name_1);
        }
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateVerifyStatement(Operation it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _operationMockObjectName = this._sCTUnitCNaming.operationMockObjectName(it);
        _builder.append((Object)_operationMockObjectName);
        _builder.append("->");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append("(");
        EList _parameters = it.getParameters();
        boolean _hasElements = false;
        for (Parameter param : _parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _name_1 = param.getName();
            _builder.append(_name_1);
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateMockReturnStatement(Operation it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return (");
        CharSequence _operationMockObjectName = this._sCTUnitCNaming.operationMockObjectName(it);
        _builder.append((Object)_operationMockObjectName);
        _builder.append("->*(");
        CharSequence _operationMockObjectName_1 = this._sCTUnitCNaming.operationMockObjectName(it);
        _builder.append((Object)_operationMockObjectName_1);
        _builder.append("->getBehavior(");
        EList _parameters = it.getParameters();
        boolean _hasElements = false;
        for (Parameter param : _parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _name = param.getName();
            _builder.append(_name);
        }
        _builder.append(")))();");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected int indexOfStatement(MockReturnStatement it) {
        int _xblockexpression = 0;
        Operation op = this._mockClassExtension.getOperationOfMockStatement((MockingStatement)it);
        SCTUnitClass tp = (SCTUnitClass)EcoreUtil2.getContainerOfType((EObject)it, SCTUnitClass.class);
        Functions.Function1 _function = tc -> ((SCTUnitOperation)tc).getBody().getCode();
        Functions.Function1 _function_1 = stmt -> {
            Operation _operationOfMockStatement = this._mockClassExtension.getOperationOfMockStatement((MockingStatement)stmt);
            return Objects.equals(_operationOfMockStatement, op);
        };
        _xblockexpression = IterableExtensions.toList((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)tp.getFeatures(), (Functions.Function1)_function)), MockReturnStatement.class), (Functions.Function1)_function_1))).indexOf(it);
        return _xblockexpression;
    }

    protected Set<MockingStatement> getAllMockStatementsForOperation(SCTUnitClass it, Operation op) {
        Functions.Function1 _function = tc -> tc.getBody().getCode();
        Functions.Function1 _function_1 = ms -> {
            Operation _operationOfMockStatement = this._mockClassExtension.getOperationOfMockStatement((MockingStatement)ms);
            return Objects.equals(_operationOfMockStatement, op);
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)this._baseNavigationExtensions.getSCTUnitOperations(it), (Functions.Function1)_function)), MockingStatement.class), (Functions.Function1)_function_1));
    }

    public boolean isOperationForStatement(SCTUnitClass it, Operation op, Class<? extends MockingStatement> statement) {
        Functions.Function1 _function = vs -> this._mockClassExtension.getOperationOfMockStatement((MockingStatement)vs);
        return IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)EcoreUtil2.getAllContentsOfType((EObject)it, MockingStatement.class), statement), (Functions.Function1)_function)).contains(op);
    }

    protected boolean isTypeString(Parameter it) {
        ITypeSystem _typeSystem = this.getTypeSystem((EObject)it);
        Type _type = it.getType();
        Type _originType = null;
        if (_type != null) {
            _originType = _type.getOriginType();
        }
        return _typeSystem.isSame(_originType, this.getTypeSystem((EObject)it).getType("string"));
    }

    protected EList<Expression> _getExpressions(Expression it) {
        return null;
    }

    public Set<Operation> getAllOperations(List<MockingStatement> allMockReturns) {
        Functions.Function1 _function = it -> this._mockClassExtension.getOperationOfMockStatement((MockingStatement)it);
        return IterableExtensions.toSet((Iterable)ListExtensions.map(allMockReturns, (Functions.Function1)_function));
    }

    protected EList<Expression> _getExpressions(ElementReferenceExpression it) {
        return it.getExpressions();
    }

    protected EList<Expression> _getExpressions(FeatureCall it) {
        return it.getExpressions();
    }

    public List<MockingStatement> getAllMockStatementsInClass(SCTUnitClass it) {
        Functions.Function1 _function = it_1 -> this.getAllMockStatementsInOperation((SCTUnitOperation)it_1);
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)this._baseNavigationExtensions.getSCTUnitOperations(it), (Functions.Function1)_function)));
    }

    public List<MockingStatement> getAllMockStatementsInOperation(SCTUnitOperation it) {
        return EcoreUtil2.getAllContentsOfType((EObject)it, MockingStatement.class);
    }

    @XbaseGenerated
    public EList<Expression> getExpressions(Expression it) {
        if (it instanceof ElementReferenceExpression) {
            return this._getExpressions((ElementReferenceExpression)it);
        }
        if (it instanceof FeatureCall) {
            return this._getExpressions((FeatureCall)it);
        }
        if (it != null) {
            return this._getExpressions(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

