/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.c.extensions;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Parameter;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.sct.generator.c.extensions.FileNaming;
import com.yakindu.sct.generator.c.extensions.Naming;
import com.yakindu.sct.generator.c.types.CTypes;
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.concepts.RunCycleMethod;
import com.yakindu.sct.model.sexec.naming.INamingService;
import com.yakindu.sct.model.sexec.transformation.config.IFlowConfiguration;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import com.yakindu.sct.model.stext.stext.OperationDefinition;
import com.yakindu.sctunit.generator.c.extensions.CMockingExtensions;
import com.yakindu.sctunit.generator.c.extensions.CNavigationExtensions;
import com.yakindu.sctunit.generator.c.extensions.CStatementExtensions;
import com.yakindu.sctunit.generator.c.extensions.CSubchartInitializer;
import com.yakindu.sctunit.generator.c.extensions.GenerationHelper;
import com.yakindu.sctunit.generator.c.extensions.SCTUnitCNaming;
import com.yakindu.sctunit.generator.c.features.CSCTUnitGenmodelEntries;
import com.yakindu.sctunit.sCTUnit.MockReturnStatement;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitElement;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.sCTUnit.TestStatement;
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class GTest {
    public static final String SCTUNIT_INFERRER = "com.yakindu.sctunit.generator.c.CSCTUnitGenerator.typeInferrer";
    @Inject
    @Extension
    private SCTUnitCNaming _sCTUnitCNaming;
    @Inject
    @Extension
    private ICodegenTypeSystemAccess _iCodegenTypeSystemAccess;
    @Inject
    @Extension
    private CNavigationExtensions _cNavigationExtensions;
    @Inject
    @Extension
    private CStatementExtensions _cStatementExtensions;
    @Inject
    @Extension
    private CMockingExtensions _cMockingExtensions;
    @Inject
    @Extension
    private CSCTUnitGenmodelEntries _cSCTUnitGenmodelEntries;
    @Inject
    @Extension
    private INamingService _iNamingService;
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private FileNaming _fileNaming;
    @Inject
    @Extension
    private StatechartAnnotations _statechartAnnotations;
    @Inject
    @Named(value="com.yakindu.sctunit.generator.c.CSCTUnitGenerator.typeInferrer")
    @Extension
    private ITypeSystemInferrer _iTypeSystemInferrer;
    @Inject(optional=true)
    private ExecutionFlow flow;
    @Inject
    protected GeneratorEntry entry;
    @Inject
    @Extension
    private CSubchartInitializer _cSubchartInitializer;
    @Inject
    @Extension
    private IFlowConfiguration _iFlowConfiguration;
    @Inject
    @Extension
    private RunCycleMethod _runCycleMethod;
    @Inject
    @Extension
    private GenerationHelper _generationHelper;
    @Inject
    @Extension
    protected CTypes _cTypes;

    public void generateGTest(SCTUnitClass it, IFileSystemAccess fsa, String outletFolder) {
        StringConcatenation _builder = new StringConcatenation();
        String _cc = this._sCTUnitCNaming.cc(this._sCTUnitCNaming.testClassName((SCTUnitElement)it));
        _builder.append(_cc);
        String gTestFileName = _builder.toString();
        CharSequence content = this.generateGTest(it);
        fsa.generateFile(gTestFileName, content);
    }

    private CharSequence generateGTest(SCTUnitClass it) {
        StringConcatenation _xblockexpression = null;
        this._iFlowConfiguration.defineConfigurationForStatechart(it.getStatechart());
        this._iNamingService.initializeNamingService(it.getStatechart());
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._cSCTUnitGenmodelEntries.getLicenseText(this.entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _isMockingRequired = this._cMockingExtensions.isMockingRequired(it);
        if (_isMockingRequired) {
            _builder.append("#include <algorithm>");
            _builder.newLine();
            _builder.append("#include <list>");
            _builder.newLine();
        }
        _builder.append("#include \"gtest/gtest.h\"");
        _builder.newLine();
        _builder.append("#include \"");
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this._cSCTUnitGenmodelEntries.getIdentifierModuleName(this.entry));
        if (_isNullOrEmpty) {
            String _h = this._fileNaming.h(this._fileNaming.module(it.getStatechart()));
            _builder.append(_h);
        } else {
            String _h_1 = this._fileNaming.h(this._cSCTUnitGenmodelEntries.getIdentifierModuleName(this.entry));
            _builder.append(_h_1);
        }
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        if (this.statechartHasOperations(it.getStatechart()) || this._generationHelper.isTimed(it)) {
            _builder.append("#include \"");
            boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)this._cSCTUnitGenmodelEntries.getIdentifierModuleName(this.entry));
            if (_isNullOrEmpty_1) {
                String _h_2 = this._fileNaming.h(this._fileNaming.client(this._fileNaming.module(it.getStatechart())));
                _builder.append(_h_2);
            } else {
                String _h_3 = this._fileNaming.h(this._fileNaming.client(this._cSCTUnitGenmodelEntries.getIdentifierModuleName(this.entry)));
                _builder.append(_h_3);
            }
            _builder.append("\"");
        }
        _builder.newLineIfNotEmpty();
        Iterable<Statechart> _timedSubmachines = this._generationHelper.getTimedSubmachines(it.getStatechart());
        for (Statechart submachine : _timedSubmachines) {
            _builder.append("#include \"");
            String _h_4 = this._fileNaming.h(this._fileNaming.client(this._fileNaming.module(submachine)));
            _builder.append(_h_4);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("#include \"");
        String _h_5 = this._fileNaming.h(this._sCTUnitCNaming.sc_timer_service());
        _builder.append(_h_5);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#define SC_UNUSED(P) (void)P");
        _builder.newLine();
        _builder.newLine();
        _builder.append("static ");
        String _type = this._naming.type((Notifier)it.getStatechart());
        _builder.append(_type);
        _builder.append(" ");
        CharSequence _statechartNaming = this._sCTUnitCNaming.statechartNaming();
        _builder.append((Object)_statechartNaming);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList _variableDefinitions = it.getVariableDefinitions();
        for (VariableDefinitionStatement vardef : _variableDefinitions) {
            _builder.append("static ");
            CharSequence _generate = this._cStatementExtensions.generate((TestStatement)vardef);
            _builder.append((Object)_generate);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _generateTestFixtureClass = this.generateTestFixtureClass(it);
        _builder.append((Object)_generateTestFixtureClass);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("static ");
        String _testClassName = this._sCTUnitCNaming.testClassName((SCTUnitElement)it);
        _builder.append(_testClassName);
        _builder.append(" * ");
        String _testClassObject = this._sCTUnitCNaming.testClassObject();
        _builder.append(_testClassObject);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _isMockingRequired_1 = this._cMockingExtensions.isMockingRequired(it);
        if (_isMockingRequired_1) {
            CharSequence _generateOperationMockClasses = this._cMockingExtensions.generateOperationMockClasses(it);
            _builder.append((Object)_generateOperationMockClasses);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _generateTestFixtureClassDefinition = this.generateTestFixtureClassDefinition(it);
        _builder.append((Object)_generateTestFixtureClassDefinition);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Iterable _allTestOps = this._cNavigationExtensions.getAllTestOps(it);
        for (SCTUnitOperation operation : _allTestOps) {
            _builder.append("TEST_F(");
            String _testClassName_1 = this._sCTUnitCNaming.testClassName((SCTUnitElement)it);
            _builder.append(_testClassName_1);
            _builder.append(", ");
            boolean _isIgnore = this._cNavigationExtensions.isIgnore(operation);
            if (_isIgnore) {
                _builder.append("DISABLED_");
            }
            String _name = operation.getName();
            _builder.append(_name);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _testOperationName = this._sCTUnitCNaming.testOperationName(operation);
            _builder.append(_testOperationName, "\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        boolean _isTimed = this._generationHelper.isTimed(it);
        if (_isTimed) {
            CharSequence _timerServiceFuncs = this.timerServiceFuncs(it.getStatechart());
            _builder.append((Object)_timerServiceFuncs);
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _hasTimedSubmachines = this._generationHelper.hasTimedSubmachines(it.getStatechart());
        if (_hasTimedSubmachines) {
            CharSequence _submachineTimerServiceFuncs = this.submachineTimerServiceFuncs(it.getStatechart());
            _builder.append((Object)_submachineTimerServiceFuncs);
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateRequiredOperations = this._cMockingExtensions.generateRequiredOperations(it);
        _builder.append((Object)_generateRequiredOperations);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence generateSCUnitMethodDefinitions(SCTUnitClass it) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it_1 -> this.isTestOperationCalledFromOthers((SCTUnitOperation)it_1) || !this._cNavigationExtensions.isTest((EObject)it_1);
        Iterable _filter = IterableExtensions.filter((Iterable)this._cNavigationExtensions.getSCTUnitOperations(it), (Functions.Function1)_function);
        for (SCTUnitOperation op : _filter) {
            String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(this._iTypeSystemInferrer.infer((EObject)op).getType());
            _builder.append(_targetLanguageName);
            _builder.append(" ");
            String _name = op.getName();
            _builder.append(_name);
            _builder.append("(");
            CharSequence _generateParams = this.generateParams(op);
            _builder.append((Object)_generateParams);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateMocks(SCTUnitOperation it) {
        StringConcatenation _builder = new StringConcatenation();
        Set<Operation> _allOperations = this._cMockingExtensions.getAllOperations(this._cMockingExtensions.getAllMockStatementsInOperation(it));
        for (Operation op : _allOperations) {
            CharSequence _initializeOperationMock = this._cMockingExtensions.initializeOperationMock(op, this._cMockingExtensions.isOperationForStatement(this._cNavigationExtensions.getSCTUnitClass(it), op, MockReturnStatement.class));
            _builder.append((Object)_initializeOperationMock);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateMethodBody(SCTUnitOperation it) {
        StringConcatenation _builder = new StringConcatenation();
        EList _code = it.getBody().getCode();
        for (TestStatement statement : _code) {
            CharSequence _generate = this._cStatementExtensions.generate(statement);
            _builder.append((Object)_generate);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence generateParams(SCTUnitOperation it) {
        StringConcatenation _builder = new StringConcatenation();
        EList _parameters = it.getParameters();
        boolean _hasElements = false;
        for (Parameter param : _parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(param.getTypeSpecifier());
            _builder.append(_targetLanguageName);
            _builder.append(" ");
            String _name = param.getName();
            _builder.append(_name);
        }
        return _builder;
    }

    private CharSequence timerServiceFuncs(Statechart it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        String _prefix = this._sCTUnitCNaming.prefix(it);
        _builder.append(_prefix);
        _builder.append("_set_timer(");
        String _type = this._naming.type((Notifier)it);
        _builder.append(_type);
        _builder.append("* statechart, const ");
        String _fqName = this._cTypes.sc_eventid().fqName();
        _builder.append(_fqName);
        _builder.append(" evid, const ");
        String _fqName_1 = this._cTypes.sc_time().fqName();
        _builder.append(_fqName_1);
        _builder.append(" time_ms, const ");
        String _fqName_2 = this._cTypes.sc_bool().fqName();
        _builder.append(_fqName_2);
        _builder.append(" periodic){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("tc->set_timer(statechart, evid, time_ms, periodic);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        String _prefix_1 = this._sCTUnitCNaming.prefix(it);
        _builder.append(_prefix_1);
        _builder.append("_unset_timer(");
        String _type_1 = this._naming.type((Notifier)it);
        _builder.append(_type_1);
        _builder.append("* handle, const ");
        String _fqName_3 = this._cTypes.sc_eventid().fqName();
        _builder.append(_fqName_3);
        _builder.append(" evid){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("tc->unset_timer(handle, evid);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence submachineTimerServiceFuncs(Statechart it) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<Statechart> _timedSubmachines = this._generationHelper.getTimedSubmachines(it);
        for (Statechart submachine : _timedSubmachines) {
            _builder.append("void ");
            String _firstLower = StringExtensions.toFirstLower((String)this._naming.type((Notifier)submachine).toString());
            _builder.append(_firstLower);
            _builder.append("_set_timer(");
            String _type = this._naming.type((Notifier)submachine);
            _builder.append(_type);
            _builder.append("* statechart, const ");
            String _fqName = this._cTypes.sc_eventid().fqName();
            _builder.append(_fqName);
            _builder.append(" evid, const ");
            String _fqName_1 = this._cTypes.sc_time().fqName();
            _builder.append(_fqName_1);
            _builder.append(" time_ms, const ");
            String _fqName_2 = this._cTypes.sc_bool().fqName();
            _builder.append(_fqName_2);
            _builder.append(" periodic){");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("tc->set_timer(statechart, evid, time_ms, periodic);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("void ");
            String _firstLower_1 = StringExtensions.toFirstLower((String)this._naming.type((Notifier)submachine).toString());
            _builder.append(_firstLower_1);
            _builder.append("_unset_timer(");
            String _type_1 = this._naming.type((Notifier)submachine);
            _builder.append(_type_1);
            _builder.append("* handle, const ");
            String _fqName_3 = this._cTypes.sc_eventid().fqName();
            _builder.append(_fqName_3);
            _builder.append(" evid){");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("tc->unset_timer(handle, evid);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence generateTestFixtureClass(SCTUnitClass it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("class ");
        String _testClassName = this._sCTUnitCNaming.testClassName((SCTUnitElement)it);
        _builder.append(_testClassName);
        _builder.append(" : public ::testing::Test");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* All operations from the SCTUnit test class. */");
        _builder.newLine();
        List _sCTUnitOperations = this._cNavigationExtensions.getSCTUnitOperations(it);
        for (SCTUnitOperation op : _sCTUnitOperations) {
            _builder.append("\t");
            String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(this._iTypeSystemInferrer.infer((EObject)op).getType());
            _builder.append(_targetLanguageName, "\t");
            _builder.append(" ");
            String _testOperationName = this._sCTUnitCNaming.testOperationName(op);
            _builder.append(_testOperationName, "\t");
            _builder.append("(");
            CharSequence _generateParams = this.generateParams(op);
            _builder.append((Object)_generateParams, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("void set_timer(");
        String _type = this._naming.type((Notifier)it.getStatechart());
        _builder.append(_type, "\t");
        _builder.append("* statechart, const ");
        String _fqName = this._cTypes.sc_eventid().fqName();
        _builder.append(_fqName, "\t");
        _builder.append(" evid, const ");
        String _fqName_1 = this._cTypes.sc_time().fqName();
        _builder.append(_fqName_1, "\t");
        _builder.append(" time_ms, const ");
        String _fqName_2 = this._cTypes.sc_bool().fqName();
        _builder.append(_fqName_2, "\t");
        _builder.append(" periodic);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("void unset_timer(");
        String _type_1 = this._naming.type((Notifier)it.getStatechart());
        _builder.append(_type_1, "\t");
        _builder.append("* handle, const ");
        String _fqName_3 = this._cTypes.sc_eventid().fqName();
        _builder.append(_fqName_3, "\t");
        _builder.append(" evid);");
        _builder.newLineIfNotEmpty();
        Iterable<Statechart> _timedSubmachines = this._generationHelper.getTimedSubmachines(it.getStatechart());
        for (Statechart submachine : _timedSubmachines) {
            _builder.append("\t");
            _builder.append("void set_timer(");
            String _type_2 = this._naming.type((Notifier)submachine);
            _builder.append(_type_2, "\t");
            _builder.append("* statechart, const ");
            String _fqName_4 = this._cTypes.sc_eventid().fqName();
            _builder.append(_fqName_4, "\t");
            _builder.append(" evid, const ");
            String _fqName_5 = this._cTypes.sc_time().fqName();
            _builder.append(_fqName_5, "\t");
            _builder.append(" time_ms, const ");
            String _fqName_6 = this._cTypes.sc_bool().fqName();
            _builder.append(_fqName_6, "\t");
            _builder.append(" periodic);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("void unset_timer(");
            String _type_3 = this._naming.type((Notifier)submachine);
            _builder.append(_type_3, "\t");
            _builder.append("* handle, const ");
            String _fqName_7 = this._cTypes.sc_eventid().fqName();
            _builder.append(_fqName_7, "\t");
            _builder.append(" evid);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("protected:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("sc_unit_timer_service_t *timer_service;");
        _builder.newLine();
        _builder.append("\t");
        String _subchartMemberVariables = this._cSubchartInitializer.getSubchartMemberVariables(it.getStatechart());
        _builder.append(_subchartMemberVariables, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("virtual void SetUp();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void TearDown();");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateTestFixtureClassDefinition(SCTUnitClass it) {
        StringConcatenation _builder = new StringConcatenation();
        if (this._generationHelper.isTimed(it) || this._generationHelper.hasTimedSubmachines(it.getStatechart())) {
            _builder.append("static void dispatchTimeEvent(void* handle, ");
            String _fqName = this._cTypes.sc_eventid().fqName();
            _builder.append(_fqName);
            _builder.append(" evid)");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            boolean _isTimed = this._generationHelper.isTimed(it);
            if (_isTimed) {
                _builder.append("\t");
                _builder.append("if(handle == &");
                CharSequence _statechartNaming = this._sCTUnitCNaming.statechartNaming();
                _builder.append((Object)_statechartNaming, "\t");
                _builder.append("){");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                String _raiseTimeEventFctID = this._sCTUnitCNaming.naming.raiseTimeEventFctID(this.flow);
                _builder.append(_raiseTimeEventFctID, "\t\t");
                _builder.append("(&statechart, evid);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
            }
            _builder.newLineIfNotEmpty();
            Iterable<Statechart> _timedSubmachines = this._generationHelper.getTimedSubmachines(it.getStatechart());
            for (Statechart submachine : _timedSubmachines) {
                _builder.append("\t");
                _builder.append("if(handle == ");
                String _get = this._cSubchartInitializer.getSubmachineMap(it.getStatechart()).get(submachine);
                _builder.append(_get, "\t");
                _builder.append("){");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                String _raiseTimeEventFctID_1 = this._sCTUnitCNaming.naming.raiseTimeEventFctID(submachine);
                _builder.append(_raiseTimeEventFctID_1, "\t\t");
                _builder.append("(");
                String _get_1 = this._cSubchartInitializer.getSubmachineMap(it.getStatechart()).get(submachine);
                _builder.append(_get_1, "\t\t");
                _builder.append(", evid);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        _builder.append("void ");
        String _testClassName = this._sCTUnitCNaming.testClassName((SCTUnitElement)it);
        _builder.append(_testClassName);
        _builder.append("::SetUp()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        String _initFctID = this._sCTUnitCNaming.naming.initFctID(this.flow);
        _builder.append(_initFctID, "\t");
        _builder.append("(&");
        CharSequence _statechartNaming_1 = this._sCTUnitCNaming.statechartNaming();
        _builder.append((Object)_statechartNaming_1, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _subchartInitSequence = this._cSubchartInitializer.getSubchartInitSequence(it.getStatechart());
        _builder.append(_subchartInitSequence, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateTimerServiceInit = this.generateTimerServiceInit(it);
        _builder.append((Object)_generateTimerServiceInit, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        Set<Operation> _allOperations = this._cMockingExtensions.getAllOperations(this._cMockingExtensions.getAllMockStatementsInClass(it));
        for (Operation op : _allOperations) {
            _builder.append("\t");
            CharSequence _initializeOperationMock = this._cMockingExtensions.initializeOperationMock(op, this._cMockingExtensions.isOperationForStatement(it, op, MockReturnStatement.class));
            _builder.append((Object)_initializeOperationMock, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("tc = this;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        String _testClassName_1 = this._sCTUnitCNaming.testClassName((SCTUnitElement)it);
        _builder.append(_testClassName_1);
        _builder.append("::TearDown()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        List _reverse = ListExtensions.reverse((List)IterableExtensions.toList(this._cMockingExtensions.getAllOperations(this._cMockingExtensions.getAllMockStatementsInClass(it))));
        for (Operation op_1 : _reverse) {
            _builder.append("\t");
            CharSequence _freeOperationMock = this._cMockingExtensions.freeOperationMock(op_1);
            _builder.append((Object)_freeOperationMock, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        CharSequence _generateTimerServiceFree = this.generateTimerServiceFree(it);
        _builder.append((Object)_generateTimerServiceFree, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _subchartTeardownSequence = this._cSubchartInitializer.getSubchartTeardownSequence(it.getStatechart());
        _builder.append(_subchartTeardownSequence, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        List _sCTUnitOperations = this._cNavigationExtensions.getSCTUnitOperations(it);
        for (SCTUnitOperation op_2 : _sCTUnitOperations) {
            String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(this._iTypeSystemInferrer.infer((EObject)op_2).getType());
            _builder.append(_targetLanguageName);
            _builder.append(" ");
            String _testClassName_2 = this._sCTUnitCNaming.testClassName((SCTUnitElement)it);
            _builder.append(_testClassName_2);
            _builder.append("::");
            String _testOperationName = this._sCTUnitCNaming.testOperationName(op_2);
            _builder.append(_testOperationName);
            _builder.append("(");
            CharSequence _generateParams = this.generateParams(op_2);
            _builder.append((Object)_generateParams);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _generateMethodBody = this.generateMethodBody(op_2);
            _builder.append((Object)_generateMethodBody, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("void ");
        String _testClassName_3 = this._sCTUnitCNaming.testClassName((SCTUnitElement)it);
        _builder.append(_testClassName_3);
        _builder.append("::set_timer(");
        String _type = this._naming.type((Notifier)it.getStatechart());
        _builder.append(_type);
        _builder.append("* statechart, const ");
        String _fqName_1 = this._cTypes.sc_eventid().fqName();
        _builder.append(_fqName_1);
        _builder.append(" evid, const ");
        String _fqName_2 = this._cTypes.sc_time().fqName();
        _builder.append(_fqName_2);
        _builder.append(" time_ms, const ");
        String _fqName_3 = this._cTypes.sc_bool().fqName();
        _builder.append(_fqName_3);
        _builder.append(" periodic){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("sc_unit_timer_t timer;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("sc_unit_timer_init(&timer, time_ms, periodic, evid, statechart);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("insert_timer(tc->timer_service, timer);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        String _testClassName_4 = this._sCTUnitCNaming.testClassName((SCTUnitElement)it);
        _builder.append(_testClassName_4);
        _builder.append("::unset_timer(");
        String _type_1 = this._naming.type((Notifier)it.getStatechart());
        _builder.append(_type_1);
        _builder.append("* handle, const ");
        String _fqName_4 = this._cTypes.sc_eventid().fqName();
        _builder.append(_fqName_4);
        _builder.append(" evid){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("SC_UNUSED(handle);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("delete_task(tc->timer_service, find_time_event(tc->timer_service, evid));");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        Iterable<Statechart> _timedSubmachines_1 = this._generationHelper.getTimedSubmachines(it.getStatechart());
        for (Statechart submachine_1 : _timedSubmachines_1) {
            _builder.newLine();
            _builder.append("void ");
            String _testClassName_5 = this._sCTUnitCNaming.testClassName((SCTUnitElement)it);
            _builder.append(_testClassName_5);
            _builder.append("::set_timer(");
            String _type_2 = this._naming.type((Notifier)submachine_1);
            _builder.append(_type_2);
            _builder.append("* statechart, const ");
            String _fqName_5 = this._cTypes.sc_eventid().fqName();
            _builder.append(_fqName_5);
            _builder.append(" evid, const ");
            String _fqName_6 = this._cTypes.sc_time().fqName();
            _builder.append(_fqName_6);
            _builder.append(" time_ms, const ");
            String _fqName_7 = this._cTypes.sc_bool().fqName();
            _builder.append(_fqName_7);
            _builder.append(" periodic){");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("sc_unit_timer_t timer;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("sc_unit_timer_init(&timer, time_ms, periodic, evid, statechart);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("insert_timer(tc->timer_service, timer);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("void ");
            String _testClassName_6 = this._sCTUnitCNaming.testClassName((SCTUnitElement)it);
            _builder.append(_testClassName_6);
            _builder.append("::unset_timer(");
            String _type_3 = this._naming.type((Notifier)submachine_1);
            _builder.append(_type_3);
            _builder.append("* handle, const ");
            String _fqName_8 = this._cTypes.sc_eventid().fqName();
            _builder.append(_fqName_8);
            _builder.append(" evid){");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("SC_UNUSED(handle);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("delete_task(tc->timer_service, find_time_event(tc->timer_service, evid));");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateTimerServiceInit(SCTUnitClass it) {
        StringConcatenation _xblockexpression = null;
        boolean eventBased = this._statechartAnnotations.isEventDriven(it.getStatechart());
        long cyclePeriod = this._statechartAnnotations.getCyclePeriod((EObject)it.getStatechart());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("this->timer_service = (sc_unit_timer_service_t*)malloc(sizeof(sc_unit_timer_service_t));");
        _builder.newLine();
        _builder.append("sc_unit_timer_service_init(");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this->timer_service,");
        _builder.newLine();
        if (this._generationHelper.isTimed(it) || this._generationHelper.hasTimedSubmachines(it.getStatechart())) {
            _builder.append("\t");
            _builder.append("(sc_raise_time_event_fp) dispatchTimeEvent,");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("0,");
            _builder.newLine();
        }
        boolean _hasRunCycleFunctionAsAPI = this._runCycleMethod.hasRunCycleFunctionAsAPI((Notifier)this.flow);
        if (_hasRunCycleFunctionAsAPI) {
            _builder.append("\t");
            _builder.append("(sc_run_cycle_fp) &");
            String _runCycleFctID = this._sCTUnitCNaming.naming.runCycleFctID(this.flow);
            _builder.append(_runCycleFctID, "\t");
            _builder.append(",");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            _builder.append("NULL,");
            _builder.newLine();
        }
        _builder.append("\t");
        if (eventBased) {
            _builder.append("true");
        } else {
            _builder.append("false");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append((Object)cyclePeriod, "\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("&");
        CharSequence _statechartNaming = this._sCTUnitCNaming.statechartNaming();
        _builder.append((Object)_statechartNaming, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append(");");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence generateTimerServiceFree(SCTUnitClass it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("sc_unit_timer_service_free(");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("timer_service");
        _builder.newLine();
        _builder.append(");");
        _builder.newLine();
        return _builder;
    }

    protected boolean statechartHasOperations(Statechart it) {
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)EcoreUtil2.getAllContentsOfType((EObject)it, OperationDefinition.class));
        return !_isNullOrEmpty;
    }

    protected boolean isTestOperationCalledFromOthers(SCTUnitOperation it) {
        SCTUnitClass clazz = (SCTUnitClass)EcoreUtil2.getContainerOfType((EObject)it, SCTUnitClass.class);
        List elemRefs = EcoreUtil2.getAllContentsOfType((EObject)clazz, ElementReferenceExpression.class);
        Functions.Function1 _function = ref -> {
            EObject _reference = ref.getReference();
            return _reference instanceof SCTUnitOperation;
        };
        Functions.Function1 _function_1 = ref -> ref.getReference();
        List allOpRefs = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)elemRefs, (Functions.Function1)_function), (Functions.Function1)_function_1));
        boolean _contains = allOpRefs.contains(it);
        return _contains;
    }
}

