/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.c.extensions;

import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.TimeEventSpec;
import com.yakindu.base.types.Declaration;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sctunit.generator.base.extensions.BaseNamingExtensions;
import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions;
import com.yakindu.sctunit.generator.c.extensions.SCTUnitCNaming;
import com.yakindu.sctunit.generator.c.features.CSCTUnitGenmodelEntries;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitElement;
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite;
import com.yakindu.sctunit.sCTUnit.TestPackage;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class JUnitTest {
    @Inject
    protected SCTUnitCNaming naming;
    @Inject
    @Extension
    private BaseNamingExtensions _baseNamingExtensions;
    @Inject
    @Extension
    private BaseNavigationExtensions _baseNavigationExtensions;
    @Inject
    @Extension
    private CSCTUnitGenmodelEntries _cSCTUnitGenmodelEntries;
    @Inject
    protected GeneratorEntry entry;
    @Inject
    protected ICoreLibraryHelper helper;

    public void generateJUnitTest(TestPackage it, IFileSystemAccess fsa, String targetProjectName) {
        String targetProjectString = this.helper.getTargetProjectValue(this.entry).getStringValue();
        StringConcatenation _builder = new StringConcatenation();
        String _java = this._baseNamingExtensions.java(this.naming.testClassName(this._baseNavigationExtensions.getSCTUnitElement(it)));
        _builder.append(_java);
        String testFileName = _builder.toString();
        CharSequence content = this.generateTest(this._baseNavigationExtensions.getSCTUnitElement(it), targetProjectString);
        fsa.generateFile(testFileName, "C_JUnit_Output", content);
    }

    protected CharSequence _generateTest(SCTUnitClass it, String targetProjectString) {
        boolean _not_2;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._cSCTUnitGenmodelEntries.getLicenseText(this.entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        _builder.append(targetProjectString);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this._baseNamingExtensions.namespace((Declaration)this._baseNavigationExtensions.getTestPackage((SCTUnitElement)it)).toString());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append(".");
        }
        CharSequence _namespace = this._baseNamingExtensions.namespace((Declaration)it);
        _builder.append((Object)_namespace);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import org.junit.Before;");
        _builder.newLine();
        _builder.append("import org.junit.runner.RunWith;");
        _builder.newLine();
        _builder.append("import com.yakindu.sct.generator.c.gtest.GTest;");
        _builder.newLine();
        _builder.append("import com.yakindu.sct.generator.c.gtest.GTestRunner;");
        _builder.newLine();
        _builder.append("import com.yakindu.sct.generator.c.gtest.GTestHelper;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@GTest(");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("statechartBundle = \"");
        String _segment = it.getStatechart().eResource().getURI().segment(1);
        _builder.append(_segment, "\t");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("sourceFile = \"");
        String _targetFolderString = this._cSCTUnitGenmodelEntries.getTargetFolderString(this.entry);
        _builder.append(_targetFolderString, "\t");
        _builder.append("/");
        String _cc = this.naming.cc(this.naming.testClassName((SCTUnitElement)it));
        _builder.append(_cc, "\t");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("program = \"");
        String _targetFolderString_1 = this._cSCTUnitGenmodelEntries.getTargetFolderString(this.entry);
        _builder.append(_targetFolderString_1, "\t");
        _builder.append("/");
        boolean _isEmpty = this._cSCTUnitGenmodelEntries.getIdentifierModuleName(this.entry).isEmpty();
        boolean bl2 = _not_1 = !_isEmpty;
        if (_not_1) {
            String _identifierModuleName = this._cSCTUnitGenmodelEntries.getIdentifierModuleName(this.entry);
            _builder.append(_identifierModuleName, "\t");
        } else {
            String _className = this._baseNamingExtensions.className((EObject)it.getStatechart());
            _builder.append(_className, "\t");
        }
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("model = \"");
        String _modelFromUri = this.getModelFromUri(it.getStatechart().eResource().getURI());
        _builder.append(_modelFromUri, "\t");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("additionalFilesToCopy = {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"");
        FeatureParameterValue _libraryTargetFeature = this._cSCTUnitGenmodelEntries.getLibraryTargetFeature(this.entry);
        boolean bl3 = _tripleEquals = _libraryTargetFeature == null;
        if (_tripleEquals) {
            String _targetFolderString_2 = this._cSCTUnitGenmodelEntries.getTargetFolderString(this.entry);
            _builder.append(_targetFolderString_2, "\t\t");
        } else {
            String _libraryTargetFolderString = this._cSCTUnitGenmodelEntries.getLibraryTargetFolderString(this.entry);
            _builder.append(_libraryTargetFolderString, "\t\t");
        }
        _builder.append("/sc_unit_timer_service.c\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\"");
        FeatureParameterValue _libraryTargetFeature_1 = this._cSCTUnitGenmodelEntries.getLibraryTargetFeature(this.entry);
        boolean bl4 = _tripleEquals_1 = _libraryTargetFeature_1 == null;
        if (_tripleEquals_1) {
            String _targetFolderString_3 = this._cSCTUnitGenmodelEntries.getTargetFolderString(this.entry);
            _builder.append(_targetFolderString_3, "\t\t");
        } else {
            String _libraryTargetFolderString_1 = this._cSCTUnitGenmodelEntries.getLibraryTargetFolderString(this.entry);
            _builder.append(_libraryTargetFolderString_1, "\t\t");
        }
        _builder.append("/sc_unit_timer_service.h\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("},");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("additionalFilesToCompile = {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"");
        boolean _isEmpty_1 = this._cSCTUnitGenmodelEntries.getIdentifierModuleName(this.entry).isEmpty();
        boolean bl5 = _not_2 = !_isEmpty_1;
        if (_not_2) {
            String _identifierModuleName_1 = this._cSCTUnitGenmodelEntries.getIdentifierModuleName(this.entry);
            _builder.append(_identifierModuleName_1, "\t\t");
        } else {
            String _className_1 = this._baseNamingExtensions.className((EObject)it.getStatechart());
            _builder.append(_className_1, "\t\t");
        }
        _builder.append(".c\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\"sc_unit_timer_service.c\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append(")");
        _builder.newLine();
        _builder.append("@RunWith(GTestRunner.class)");
        _builder.newLine();
        _builder.append("public class ");
        String _testClassName = this._baseNamingExtensions.testClassName((SCTUnitElement)it);
        _builder.append(_testClassName);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected final GTestHelper helper = new GTestHelper(this);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Before");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setUp() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("helper.generate();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("helper.compile();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public String asPath(String namespace) {
        if (namespace != null && !namespace.isEmpty()) {
            String _replace = namespace.replace(".", "/");
            return _replace + "/";
        }
        return "";
    }

    protected CharSequence _generateTest(SCTUnitSuite it, String targetProjectString) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._cSCTUnitGenmodelEntries.getLicenseText(this.entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        _builder.append(targetProjectString);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this._baseNamingExtensions.namespace((Declaration)this._baseNavigationExtensions.getTestPackage((SCTUnitElement)it)).toString());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append(".");
        }
        CharSequence _namespace = this._baseNamingExtensions.namespace((Declaration)it);
        _builder.append((Object)_namespace);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("import org.junit.runner.RunWith;");
        _builder.newLine();
        _builder.append("import org.junit.runners.Suite;");
        _builder.newLine();
        _builder.append("import org.junit.runners.Suite.SuiteClasses;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@RunWith(Suite.class)");
        _builder.newLine();
        _builder.append("@SuiteClasses({");
        _builder.newLine();
        Iterable _sCTUnitClasses = this._baseNavigationExtensions.getSCTUnitClasses(it);
        boolean _hasElements = false;
        for (SCTUnitClass group : _sCTUnitClasses) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append("\t");
            String _testClassName = this._baseNamingExtensions.testClassName((SCTUnitElement)group);
            _builder.append(_testClassName, "\t");
            _builder.append(".class");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("})");
        _builder.newLine();
        _builder.append("public class ");
        String _className = this._baseNamingExtensions.className((EObject)it);
        _builder.append(_className);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected boolean isTimed(SCTUnitClass it) {
        Functions.Function1 _function = it_1 -> it_1 instanceof TimeEventSpec;
        EObject _findFirst = (EObject)IteratorExtensions.findFirst((Iterator)it.getStatechart().eAllContents(), (Functions.Function1)_function);
        return _findFirst != null;
    }

    protected String getModelFromUri(URI uri) {
        Object model = uri.segment(2);
        int i = 3;
        while (i < uri.segmentsList().size()) {
            String _segment = uri.segment(i);
            String _plus = (String)model + "/" + _segment;
            model = _plus;
            ++i;
        }
        return model;
    }

    @XbaseGenerated
    public CharSequence generateTest(SCTUnitElement it, String targetProjectString) {
        if (it instanceof SCTUnitClass) {
            return this._generateTest((SCTUnitClass)it, targetProjectString);
        }
        if (it instanceof SCTUnitSuite) {
            return this._generateTest((SCTUnitSuite)it, targetProjectString);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, targetProjectString).toString());
    }
}

