/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.c.extensions;

import com.google.inject.Inject;
import com.itemis.create.base.generator.core.types.Literals;
import com.yakindu.sct.generator.c.extensions.FileNaming;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sctunit.generator.c.extensions.GTest;
import com.yakindu.sctunit.generator.c.extensions.SCTUnitCNaming;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;

public class TimerService
extends GTest {
    @Inject
    protected GeneratorEntry entry;
    @Inject
    @Extension
    private SCTUnitCNaming _sCTUnitCNaming;
    @Inject
    @Extension
    private FileNaming _fileNaming;
    @Inject
    @Extension
    private Literals _literals;

    public void generateTimerService(SCTUnitClass it, IFileSystemAccess fsa, String outletFolder) {
        CharSequence content = this.generateTimerService(it);
        fsa.generateFile(this._fileNaming.c(this._sCTUnitCNaming.sc_timer_service()), "LIBRARY_TARGET_FOLDER", content);
    }

    private CharSequence generateTimerService(SCTUnitClass it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Timer Service Implementation for SCTUnit");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"");
        String _h = this._fileNaming.h(this._sCTUnitCNaming.sc_timer_service());
        _builder.append(_h);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include <stdlib.h>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Implementation of a timer service that uses _virtual_ time to raise time events.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* It is solely meant for use with sctunit.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void sc_unit_timer_service_init(");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("sc_unit_timer_service_t * ts,");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("sc_raise_time_event_fp raise_event_func,");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("sc_run_cycle_fp run_cycle_func,");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("sc_boolean event_driven,");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("sc_integer cycle_period,");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("void* handle");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append(")");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ts->raise_event_func = raise_event_func;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ts->tasks = 0;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ts->run_cycle_func = run_cycle_func;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ts->event_driven = event_driven;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ts->cycle_period = cycle_period;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ts->handle = handle;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ts->current_time_ms = 0;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(!ts->event_driven) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("sc_unit_timer_t run_cycle;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("sc_unit_timer_init(");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("&run_cycle,");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("ts->cycle_period,");
        _builder.newLine();
        _builder.append("\t\t\t");
        String _TRUE_LITERAL = this._literals.TRUE_LITERAL();
        _builder.append(_TRUE_LITERAL, "\t\t\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("0,");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("ts->handle);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("run_cycle.isRunCycle = ");
        String _TRUE_LITERAL_1 = this._literals.TRUE_LITERAL();
        _builder.append(_TRUE_LITERAL_1, "\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("run_cycle.priority = -1;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("insert_timer(ts, run_cycle);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void sc_unit_timer_service_free(");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("sc_unit_timer_service_t * ts");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append(")");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (ts->tasks != ");
        String _NULL_LITERAL = this._literals.NULL_LITERAL();
        _builder.append(_NULL_LITERAL, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("sc_unit_timer_task_t * next_task;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("next_task = pop_task(ts);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("while (next_task != ");
        String _NULL_LITERAL_1 = this._literals.NULL_LITERAL();
        _builder.append(_NULL_LITERAL_1, "\t\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("free(next_task);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("next_task = pop_task(ts);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("free(ts);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void sc_unit_timer_init(");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("sc_unit_timer_t * t,");
        _builder.newLine();
        _builder.append("\t");
        String _fqName = this._cTypes.sc_time().fqName();
        _builder.append(_fqName, "\t");
        _builder.append(" time_ms,");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("sc_boolean periodic,");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("sc_eventid evid,");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void* handle");
        _builder.newLine();
        _builder.append(")");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("t->rel_time_ms = time_ms;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("t->abs_time_ms = 0;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("t->periodic = periodic;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("t->pt_evid = evid;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("t->priority = 0;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("t->isRunCycle = ");
        String _FALSE_LITERAL = this._literals.FALSE_LITERAL();
        _builder.append(_FALSE_LITERAL, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("t->handle = handle;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void sc_unit_timer_service_proceed_time(sc_unit_timer_service_t * ts, sc_integer time_ms)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        String _fqName_1 = this._cTypes.sc_time().fqName();
        _builder.append(_fqName_1, "\t");
        _builder.append(" stop_time_ms = ts->current_time_ms + time_ms;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("sc_boolean processed_timer = ");
        String _FALSE_LITERAL_1 = this._literals.FALSE_LITERAL();
        _builder.append(_FALSE_LITERAL_1, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("do {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* first assume we won't process a timer */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("processed_timer = ");
        String _FALSE_LITERAL_2 = this._literals.FALSE_LITERAL();
        _builder.append(_FALSE_LITERAL_2, "\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* and then check if there is a timer to process */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if( ts->tasks != 0) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(ts->tasks->timer.abs_time_ms <= stop_time_ms) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("sc_unit_timer_task_t * next_task = pop_task(ts);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("sc_unit_timer_t next = next_task->timer;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("free(next_task);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("/* shift time to the timer absolute time */");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("ts->current_time_ms = next.abs_time_ms;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("/* reschedule periodic timer */");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("if(next.periodic) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("insert_timer(ts, next);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("/* process timer ... */");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("if(next.isRunCycle) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("ts->run_cycle_func(ts->handle);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("ts->raise_event_func(next.handle, next.pt_evid);");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("processed_timer = ");
        String _TRUE_LITERAL_2 = this._literals.TRUE_LITERAL();
        _builder.append(_TRUE_LITERAL_2, "\t\t\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} while ( processed_timer );");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* As a postcondition the current time is the time after proceeding the specified period. */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ts->current_time_ms = stop_time_ms;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void sc_unit_timer_service_proceed_cycles(sc_unit_timer_service_t * ts, sc_integer cycles)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("sc_integer elapsed_cycles = 0;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("while(elapsed_cycles < cycles) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("sc_unit_timer_task_t * next_task;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("sc_unit_timer_t next;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(ts->tasks == 0) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("next_task = pop_task(ts);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("next = next_task->timer;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("free(next_task);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("ts->current_time_ms = next.abs_time_ms;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* Repeat the event? */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(next.periodic) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("insert_timer(ts, next);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* Process event */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(next.isRunCycle) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("ts->run_cycle_func(ts->handle);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("elapsed_cycles++;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("ts->raise_event_func(next.handle, next.pt_evid);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("sc_unit_timer_t sc_unit_timer_service_proceed(sc_unit_timer_service_t * ts)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("sc_unit_timer_task_t * next_task = pop_task(ts);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("sc_unit_timer_t next = next_task->timer;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("free(next_task);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ts->current_time_ms = next.abs_time_ms;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* Repeat the event? */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(next.periodic) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("insert_timer(ts, next);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return next;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void delete_task(sc_unit_timer_service_t * ts, sc_unit_timer_task_t * task)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(!task) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(ts->tasks == task) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("ts->tasks = ts->tasks->next;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("sc_unit_timer_task_t * current = ts->tasks->next;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("sc_unit_timer_task_t * last = ts->tasks;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("while(current) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(current == task) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("last->next = current->next;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("else {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("last = last->next;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("current = current->next;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("free(task);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("sc_unit_timer_task_t * find_time_event(sc_unit_timer_service_t * ts, sc_eventid evid)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("sc_unit_timer_task_t * task = ts->tasks;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("while(task && task->timer.pt_evid != evid) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("task = task->next;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return task;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void insert_timer(sc_unit_timer_service_t * ts, sc_unit_timer_t te)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("sc_unit_timer_task_t * head = ts->tasks;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("sc_unit_timer_task_t * new_task = (sc_unit_timer_task_t *) malloc(sizeof(sc_unit_timer_task_t));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("sc_unit_timer_task_t * last = head;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("te.abs_time_ms = ts->current_time_ms + te.rel_time_ms;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("new_task->timer = te;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("new_task->next = 0;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(head == 0) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("ts->tasks = new_task;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* Check if we should put it in as first element */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(compare(&te, &(head->timer)) < 0) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("new_task->next = head;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("ts->tasks = new_task;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("head = head->next;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("while(head != 0) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(compare(&te, &(head->timer)) < 0) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("new_task->next = head;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("last->next = new_task;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("last = head;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("head = head->next;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* put it in last position */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("last->next = new_task;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("sc_unit_timer_task_t * pop_task(sc_unit_timer_service_t * ts) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("sc_unit_timer_task_t * head = ts->tasks;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(head != 0) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("ts->tasks = head->next;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return head;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* Returns negative when a needs to be raised before b, 0 when a<>b, positive when a after b */");
        _builder.newLine();
        String _fqName_2 = this._cTypes.sc_time().fqName();
        _builder.append(_fqName_2);
        _builder.append(" compare(sc_unit_timer_t * a, sc_unit_timer_t * b) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("/* smaller time_ms needs to be raised first */");
        _builder.newLine();
        _builder.append("\t");
        String _fqName_3 = this._cTypes.sc_time().fqName();
        _builder.append(_fqName_3, "\t");
        _builder.append(" result = a->abs_time_ms - b->abs_time_ms;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if(result != 0) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* bigger priority needs to be raised first */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("result = b->priority - a->priority;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

