/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.c.features;

import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.FeatureType;
import com.yakindu.sct.model.sgen.FeatureTypeLibrary;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sctunit.generator.base.features.SCTUnitFeatureValueProvider;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CSCTUnitFeatureValueProvider
extends SCTUnitFeatureValueProvider {
    private static final String VALID_IDENTIFIER_REGEX = "[_a-zA-Z][_a-zA-Z0-9]*";
    private static final String VALID_FILE_EXT_REGEX = "[a-zA-Z][a-zA-Z0-9+]*";

    public boolean isProviderFor(FeatureTypeLibrary library) {
        return "SCTUnit C Generator".equals(library.getName());
    }

    public void setDefaultValue(FeatureType featureType, FeatureParameterValue parameterValue, EObject contextElement) {
        super.setDefaultValue(featureType, parameterValue, contextElement);
        SCTUnitElement testelement = (SCTUnitElement)this.unwrap(contextElement);
        String parameterName = parameterValue.getParameter().getName();
        if (testelement instanceof SCTUnitClass) {
            Statechart statechart = ((SCTUnitClass)testelement).getStatechart();
            if (parameterName.equals("moduleName")) {
                parameterValue.setValue(this.asIdentifier(statechart.getName(), "_"));
            } else if (parameterName.equals("statemachinePrefix")) {
                parameterValue.setValue(StringExtensions.toFirstLower((String)this.asIdentifier(statechart.getName(), "_")));
            }
        }
        if (parameterName.equals("GenerateSGen")) {
            parameterValue.setValue(false);
        } else if (parameterName.equals("maxIdentifierLength")) {
            parameterValue.setValue(31);
        } else if (parameterName.equals("separator")) {
            parameterValue.setValue("_");
        } else if ("headerFilenameExtension".equals(parameterName)) {
            parameterValue.setValue("h");
        } else if ("sourceFilenameExtension".equals(parameterName)) {
            parameterValue.setValue("c");
        } else if ("testFilenameExtension".equals(parameterName)) {
            parameterValue.setValue("cc");
        } else if ("smartPointers".equals(parameterName)) {
            parameterValue.setValue(false);
        }
    }

    public IStatus validateParameterValue(FeatureParameterValue parameter) {
        IStatus superResult = super.validateParameterValue(parameter);
        if (superResult != Status.OK_STATUS) {
            return superResult;
        }
        String parameterName = parameter.getParameter().getName();
        if ("moduleName".equals(parameterName)) {
            if (!parameter.getStringValue().matches(VALID_IDENTIFIER_REGEX)) {
                return this.error("Invalid module name");
            }
        } else if ("statemachinePrefix".equals(parameterName)) {
            if (!parameter.getStringValue().matches(VALID_IDENTIFIER_REGEX)) {
                return this.error("Invalid function prefix name");
            }
        } else if ("separator".equals(parameterName)) {
            if (!parameter.getStringValue().matches(VALID_IDENTIFIER_REGEX)) {
                return this.error("Invalid separator");
            }
        } else if ("headerFilenameExtension".equals(parameterName) ? !parameter.getStringValue().matches(VALID_FILE_EXT_REGEX) : ("sourceFilenameExtension".equals(parameterName) ? !parameter.getStringValue().matches(VALID_FILE_EXT_REGEX) : "testFilenameExtension".equals(parameterName) && !parameter.getStringValue().matches(VALID_FILE_EXT_REGEX))) {
            return this.error("Invalid filename extension");
        }
        return Status.OK_STATUS;
    }

    private String asIdentifier(String it, String separator) {
        return it.replaceAll("[[^a-z]&&[^A-Z]&&[^0-9]]", separator);
    }
}

