/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sexec.extensions;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.util.ExpressionExtensions;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Direction;
import com.yakindu.base.types.Event;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.TypeBuilder;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.adapter.OriginTracing;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.concepts.ShadowMemberScope;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sgraph.util.StatechartUtil;
import com.yakindu.sct.model.stext.stext.EventDefinition;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import com.yakindu.sct.model.stext.stext.InternalScope;
import com.yakindu.sct.model.stext.stext.StatechartScope;
import com.yakindu.sct.model.stext.stext.StextFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class ShadowEventExtensions {
    @Inject
    @Extension
    private ShadowMemberScope _shadowMemberScope;
    @Inject
    @Extension
    private OriginTracing _originTracing;
    @Inject
    @Extension
    private SExecExtensions _sExecExtensions;
    @Inject
    @Extension
    private ExpressionExtensions _expressionExtensions;
    @Inject
    @Extension
    private StatechartUtil _statechartUtil;
    @Inject
    @Extension
    private TypeBuilder _typeBuilder;
    @Extension
    private StextFactory _stextFactory = StextFactory.eINSTANCE;
    private final HashMap<ArrayList<?>, EventDefinition> _createCache_createShadowEvent = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, EventDefinition> _createCache_createLocalOutEvent = CollectionLiterals.newHashMap();

    public Iterable<Event> getShadowEvents(Property member) {
        Functions.Function1 _function = it -> this._originTracing.getOriginTraces((EObject)it).contains(member);
        return IterableExtensions.filter(this.getShadowEvents(this._sExecExtensions.flow((EObject)member)), (Functions.Function1)_function);
    }

    public Event getShadowEvent(Property member, Event outEvent) {
        Functions.Function1 _function = it -> this._originTracing.getOriginTraces((EObject)it).contains(outEvent);
        return (Event)IterableExtensions.findFirst(this.getShadowEvents(member), (Functions.Function1)_function);
    }

    public Iterable<Event> getShadowEvents(ExecutionFlow it) {
        Functions.Function1 _function = e -> this.isShadowEvent((Event)e);
        return IterableExtensions.filter(this._sExecExtensions.getAllEvents(it), (Functions.Function1)_function);
    }

    public boolean isShadowEvent(Event it) {
        return Objects.equals(it.getDirection(), Direction.IN) && this._sExecExtensions.scope((EObject)it) instanceof InternalScope;
    }

    public Iterable<Event> getShadowEvents(StatechartScope it) {
        Functions.Function1 _function = it_1 -> IterableExtensions.toList(this.getShadowEvents(this._sExecExtensions.flow((EObject)this._sExecExtensions.scope((EObject)it_1)))).contains(it_1);
        return Iterables.filter((Iterable)IterableExtensions.filter((Iterable)it.getMembers(), (Functions.Function1)_function), Event.class);
    }

    public Map<InterfaceScope, List<Event>> getShadowEventsByScope(Property member) {
        Functions.Function1 _function = it -> {
            EObject _eContainer = ((Event)IterableExtensions.head((Iterable)Iterables.filter((Iterable)this._originTracing.getOriginTraces((EObject)it), Event.class))).eContainer();
            return (InterfaceScope)_eContainer;
        };
        return IterableExtensions.groupBy(this.getShadowEvents(member), (Functions.Function1)_function);
    }

    public String getShadowEventName(FeatureCall fc) {
        Functions.Function1 _function = it -> this._expressionExtensions.featureOrReference((Expression)it);
        Functions.Function1 _function_1 = it -> it.getName();
        return IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)this._expressionExtensions.toCallStack((Expression)fc), (Functions.Function1)_function), NamedElement.class), (Functions.Function1)_function_1), (CharSequence)"_");
    }

    public boolean needsShadowEventMapping(Property member) {
        return this._sExecExtensions.flow((EObject)member) != null && this._statechartUtil.isOriginStatechart((EObject)member.getType()) && !IterableExtensions.isNullOrEmpty(this.getShadowEvents(member));
    }

    public Event getOutEvent(Event shadowEvent) {
        Functions.Function1 _function = it -> {
            Direction _direction = it.getDirection();
            return Objects.equals(_direction, Direction.OUT);
        };
        return (Event)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)this._originTracing.getOriginTraces((EObject)shadowEvent), Event.class), (Functions.Function1)_function));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventDefinition createShadowEvent(String shadowEventName, EObject member, Event originEvent, ExecutionFlow flow) {
        EventDefinition _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{shadowEventName, member, originEvent, flow});
        HashMap<ArrayList<?>, EventDefinition> hashMap = this._createCache_createShadowEvent;
        synchronized (hashMap) {
            EventDefinition _createEventDefinition;
            if (this._createCache_createShadowEvent.containsKey(_cacheKey)) {
                return this._createCache_createShadowEvent.get(_cacheKey);
            }
            _result = _createEventDefinition = StextFactory.eINSTANCE.createEventDefinition();
            this._createCache_createShadowEvent.put(_cacheKey, _result);
        }
        this._init_createShadowEvent(_result, shadowEventName, member, originEvent, flow);
        return _result;
    }

    private void _init_createShadowEvent(EventDefinition it, String shadowEventName, EObject member, Event originEvent, ExecutionFlow flow) {
        it.setName(shadowEventName);
        it.setDirection(Direction.IN);
        it.setTypeSpecifier((TypeSpecifier)EcoreUtil.copy((EObject)originEvent.getTypeSpecifier()));
        if (it.getType() != null && !Objects.equals(it.getType(), this._typeBuilder._void())) {
            this._typeBuilder._meta((Declaration)it, (Declaration)this._typeBuilder._variable("value", it.getType()));
        }
        this._originTracing.traceOrigin((EObject)it, IterableExtensions.head((Iterable)Iterables.filter((Iterable)this._originTracing.getOriginTraces((EObject)originEvent), Event.class)));
        this._originTracing.traceOrigin((EObject)it, (Object)member);
        EList _members = this._shadowMemberScope.shadowMemberScope(flow).getMembers();
        _members.add((Object)it);
    }

    public String getLocalOutEventName(Event outEvent) {
        String _xblockexpression = null;
        EObject _eContainer = outEvent.eContainer();
        InterfaceScope scope = (InterfaceScope)_eContainer;
        String _name = scope.getName();
        String _name_1 = outEvent.getName();
        String _join = IterableExtensions.join((Iterable)IterableExtensions.filterNull(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_name, _name_1}))), (CharSequence)"_");
        _xblockexpression = "local_" + _join;
        return _xblockexpression;
    }

    public EventDefinition getLocalOutEvent(Event outEvent) {
        Functions.Function1 _function = it -> this._originTracing.getOriginTraces((EObject)it).contains(outEvent);
        return (EventDefinition)IterableExtensions.findFirst(this._sExecExtensions.getLocalEvents(this._sExecExtensions.flow((EObject)outEvent)), (Functions.Function1)_function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventDefinition createLocalOutEvent(String localEventName, Event originEvent, ExecutionFlow flow) {
        EventDefinition _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{localEventName, originEvent, flow});
        HashMap<ArrayList<?>, EventDefinition> hashMap = this._createCache_createLocalOutEvent;
        synchronized (hashMap) {
            EventDefinition _createEventDefinition;
            if (this._createCache_createLocalOutEvent.containsKey(_cacheKey)) {
                return this._createCache_createLocalOutEvent.get(_cacheKey);
            }
            _result = _createEventDefinition = StextFactory.eINSTANCE.createEventDefinition();
            this._createCache_createLocalOutEvent.put(_cacheKey, _result);
        }
        this._init_createLocalOutEvent(_result, localEventName, originEvent, flow);
        return _result;
    }

    private void _init_createLocalOutEvent(EventDefinition it, String localEventName, Event originEvent, ExecutionFlow flow) {
        it.setName(localEventName);
        it.setDirection(Direction.LOCAL);
        it.setTypeSpecifier((TypeSpecifier)EcoreUtil.copy((EObject)originEvent.getTypeSpecifier()));
        if (it.getType() != null && !Objects.equals(it.getType(), this._typeBuilder._void())) {
            this._typeBuilder._meta((Declaration)it, (Declaration)this._typeBuilder._variable("value", it.getType()));
        }
        this._originTracing.traceOrigin((EObject)it, (Object)originEvent);
        EList _members = this.getOrCreateInternalScope(flow).getMembers();
        _members.add((Object)it);
    }

    protected InternalScope getOrCreateInternalScope(ExecutionFlow it) {
        boolean _not;
        InternalScope _xblockexpression = null;
        boolean _hasInternalScope = this._sExecExtensions.hasInternalScope(it);
        boolean bl = _not = !_hasInternalScope;
        if (_not) {
            EList _scopes = it.getScopes();
            InternalScope _createInternalScope = this._stextFactory.createInternalScope();
            _scopes.add((Object)_createInternalScope);
        }
        _xblockexpression = this._sExecExtensions.getInternalScope(it);
        return _xblockexpression;
    }

    public boolean isLocalOutEvent(Event it) {
        return Objects.equals(it.getDirection(), Direction.LOCAL) && this._sExecExtensions.exists(IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)this._originTracing.getOriginTraces((EObject)it), Event.class), it_1 -> {
            Direction _direction = it_1.getDirection();
            return _direction == Direction.OUT;
        })));
    }
}

